      SUBROUTINE  fit1(mode,length)
c
c...Fit FIND1 Pairs Using Smoothing Spline
c
      INCLUDE
     *            'phcal.inc'
      PARAMETER
     *            trivial = 0.01D00
      INTEGER
     *            i, j, mode, ier
      DOUBLE PRECISION
     *            yvar, t, x, dx, dy, length, halfwide
c
 9001 FORMAT (' Too Few Points In FIT1 ', i10)
 9002 FORMAT (' CUBGCV in FIT1 Returns IER=', i10)
c
c...Sanity Check
c
  100 IF (np.le.5) THEN
        WRITE (*,9001) np
        RETURN
      ENDIF
c
c...Sort Pairs On X
c
      DO i=1,np
        jdx(i) = i
      ENDDO
      CALL iuqsrt(np,px,jdx)
      CALL ireord(np,jdx,py,tmp)
      CALL ireord(np,jdx,pr,tmp)
      CALL ireord(np,jdx,pq,tmp)
      CALL ireord(np,jdx,ps,tmp)
c
c...Load Into DP Variables Resolving Equlaities
c
      nspl = 0
      DO i=1,np
        IF (infit(i).ne.0) THEN
          nspl = nspl+1
          splx(nspl) = px(i)
          sply(nspl) = py(i)
          IF (nspl.gt.1) THEN
            IF (splx(nspl).le.splx(nspl-1)) THEN
              splx(nspl) = splx(nspl-1)+TRIVIAL
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Sanity Check
c
      CALL sanity
c
c...Optional Smoothing
c
      IF (mode.ne.0) THEN
        halfwide = MIN(75.0D00,MAX(25.0D00,2200.0D00/nspl))
        CALL smooth(halfwide)
      ENDIF
c
c...Add Extra Begin And End Points To Force Slope To Be Nearly Zero
c
      DO i=1,3
        splx(nspl+3+i) = splx(nspl) + 100.0D00*(i  )
        sply(nspl+3+i) = sply(nspl)
      ENDDO
      DO i=nspl,1,-1
        splx(3+i) = splx(i)
        sply(3+i) = sply(i)
      ENDDO
      DO i=1,3
        splx(i) = splx(4) - 100.0D00*(4-i)
        sply(i) = sply(4)
      ENDDO
      nspl = nspl+6
c
c...Compute Smoothing Spline
c
      DO i=1,nspl
        yw(i) = 1.0D00
      ENDDO
      yvar = -1.0D00
      CALL cubgcv(splx,sply,yw,nspl, yc,ycoef,NCODIM,
     *            yvar,0,se,wk,ier)
      IF (ier.ne.0) THEN
        WRITE (*,9002) ier
        CALL EXIT
      ENDIF
      DO i=1,nspl
        se(i) = sply(i)-yc(i)
      ENDDO
      length = 0.0D00
      DO i=5,nspl-3
        length = length + ABS(yc(i)-yc(i-1))
      ENDDO
      length = 1000.0D00*length/(splx(nspl-3)-splx(4))
c
c...Fill The FIT Delta Magnitude Array
c
      j = 1
      DO i=BRIGHTMAG,FAINTMAG
        x = i
  110   IF (x.lt.splx(j)) THEN
          fitdm(i) = yc(1)
        ELSEIF ((x.ge.splx(j)).and.(x.le.splx(j+1))) THEN
          dx = x-splx(j)
          fitdm(i) = yc(j)
     *             + dx*(ycoef(j,1) + dx*(ycoef(j,2) + dx*ycoef(j,3)))
        ELSE
          j = j+1
          IF (j.lt.nspl) THEN
            GO TO 110
          ELSE
            GO TO 120
          ENDIF
        ENDIF
      ENDDO
  120 IF (i.le.FAINTMAG) THEN
        DO j=i,FAINTMAG
          fitdm(j) = yc(nspl)
        ENDDO
      ENDIF
      RETURN
      END
