      program apcm
c
c "PMM Coordinate Matcher"  Finds best matches between the PMM
c coordinate & instrumental magnitude list and a field star photometric
c standard list.
c Pass 1:  make match as closest to center of error box.
c Pass 2:  fit template curve to matches, identify and attempt to rematch
c	outliers.
c Pass 3:  fit general curve to the photometric data.
c Pass 4:  Use general curve as the new template, redo Pass 2 & 3
c
c This updated version uses the duNNNN.ird, .fit, files; also
c the sjNNNN.inf and .dat files.  The du files are like the original
c cu astrometric processed files, except that the taffogram residuals
c have been removed.
c
c This version uses Legendre polynomials instead of regular polynomials.
c
c This version automatically looks for du files not processed.
c This version uses two standards files.
c This version writes final zero point fit to file.
c
      include 'std.inc'
      include 'pcm.inc'
c
      real*8 pmmra(MAXSTARS), pmmdec(MAXSTARS), stdra(MP), stddec(MP),
     & picon, wksp(MAXSTARS), scale, fld0ra, fld0dec, twopi
      REAL*8 ralo, rahi, declo, dechi
      real*4 rwksp(MAXSTARS), erradius,
     & dmag, newdmag, fsc, frasc, colors(6,MP), NOMAG, thedmag(MP),
     & sdev(2), acoeff(4), resid(MP), zcoeff(4),
     & NOMICR, stdmagmn, stdmagmx, vigmag(MP)
      REAL*4 pmmx(MAXSTARS), pmmy(MAXSTARS), pmmmag(MAXSTARS), stdmag(MP)
      integer*4 npmmobj, nstdobj, iwksp(MAXSTARS),
     & ihr, iramn, imn, idg, lut(MLUT), ipmmdx(MP), npts,
     & starnum(2,MAXSTARS), iwksp2(MAXSTARS), NONUM, stdid(MP), candct(MP),
     & pmmmatch(MP)
      INTEGER ii, pclflag
      character outfile*80, stdname(MP)*16, gscmatch(MP)*10, bname*4
      CHARACTER*60 fname
      PARAMETER MAXBAD=100
      CHARACTER badname(MAXBAD)*7
      logical graphit, found
      parameter( NOMAG=77.77, NONUM=-999999, NOMICR=888888.8 )
      integer errflg, iflag, nbad
      common/blkz/errflg
      INTEGER storage(4,MAXSTARS)
      common /blky/ storage
      common /blkw/ iwksp
      common /blku/ pmmx,pmmy,pmmmag,stdmag
      common /blkbad/ nbad,badname
      common /coefblk/ acoeff, zcoeff
      common/plimblk/ ralo, rahi, declo, dechi, pclflag
c
  1   format(a)
  2   format(t1,(a),$)
  3   format(t1,(a))
c
      write(6,5) 'P M M   C o o r d i n a t e   M a t c h e r'
  5   format(/t19,(a)/)
c
      twopi = 8.0*datan(1.0d0)
      picon= datan(1.0d0)/4.5d1
      erradius = 15.0	! arcsec
c Convert to radians
      erradius = erradius*picon/3600.0d0
c
c get badstar file
c
      nbad=0
      open (unit=1,file='badstar.txt',
     $    status='old')
      do i=1,MAXBAD
        read(1,996,end=6) badname(i)
996     format(a7)
        nbad=nbad+1
      enddo
6     continue
c
c get user input
c
      print *,'Enter starting fieldno: '
      read (5,*) nf1
      print *,'Enter ending fieldno: '
      read (5,*) nf2
      print *,'0=save, 1=overwrite existing .pcl files: '
      read (5,*) pclflag
      print *,'0=no plots, 1=plots of results: '
      read (5,*) iflag
      if (iflag.eq.1) then
        graphit = .true.
      else
        graphit = .false.
      endif
      
c
c loop over 894 possible fields
c
      do ii=nf1,nf2
        errflg=0
        write (6,9002) ii
9002    format('processing file: ',i4.4)
        write(bname,9001) ii
9001    format(i4.4)
        fname = 'sj'//bname//'.pcl'
        inquire(file=fname,exist=found)
        if (pclflag.eq.0.and.found) goto 10
        fname = '/uz6/xpmm/auxird/sj'//bname//'.ird'
        inquire(file=fname,exist=found)
        if(found) then
        write(6,3) 'Working on field '//bname//'. . .'
c set starting values for the Legendre polynomial fit
        acoeff(1) = -8.77693
        acoeff(2) = 5.44318
        acoeff(3) = -0.314534
        acoeff(4) = 0.632684e-2
c
c Read PMM data and photometric standard files
c
      call readpmm(bname,pmmra,pmmdec,pmmmag,pmmx,pmmy,starnum,npmmobj,
     & fld0ra,fld0dec)
      if (errflg.eq.1) then
          close(11)
          close(15)
          goto 10
      endif
      call readstd(stdra,stddec,stdmag,colors,nstdobj,stdid,stdname,gscmatch)
      if (errflg.eq.1) then
          close(11)
          close(15)
          goto 10
      endif
c
c Sort PMM data on PMMRA; simultaneously re-arrange PMMDEC and PMMMAG
c
      write(6,3) '. . .Sorting PMM data on RA. . .'
      call nr_sort7(npmmobj,pmmra,pmmdec,pmmmag,starnum,pmmx,pmmy,
     & wksp,rwksp,iwksp,iwksp2)
c
c Create look-up table for entry into PMMRA.
c
      write(6,3) '. . .making look-up table into RA. . .'
      call mklut(npmmobj,pmmra,lut,scale)
c
c Make first matching pass, finding PMM star closest to standard star
c within tight (typically 15 arcsec is specified) error box.
c
      call phase1a(nstdobj,stdra,stddec,scale,lut,erradius,pmmra,
     & pmmdec,pmmmag,starnum,ipmmdx,candct,'1a')
      if (errflg.eq.1) then
          close(11)
          close(15)
          goto 10
      endif
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) then
            pmmmatch(i) = starnum(1,ipmmdx(i))
         else
            pmmmatch(i) = NONUM
         end if
      end do
c
c Make second pass, attempting to rematch outliers until largest outlier
c is less than acceptable limit.
c
      call phase1b(nstdobj,stdra,stddec,stdmag,scale,lut,erradius,pmmra,
     & pmmdec,pmmmag,starnum,ipmmdx,pmmmatch,thedmag,'1b')
c
c Now do linear least squares fit with Legendre polynomials to the good
c photometric data, fitting all terms.  Report standard deviation.
c
      call phase2(nstdobj,stdmag,pmmmag,ipmmdx,resid,sdev)
      if (errflg.eq.1) then
          print *,'singular matrix solution -- abort this pcl'
          close(11)
          close(15)
          goto 10
      endif
c
c Now use the fitted function as the new template.  Use all standards, attempt
c to match stars close in distance and magnitude.
c
c First part of phase 3, matching by distance. . .
c
      call phase1a(nstdobj,stdra,stddec,scale,lut,erradius,pmmra,
     & pmmdec,pmmmag,starnum,ipmmdx,candct,'3a')
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) then
            pmmmatch(i) = starnum(1,ipmmdx(i))
         else
            pmmmatch(i) = NONUM
         end if
      end do
c
      if( graphit ) then
         call mgoinit
         call mgosetup(-6)
         call win1a(nstdobj,stdmag,pmmmag,ipmmdx)
      end if
c
c Next part of phase 3, matching by magnitude. . .
c
      call phase3(nstdobj,stdra,stddec,stdmag,scale,lut,erradius,pmmra,
     & pmmdec,pmmmag,starnum,ipmmdx,pmmmatch,thedmag)
c
      if( graphit ) then
         call win1b(nstdobj,stdmag,pmmmag,ipmmdx,zcoeff)
      end if
c
c Phase 4 uses same subroutine as phase 2.
c however, we now know approximate magnitudes for the matches, and
c can apply the vignetting function.
c
      call phase2(nstdobj,stdmag,pmmmag,ipmmdx,resid,sdev)
c
      npts = 0
      stdmagmn = 50.0
      stdmagmx = 0.0
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) then
            npts = npts + 1
            stdmagmn = min(stdmag(i),stdmagmn)
            stdmagmx = max(stdmag(i),stdmagmx)
         end if
      end do
c
      write(15,191) bname, npts, stdmagmn, stdmagmx, (sdev(i),i=1,2)
      write(15,192) (acoeff(i),i=1,4)
      write(15,192) (zcoeff(i),i=1,4)
191   format(t1,a4,1x,i4,1x,f6.3,1x,f6.3,1x,f5.3,1x,f5.3)
192   format(t1,g15.8,1x,g15.8,1x,g15.8,1x,g15.8)
      close(15)
c
      if( graphit ) then
         call win2(nstdobj,stdid,stdmag,pmmmag,ipmmdx,acoeff)
         call win3(nstdobj,stdid,stdmag,resid,ipmmdx)
         call win4(nstdobj,ipmmdx,acoeff,sdev,bname,fld0ra,fld0dec)
         call mgoprntplot(i)
      end if
c
c Report matches
c Output file is opened in subroutine READPMM
c
      do i=1,nstdobj
         if (stdra(i).ge.twopi) stdra(i) = stdra(i) - twopi
         if( ipmmdx(i) .ne. 0 ) then
            if (pmmra(ipmmdx(i)).ge.twopi)
     $        pmmra(ipmmdx(i)) = pmmra(ipmmdx(i)) - twopi
            call rad2dms(pmmra(ipmmdx(i)),asn,ihr,iramn,frasc,.true.)
            call rad2dms(pmmdec(ipmmdx(i)),asn,idg,imn,fsc,.false.)
            call vignette(pmmx(ipmmdx(i)),pmmy(ipmmdx(i)),stdmag(i),vigmag(i))
            write(11,21) pmmra(ipmmdx(i)), pmmdec(ipmmdx(i)),
     &       pmmx(ipmmdx(i)), pmmy(ipmmdx(i)),
     &       ihr, iramn, 0.001*nint(1000.0*frasc), asn, idg, imn,
     &       0.01*nint(100.0*fsc), 0.01*nint(100.0*pmmmag(ipmmdx(i))),
     &       stdmag(i), (colors(j,i),j=1,6), candct(i), thedmag(i), stdid(i),
     &       '1', stdname(i), gscmatch(i), pmmmatch(i), vigmag(i)
 21         format(t1,f11.9,1x,f12.9,1x,f8.1,1x,f8.1,1x,i2.2,i2.2,f6.3,a1,i2.2,
     &       i2.2,f5.2,1x,f5.2,1x,f6.3,1x,6(f6.3,1x),i3,1x,f6.3,1x,i1,1x,a1,1x,
     &       a16,1x,a10,1x,i7,1x,f5.3)
         else
            call rad2dms(stdra(i),asn,ihr,iramn,frasc,.true.)
            call rad2dms(stddec(i),asn,idg,imn,fsc,.false.)
            write(11,21) stdra(i), stddec(i), NOMICR, NOMICR, ihr, iramn,
     &       0.001*nint(1000.0*frasc), asn, idg, imn, 0.01*nint(100.0*fsc),
     &       NOMAG, stdmag(i), (colors(j,i),j=1,6), candct(i), thedmag(i),
     &       stdid(i), '0', stdname(i), gscmatch(i), pmmmatch(i), 9.999
         end if
      end do
      endif
10    continue
      enddo
      close(11)
      write(6,3) '. . .done.'
c
      end
c
c
c
      SUBROUTINE READPMM(bname,pmmra,pmmdec,pmmmag,pmmx,pmmy,starnum,
     & numobj,fld0ra,fld0dec)
c
      INCLUDE 'cuproc.inc'
      INCLUDE 'pcm.inc'
c
      REAL*8 ralo, rahi, declo, dechi, picon, ramn, ramx, decmn, decmx,
     & pmmra(MAXSTARS), pmmdec(MAXSTARS), fld0ra, fld0dec, twopi, pi
      real*8  xmean, ymean
      REAL*4  mag, pmmmag(MAXSTARS), dmag, pmmx(MAXSTARS),
     & pmmy(MAXSTARS)
      INTEGER*4 numobj, starnum(2,MAXSTARS)
      integer*4 i, istat, who, nfn3, i2, nlb
      real*4 val(25)
      INTEGER pclflag
      LOGICAL pclfound
      character bname*4, possline*80, fn3*64, lb*64, outfile*80
      INTEGER storage(4,MAXSTARS)
      common /blky/ storage
      integer errflg
      common/blkz/errflg
      common/plimblk/ ralo, rahi, declo, dechi, pclflag
c
  1   format(a)
  2   format(t1,(a),$)
  3   format(t1,(a))
c
      pi = 4.0*datan(1.0d0)
      twopi = 8.0*datan(1.0d0)
      picon=datan(1.0D0)/4.5d1
c
      fnout = bname
      nfnout = 4
      fn2 = '/uw0/xpmm/lists/sj'//bname//'a'
      nfn2 = 23
      fn3 = '/uz6/xpmm/auxpat/pat'//bname
      nfn3 = 24
c Open calibration file and fit file
      outfile = 'sj'//bname//'.pcl'
      inquire(file=outfile,exist=pclfound)
      if (pclfound.and.pclflag.eq.1) then
         open (unit=11,file=outfile,status='old')
         close(unit=11,status='delete')
      endif
      open(unit=11,file=outfile,status='new',err=99)
      outfile = 'sj'//bname//'.pft'
      inquire(file=outfile,exist=pclfound)
      if (pclfound.and.pclflag.eq.1) then
         open (unit=15,file=outfile,status='old')
         close(unit=15,status='delete')
      endif
      open(unit=15,file=outfile,status='new',err=99)
c Open INF file, get value of N2; read DAT file, stuff STORAGE for unpacking
      write(6,3) '. . .Reading sj'//bname//'a.inf and .dat files. . .'
      call rd_infdat(storage)
      if (errflg.eq.1) return
      n2orig = n2
c Program returns decimal RA hours, decimal Dec degrees
      write(6,3) '. . .Reading du'//bname//'.fit and .ird files. . .'
      call rd_ird(pmmra,pmmdec,starnum)
c
      write(6,3) '. . .Unpacking data from .DAT file. . .'
      numobj = n2orig
      do i=1,n2orig
         call unpack(i,val,storage)
c PMMRA will be in radians
         pmmra(i) = pmmra(i)*1.5d1*picon
         if( pmmra(i) .lt. 0.0d0 ) pmmra(i) = pmmra(i) + twopi
c PMMDEC will be in radians
         pmmdec(i) = pmmdec(i)*picon
c
c        pmmmag(i) = val(10)	! FluxMag
         pmmmag(i) = val(9)	! FitMag
c        pmmm9(i) = val(23)	! Mag9
         pmmx(i) = val(1)	! PMM X (microns)
         pmmy(i) = val(2)	! PMM Y (microns)
      end do
      write(6,21) '=> ', numobj, ' PMM objects <='
 21   format(t1,a3,i7,(a))
c
      decmn = pmmdec(1)
      decmx = pmmdec(1)
      ramn = pmmra(1)
      ramx = pmmra(1)
      do i=2,numobj
       if(pmmra(i).gt.0.0) then
         decmn = min(pmmdec(i),decmn)
         decmx = max(pmmdec(i),decmx)
         ramn = min(pmmra(i),ramn)
         ramx = max(pmmra(i),ramx)
        endif
      end do
      ralo = ramn
      rahi = ramx
      declo = decmn
      dechi = decmx
c
c the 24h-0h boundary is a special case.  Here, the ralo from above will
c be essentially zero, and rahi will be essentially twopi (24h). We need
c to reset limits and adjust ra as well by adding twopi to the crossover vals.
c
      if( rahi - ralo .gt. pi ) then
        ramn = 3.e30
        ramx = -3.e30
         do i=1,numobj
            if( pmmra(i) .lt. pi ) pmmra(i) = pmmra(i) + twopi
            ramn = min(pmmra(i),ramn)
            ramx = max(pmmra(i),ramx)
         end do
         ralo = ramn
         rahi = ramx
      end if
      write(6,9997) ralo, rahi, declo, dechi
9997  format (4f12.8)
c
      lb = fn3(1:nfn3)//'.inf'
      nlb = nfn3 + 4
      OPEN (
     &      access='sequential',
     &      carriagecontrol='list',
     &      dispose='keep',
     &      form='formatted',
     &      name=lb(1:nlb),
     &      readonly,
     &      shared,
     &      status='old',
     &      unit=22
     &     )
      read(22,9000) fld0ra,fld0dec
9000  format (29x,2f10.7)
      close(22)
      return
c
      possline = ' '
      read(22,1) possline
      close(22)
      i = 80
      do while( possline(i:i) .eq. ' ' )
         i = i - 1
      end do
      i2 = i
      do while( possline(i:i) .ne. ' ' )
         i = i - 1
      end do
      i = i - 1
      do while( possline(i:i) .ne. ' ' )
         i = i - 1
      end do
      read(possline(i:i2),*) fld0ra, fld0dec
c
      return
c
 99   write(6,3) 'Could not open file '//outfile
      stop
      end
c
c
c
      SUBROUTINE READSTD(stdra,stddec,stdmag,colors,numobj,stdid,stdname,gscmatch)
c
c Read photometric standard star files
c this two-file-read is a real kludge, just to get it working.
c
      include 'std.inc'
c
      real*8 ralo, rahi, declo, dechi, picon, stdra(MP), stddec(MP)
      real*8 pi, twopi
      REAL*4 stdmag(MP), calcmag, xx(6), colors(6,MP), tmag
      integer*4 numobj, stdid(MP)
      INTEGER pclflag
      CHARACTER fname*80, aline*83, stdorig*6, stdname(MP)*16, gscmatch(MP)*10
      PARAMETER MAXBAD=100
      CHARACTER badname(MAXBAD)*7
      integer errflg,nbad,k
      common/blkz/errflg
      common /blkbad/ nbad,badname
      common/plimblk/ ralo, rahi, declo, dechi, pclflag
c
  1   format(a)
  2   format(t1,(a),$)
  3   format(t1,(a))
c
      pi = 4.0*datan(1.0d0)
      twopi = 8.0*datan(1.0d0)
      picon=datan(1.0d0)/4.5d1
c
c Master field star photometric calibration file name
c
      fname = '/uz6/xpmm/auxubv/field.cat'
      open (unit=13,file=fname,status='old')
      write(6,3) '. . .Reading field standard file. . .'
      read (13,*)
      read (13,*)
c
      numobj = 1
c loop over all standards in file
100   read(13,901,end=200) stdname(numobj),stdra(numobj),stddec(numobj),
     & (xx(i),i=1,6)
901   format(a16,27x,2f12.8,6f7.3)
c Read the second line of the entry
      read(13,1) aline
c
c delete all 'bad' stars
c
      do k=1,nbad
        if (stdname(numobj)(2:8).eq.badname(k)) goto 100
      enddo
c
c the 24h-0h boundary is a special case.  Here, we've modified the pmm ra's
c to range from pi to 3*pi (like 24h, 25h, etc.), and rahi is greater than
c twopi (24h).  Therefore, we need to add twopi to stdra if it is less than
c pi before doing the check to see if this standard is within the plate boundary.
c
      if (rahi.ge.twopi.and.stdra(numobj).lt.pi)
     $    stdra(numobj) = stdra(numobj) + twopi
c
c note that even tho standard file is already sorted on ra, if we have a
c 24h-0h boundary plate we have to read the entire catalog.  otherwise, we can eliminate
c lot of the checking if we have advanced past rahi in the catalog
c
      if (rahi.lt.twopi.and.stdra(numobj).gt.rahi) goto 200
      if (rahi.lt.twopi.and.stdra(numobj).lt.ralo) goto 100
c
c else check hi/lo ra,dec
c
      if( ralo.le.stdra(numobj) .and. stdra(numobj).le.rahi .and.
     &  declo.le.stddec(numobj) .and. stddec(numobj).le.dechi ) then
          call fillstd(numobj,xx,colors,stdmag,stdid,gscmatch)
          if(errflg.eq.1) return
      end if
      goto 100
c get here when we've read all the standards in this file
200   close(13)
c
c Master sequence star photometric calibration file name
c
      fname = '/uz6/xpmm/auxubv/seq.cat'
      open (unit=13,file=fname,status='old')
      write(6,3) '. . .Reading sequences standard file. . .'
      read (13,*)
      read (13,*)
c
c loop over all standards in file
c
300   read(13,901,end=400) stdname(numobj),stdra(numobj),stddec(numobj),
     & (xx(i),i=1,6)
c Read the second line of the entry
      read(13,1) aline
c
c the 24h-0h boundary is a special case.  Here, we've modified the pmm ra's
c to range from pi to 3*pi (like 24h, 25h, etc.), and rahi is greater than
c twopi (24h).  Therefore, we need to add twopi to stdra if it is less than
c pi before doing the check to see if this standard is within the plate boundary.
c
      if (rahi.ge.twopi.and.stdra(numobj).lt.pi)
     $    stdra(numobj) = stdra(numobj) + twopi
c
c note that even tho standard file is already sorted on ra, if we have a
c 24h-0h boundary plate we have to read the entire catalog.  otherwise, we can eliminate
c lot of the checking if we have advanced past rahi in the catalog
c
c
      if (rahi.lt.twopi.and.stdra(numobj).gt.rahi) goto 400
      if (rahi.lt.twopi.and.stdra(numobj).lt.ralo) goto 300
c
c else check hi/lo ra,dec
c
      if( ralo.le.stdra(numobj) .and. stdra(numobj).le.rahi .and.
     &  declo.le.stddec(numobj) .and. stddec(numobj).le.dechi ) then
          call fillstd(numobj,xx,colors,stdmag,stdid,gscmatch)
          if(errflg.eq.1) return
      end if
      goto 300
c
c get here when we've read all the standards
c
400   close(13)
      numobj = numobj - 1
      write(6,21) '=> ', numobj, ' standard stars suitable for PMM matching <='
 21   format(t1,a3,i6,(a))
c
      return
      end
c
c
c
      SUBROUTINE  RD_IRD(dra,ddec,starnum)
c
c...Results In .IRD and .FIT Files
c
c Modified from Dave's dumpit.f
c
      INCLUDE
     *            'cuproc.inc'
c
      real*8 dra(NSMAX), ddec(NSMAX)
      INTEGER*4
     *            nlb, i, j, ra(NSMAX), spd(NSMAX), starnum(2,NSMAX)
      CHARACTER*64
     *            lb
c
 9002 FORMAT (2x, i10)
 9003 FORMAT (t1,'Cannot Open ', a)
 9004 FORMAT (a)
 9005 FORMAT (15i10)
 9006 FORMAT (2x, 4(1x, 1pe15.8))
c
c...Open The FIT File
c
      lb = '/uz6/xpmm/auxuj/vj'//fnout(1:nfnout)//'.fit'
      nlb = 22 + nfnout
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='old',
     *      unit=4
     *     )
      READ (4,9004) fn1
      nfn1 = 64
      do while( fn1(nfn1:nfn1) .eq. ' ' )
         nfn1 = nfn1 - 1
      end do
      READ (4,9004) fn2
      nfn2 = 64
      do while( fn2(nfn2:nfn2) .eq. ' ' )
         nfn2 = nfn2 - 1
      end do
      READ (4,9002) npair
      CLOSE (4)
c
c...Open The IRD File
c
      lb = '/uz6/xpmm/auxird/sj'//fnout(1:nfnout)//'.ird'
      nlb = 23 + nfnout
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      recl=n2orig,
     *      recordtype='fixed',
     *      status='old',
     *      unit=4
     *     )
      READ (4,rec=1) (   ra(i),i=1,n2orig)
      READ (4,rec=2) (  spd(i),i=1,n2orig)
      CLOSE (4)
c
      DO i=1,n2orig
c STARNUM(1) == index into .DAT or .IRD file, not the arbitrary star number
c STARNUM(2) == the arbitrary star number (<0 == duplicate match)
        starnum(1,i) = i
        starnum(2,i) = sign(i,ra(i))
        ra(i) = abs(ra(i))
        CALL radecinv(ra(i),spd(i),dra(i),ddec(i))
      ENDDO
      RETURN
c
c...Errors
c
  200 WRITE (*,9003) lb(1:nlb)
      RETURN
      END
c
c
c
      SUBROUTINE  RD_INFDAT(thebuf)
c
c...Fill (2) Arrays From BINARY Dump
c
      INCLUDE
     *            'cuproc.inc'
      real*4 magoffset, magslope
      INTEGER
     *            i, j, nlb, thebuf(4,NSMAX), tmpbuf(NSMAX)
      CHARACTER*64
     *            lb
      logical badtry
      common/magblk/ magoffset, magslope
      integer errflg
      common/blkz/errflg
      common/blkw/tmpbuf
c
 9001 FORMAT (t1,'BINARY File Root For (2) [', a, ']: ' $)
 9002 FORMAT (t1,'BINARY File Root For (2): ' $)
 9003 FORMAT (q, a)
 9004 FORMAT (t1,'Cannot open /uw0 or ', a)
 9005 FORMAT (2i10)
 9007 format(t1,(a),i10)
c
c...Get Root And Read INF File
c
      badtry = .false.
  100 lb = fn2(1:nfn2)//'.inf'
      nlb = nfn2 + 4
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9005) n2
      read(1,*) magoffset, magslope
      CLOSE (1)
c
      if( n2 .gt. NSMAX ) then
         write(6,9007) 'Too many pmm stars: ',n2
         errflg = 1
         return
      end if
c
c...Read The DAT File
c
      lb = fn2(1:nfn2)//'.dat'
      nlb = nfn2 + 4
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=n2,
     *      recordtype='fixed',
     *      status='old',
     *      unit=1
     *     )
      DO j=1,NBIGBUF
         READ (1,rec=j) (tmpbuf(i),i=1,n2)
         if( j .eq. 4 ) then	! rec=4 packs mag & mag9
            do i=1,n2
               thebuf(1,i) = tmpbuf(i)
            end do
         else if( j .eq. 9 ) then	!rec=9 packs PMMX
            do i=1,n2
               thebuf(2,i) = tmpbuf(i)
            end do
         else if( j .eq.10 ) then	!rec=10 packs PMMY
            do i=1,n2
               thebuf(3,i) = tmpbuf(i)
            end do
         else if( j .eq. 3 ) then	! rec=3 packs M00
            do i=1,n2
               thebuf(4,i) = tmpbuf(i)
            end do
         end if
      ENDDO
      CLOSE (1)
      RETURN
c
c...Fatal Error
c
c May need to look in both /uw0 and /uw1 for .INF and .DAT files
  200 if( .not. badtry ) then
         badtry = .true.
         fn2(4:4) = '1'
      else
         WRITE (*,9004) lb(1:nlb)
         stop
      end if
      GO TO 100
      END
c
c
c
      SUBROUTINE UNPACK(who,val,tmp1buf)
c
c...Given Index, Return Unpacked Values
c
      INCLUDE
     *            'xp6.inc'
      INTEGER*4
     *            who, arg(4), i, tmp1buf(4,NSMAX)
      REAL*4
     *            val(25)
c
c...Extract The Integers
c
100   do i=1,4
         arg(i) = tmp1buf(i,who)
      end do
c
c...Call BINFILL Glue
c
      CALL glue(arg,val)
      RETURN
      END
c
c
c
      SUBROUTINE  GLUE(arg,val)
c
c...Call BINFILL And Then Pass Back
c
      INCLUDE
     *            'ridge.inc'
      INTEGER*4
     *            arg(4), i
      REAL*4
     *            val(25)
c
  100 CALL binfill(arg)
      val(9) = mag
      val(10) = tmag
      val(23) = m9
      val(1) = pmmx
      val(2) = pmmy
      RETURN
      END
c
c
c
      SUBROUTINE  BINFILL(in)
c
c...Crack Values And Put In Passing Vector
c
      INCLUDE
     *            'ridge.inc'
      real*4 magoffset, magslope
      INTEGER*4
     *            in(4), low, mid, high, j
      common/magblk/ magoffset, magslope
c
c...Crack Magnitudes
c
100   j = in(1)
      high = j/10000
      low = j - high*10000
      mag = 0.01*low
      m9 = 0.01*high
c
      pmmx = 1.0d-2*in(2)
      pmmy = 1.0d-2*in(3)
c
      tmag = magoffset + magslope*(0.001*mod(in(4),10000))
c
c...MOST IMPORTANT.  INDICATE NUMBER OF ENTRIES
c
      nr = 0
      RETURN
      END
c
c
c
      SUBROUTINE  RADECINV(ira,ispd,dra,ddec)
c
c Recover RA, Dec from IRA and ISPD
c
      INCLUDE
     *            'cuproc.inc'
      real*8 rfactor, dfactor
      PARAMETER(
     *            rfactor = 1.5D1*3.6D3*1.0D2,
     *            dfactor =       3.6D3*1.0D2)
      INTEGER*4
     *            i, j, ixi, ieta, ira, ispd
      real*8
     *            x, y, m, xhat, yhat, dra, ddec
c
      if(ira.ne.-908070605) then
          dra = ira/rfactor
      else
          dra=-1000.
      endif
      ddec = ispd/dfactor - 9.0d1
c
      RETURN
      END
c
c
c
      SUBROUTINE NR_SORT7(N,RA,RB,RC,RD,RE,RF,WKSP,RWKSP,IWKSP,IWKSP2)
c
c     DIMENSION RA(N),RB(N),RC(N),WKSP(N),IWKSP(N)
      real*8 ra(*), rb(*), wksp(*)
      real*4 rc(*), rwksp(*), re(*), rf(*)
      integer iwksp(*), n, iwksp2(*), rd(2,*)
c
      CALL NR_INDEXX(N,RA,IWKSP)
      DO 11 J=1,N
        WKSP(J)=RA(J)
11    CONTINUE
      DO 12 J=1,N
        RA(J)=WKSP(IWKSP(J))
12    CONTINUE
      DO 13 J=1,N
        WKSP(J)=RB(J)
13    CONTINUE
      DO 14 J=1,N
        RB(J)=WKSP(IWKSP(J))
14    CONTINUE
      DO 15 J=1,N
        RWKSP(J)=RC(J)
15    CONTINUE
      DO 16 J=1,N
        RC(J)=RWKSP(IWKSP(J))
16    CONTINUE
      DO 17 J=1,N
        IWKSP2(J)=RD(1,J)
17    CONTINUE
      DO 18 J=1,N
        RD(1,J)=IWKSP2(IWKSP(J))
18    CONTINUE
      DO 19 J=1,N
        IWKSP2(J)=RD(2,J)
19    CONTINUE
      DO 20 J=1,N
        RD(2,J)=IWKSP2(IWKSP(J))
20    CONTINUE
      DO 21 J=1,N
        RWKSP(J)=RE(J)
21    CONTINUE
      DO 22 J=1,N
        RE(J)=RWKSP(IWKSP(J))
22    CONTINUE
      DO 23 J=1,N
        RWKSP(J)=RF(J)
23    CONTINUE
      DO 24 J=1,N
        RF(J)=RWKSP(IWKSP(J))
24    CONTINUE
      RETURN
      END
c
c
c
      SUBROUTINE NR_INDEXX(N,ARRIN,INDX)
c
c     DIMENSION ARRIN(N),INDX(N)
      real*8 arrin(*)
      integer indx(*), n
c
      DO 11 J=1,N
        INDX(J)=J
11    CONTINUE
      L=N/2+1
      IR=N
10    CONTINUE
        IF(L.GT.1)THEN
          L=L-1
          INDXT=INDX(L)
          Q=ARRIN(INDXT)
        ELSE
          INDXT=INDX(IR)
          Q=ARRIN(INDXT)
          INDX(IR)=INDX(1)
          IR=IR-1
          IF(IR.EQ.1)THEN
            INDX(1)=INDXT
            RETURN
          ENDIF
        ENDIF
        I=L
        J=L+L
20      IF(J.LE.IR)THEN
          IF(J.LT.IR)THEN
            IF(ARRIN(INDX(J)).LT.ARRIN(INDX(J+1)))J=J+1
          ENDIF
          IF(Q.LT.ARRIN(INDX(J)))THEN
            INDX(I)=INDX(J)
            I=J
            J=J+J
          ELSE
            J=IR+1
          ENDIF
        GO TO 20
        ENDIF
        INDX(I)=INDXT
      GO TO 10
      END
c
c
c
      SUBROUTINE MKLUT(npmmobj,pmmra,lut,scale)
c
      include 'std.inc'
      include 'pcm.inc'
c
      real*8 pmmra(MAXSTARS), scale, test
      integer npmmobj, lut(MLUT)
c
      scale = dble(MLUT)/(pmmra(npmmobj) - pmmra(1))
c
      do i=1,MLUT
         test = pmmra(1) + dble(i)/scale
         if( i .eq. 1 ) then
            j = 1
         else
            j = lut(i-1)
         end if
         do while( pmmra(j).lt.test .and. j.lt.npmmobj )
            j = j + 1
         end do
         lut(i) = j
      end do
c
      return
      end
c
c
c
      SUBROUTINE RAD2DMS(arg,asn,idg,imn,fsc,ishours)
c
      real*8 angle, picon, arg
      real fsc
      integer idg, imn
      character asn*1
      logical ishours
c
      picon = datan(1.0d0)/45.
      angle = abs(arg/picon)
c
      if( ishours ) then
         angle = angle/15.0
         asn = ' '
      else
         if( arg .gt. 0.0d0 ) then
            asn = '+'
         else if( arg .lt. 0.0d0 ) then
            asn = '-'
         else
            asn = ' '
         end if
      end if
      idg = int( angle )
      angle = (angle - idg)*60.0
      imn = int(angle)
      fsc = (angle - imn)*60.0
c
      return
      end
 
      REAL FUNCTION ADJMAG (ip,is)
c
c     return pmm magnitude adjusted for vignetting
c
      include 'std.inc'
      include 'pcm.inc'

      REAL*4 pmmx(MAXSTARS), pmmy(MAXSTARS), pmmmag(MAXSTARS), stdmag(MP)
      REAL*4 vmag
      INTEGER ip,is
      common /blku/ pmmx,pmmy,pmmmag,stdmag
c
      call vignette(pmmx(ip),pmmy(ip),stdmag(is),vmag)
      adjmag = pmmmag(ip) - vmag
      return
      end

      SUBROUTINE VIGNETTE(x,y,mag,vmag)
c
c handle empirical vignetting function by table interpolation
c dimensions are (mag,rsq)
c
      REAL*4 table(11,14),tmag(11),mag,vmag,y1,y2,y3,y4,t,u
      REAL*4 x,y,xcent,ycent
      REAL*8 trsq(14),rsq
      INTEGER i,i1,i2,iflag
      DATA (table(i,1),i=2,10) /-.08,-.01,0.04,0.09,0.13,0.10,0.05,0.08,0.06/
      DATA (table(i,2),i=2,10) /-.04,0.00,0.04,0.08,0.12,0.08,0.03,0.05,0.04/
      DATA (table(i,3),i=2,10) /0.00,0.01,0.03,0.07,0.10,0.06,0.02,0.02,0.02/
      DATA (table(i,4),i=2,10) /0.04,0.01,0.03,0.05,0.07,0.05,0.00,-.01,0.00/
      DATA (table(i,5),i=2,10) /0.07,0.02,0.02,0.04,0.05,0.03,-.02,-.03,-.03/
      DATA (table(i,6),i=2,10) /0.09,0.02,0.02,0.03,0.03,0.01,-.05,-.05,-.05/
      DATA (table(i,7),i=2,10) /0.09,0.02,0.00,0.00,0.01,-.01,-.07,-.07,-.06/
      DATA (table(i,8),i=2,10) /0.09,0.02,-.02,-.02,-.01,-.04,-.10,-.10,-.08/
      DATA (table(i,9),i=2,10) /0.07,0.02,-.02,-.03,-.03,-.07,-.09,-.12,-.09/
      DATA (table(i,10),i=2,10)/0.05,0.02,0.00,-.01,0.00,-.05,-.05,-.08,-.05/
      DATA (table(i,11),i=2,10)/0.04,0.02,0.03,0.03,0.03,-.01,0.00,0.01,0.05/
      DATA (table(i,12),i=2,10)/0.02,0.02,0.05,0.06,0.05,0.04,0.05,0.10,0.12/
      DATA (table(i,13),i=2,10)/0.00,0.02,0.08,0.10,0.08,0.07,0.09,0.20,0.24/
      DATA (table(i,14),i=2,10)/0.00,0.02,0.11,0.13,0.10,0.09,0.13,0.28,0.33/
      DATA tmag /0.0,6.0,8.0,9.5,10.5,11.5,12.5,13.5,14.5,15.5,20.0/
      DATA trsq /0.0,4.0e8,1.6e9,3.6e9,6.4e9,1.0e10,1.44e10,1.96e10,
     $     2.56e10,3.24e10,4.0e10,4.84e10,5.76e10,6.76e10/
      DATA iflag /0/
      DATA xcent,ycent /170750.0,172000.0/
c
      if (iflag.eq.0) then
c set table limits
        do i=1,14
          table(1,i) = table(2,i)
          table(11,i) = table(10,i)
        enddo
        iflag = 1
      endif
c
      rsq = (x-xcent)**2 + (y-ycent)**2
      vmag = 0.0
      if (rsq.gt.trsq(14).or.mag.lt.tmag(1).or.mag.gt.tmag(11)) return
c find the corners appropriate to this mag,rsq
      i1 = 1
      i2 = 1
      do i=1,10
        if (mag.ge.tmag(i).and.mag.le.tmag(i+1)) then
          i1 = i
          goto 10
        endif
      enddo
10    continue
      do i=1,13
        if(rsq.ge.trsq(i).and.rsq.le.trsq(i+1)) then
          i2 = i
          goto 20
        endif
      enddo
20    continue
c
c now do bilinear interpolation ala numerical recipies p. 97
      y1 = table(i1,i2)
      y2 = table(i1+1,i2)
      y3 = table(i1+1,i2+1)
      y4 = table(i1,i2+1)
      t = (mag - tmag(i1))/(tmag(i1+1) - tmag(i1))
      u = (rsq - trsq(i2))/(trsq(i2+1) - trsq(i2))
      vmag = (1.-t)*(1.-u)*y1 + t*(1.-u)*y2 + t*u*y3 + (1.-t)*u*y4
      return
      end
c
c Angular separation of objects on the celestial sphere (<90 degrees).
c
      DOUBLE PRECISION FUNCTION ANGSEP(raa,deca,rab,decb)
c
      real*8 ra1, dec1, ra2, dec2, dist, s1, s2, ds1, ds2, twopi,
     & raa, rab, deca, decb
      integer h1, h2, m1, m2, d1, d2, dm1, dm2
      parameter( twopi=6.2831853071796d0 )
c
      ra1 = raa
      dec1 = deca
      ra2 = rab
      dec2 = decb
c
      angsep = abs( dacos( dsin(dec1)*dsin(dec2) +
     & dcos(dec1)*dcos(dec2)*dcos(ra1 - ra2) ) )
c
      return
      end
c
c
c
      SUBROUTINE PHASE1A(nstdobj,stdra,stddec,scale,lut,erradius,pmmra,
     & pmmdec,pmmmag,starnum,imatches,candct,aiter)
c
      include 'std.inc'
      include 'pcm.inc'
c
      integer*4 nstdobj, ilo, ihi, lut(MLUT), ncand, pmmnum(MAXSTARS),
     & ibestmatch, starnum(2,MAXSTARS), imatches(MP), nmatched, candct(MP)
      real*4 erradius, pmmmag(MAXSTARS)
      real*8 pmmra(MAXSTARS), pmmdec(MAXSTARS), stdra(MP), stddec(MP),
     & test1, test2, test3, test4, scale, ddist, newddist
      character aiter*2
      integer errflg
      common/blkz/errflg
c
  3   format(t1,(a))
c
c For each standard star, collect PMM stars within error box and
c  find star closest to center of error box.
c
      write(6,3) '. . .matching. . .'
      do i=1,nstdobj
         ilo = 1 + int(scale*(stdra(i)-pmmra(1)-erradius/cosd(stddec(i))))
         if( ilo.gt.2 .and. ilo.le.MLUT ) then
            ilo = lut(ilo - 2)
         else
            ilo = 1
         end if
         ihi = 1 + int(scale*(stdra(i)-pmmra(1)+erradius/cosd(stddec(i))))
         if( ihi.ge.1 .and. ihi.lt.MLUT ) then
            ihi = lut(ihi + 1)
         else
            ihi = lut(MLUT)
         end if
         test1 = stddec(i) - erradius
         test2 = stddec(i) + erradius
         test3 = stdra(i) - erradius/cosd(stddec(i))
         test4 = stdra(i) + erradius/cosd(stddec(i))
         ncand = 0
         do j=ilo,ihi
            if( test1.le.pmmdec(j) .and. pmmdec(j).le.test2 
     &       .and. test3.le.pmmra(j) .and. pmmra(j).le.test4
     &       .and. pmmmag(j).lt.24.2 .and. starnum(2,j).gt.0 ) then
c! Note mag cutoff;
c! also note that STARNUM(2)>0 is used to employ only primary detections
               ncand = ncand + 1
               pmmnum(ncand) = j
            end if
         end do
         if( ncand .gt. 0 ) then
            ibestmatch = 1
            ddist = dsqrt(((pmmra(pmmnum(1)) - stdra(i))*cosd(stddec(i)))**2 +
     &       (pmmdec(pmmnum(1)) - stddec(i))**2)
            do j=2,ncand
               newddist = dsqrt(((pmmra(pmmnum(j)) - stdra(i))*cosd(stddec(i)))**2 +
     &          (pmmdec(pmmnum(j)) - stddec(i))**2)
               if( newddist .lt. ddist ) then
                  ddist = newddist
                  ibestmatch = j
               end if
            end do
c Record matches
            imatches(i) = pmmnum(ibestmatch)
            candct(i) = ncand
         else
c Indicate no match
            imatches(i) = 0
            candct(i) = 0
         end if
      end do
c
      nmatches = 0
      do i=1,nstdobj
         if( imatches(i) .ne. 0 ) nmatches = nmatches + 1
      end do
      write(6,81) '=> ', nmatches, ' standard stars matched (phase '//
     & aiter//') <='
 81   format(t1,a3,i4,(a))
      if( nmatches .lt. 4 ) then
         write(6,3) 'Not enough matches to continue'
         errflg = 1
         return
      end if
c
      return
      end
c
c
c
      SUBROUTINE FITEMPLATE(nstdobj,stdmag,pmmmag,ipmmdx,y0)
c
      include 'std.inc'
      include 'pcm.inc'
c
      integer nstdobj, ipmmdx(MP), npts, ibrtst, test
      real*4 stdmag(MP), pmmmag(MAXSTARS), x(MP), y(MP), xtry, ytry(3),
     & thepen(3), RELERR, penalty, y0
      parameter( RELERR=0.0001 )
c
c Make arrays for fitting -- X is stuffed with a standard mag, Y with
c the PMM mag for the matching PMM star.  Do this only for the matched stars.
c
      npts = 0
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) then
            npts = npts + 1
            x(npts) = stdmag(i)
            y(npts) = adjmag(ipmmdx(i),i)
         end if
      end do
c
c Find the brightest matched PMM star; start looking for the best fit here,
c as mismatched PMM stars are generally fainter than the standard they try
c to match, so this is not a bad starting point.
c
      ibrtst = 1
      test = y(1)
      do i=2,npts
         if( y(i).lt.test ) then
            test = y(i)
            ibrtst = i
         end if
      end do
c
c Move template up and down to minimize penalty.  Placement need not be exact.
c
      ytry(1) = y(ibrtst)
      thepen(1) = penalty(ytry(1),x,y,npts)
      ytry(2) = y(ibrtst) + 0.01
      thepen(2) = penalty(ytry(2),x,y,npts)
      if( thepen(2) .lt. thepen(1) ) then
c Keep going that way until penalty function increases.
         do while( thepen(2) .lt. thepen(1) )
            ytry(1) = ytry(2)
            thepen(1) = thepen(2)
            ytry(2) = ytry(1) + 0.01
            thepen(2) = penalty(ytry(2),x,y,npts)
         end do
c The solution is now bracketed.
      else
c Go the other way
         ytry(2) = y(ibrtst) - 0.01
         thepen(2) = penalty(ytry(2),x,y,npts)
         do while( thepen(2) .lt. thepen(1) )
            ytry(1) = ytry(2)
            thepen(1) = thepen(2)
            ytry(2) = ytry(1) - 0.1
            thepen(2) = penalty(ytry(2),x,y,npts)
         end do
c The solution is now bracketed.
      end if
c
c Now get close by bifurcation, iterating until relative error < RELERR.
c
      ytry(3) = 0.5*(ytry(1) + ytry(2))
      thepen(3) = penalty(ytry(3),x,y,npts)
      do while( abs(thepen(3)-min(thepen(1),thepen(2)))/thepen(3) .gt. RELERR )
c Sort and keep best two points
         if( abs(thepen(3) - thepen(1)) .lt. abs(thepen(3) - thepen(2)) ) then
            ytry(2) = ytry(3)
            thepen(2) = thepen(3)
         else
            ytry(1) = ytry(3)
            thepen(1) = thepen(3)
         end if
c New guess by bifurcation
         ytry(3) = 0.5*(ytry(1) + ytry(2))
         thepen(3) = penalty(ytry(3),x,y,npts)
      end do
      y0 = ytry(3)
c
      return
      end
c
c
c
      REAL FUNCTION PENALTY(ytry,x,y,npts)
c
      include 'std.inc'
c
      real ytry, x(MP), y(MP), dist, sumdist, template
      integer npts
c
      sumdist = 0.0
      do i=1,npts
         dist = abs(template(ytry,x(i)) - y(i))
         sumdist = sumdist + dist
      end do
      penalty = sumdist/float(npts)
c
      return
      end
c
c
c
      REAL FUNCTION TEMPLATE(c,x)
c
      real*4 c, x, acoeff(4), zcoeff(4), pl(4)
      common /coefblk/ acoeff, zcoeff
c
      acoeff(1) = -8.77693	!Legendre
      acoeff(2) = 5.44318	!Legendre
c
      pl(1) = 1.0
      pl(2) = x
      do i=3,4
         pl(i) = (float(2*i-3)*x*pl(i-1) - float(i-2)*pl(i-2))/float(i-1)
      end do
      template = pl(4)*acoeff(4) + pl(3)*acoeff(3) + pl(2)*acoeff(2) +
     & pl(1)*acoeff(1) + c
c
      return
      end
c
c
c
      SUBROUTINE PHASE1B(nstdobj,stdra,stddec,stdmag,scale,lut,erradius,pmmra,
     & pmmdec,pmmmag,starnum,ipmmdx,pmmmatch,thedmag,aiter)
c
      include 'std.inc'
      include 'pcm.inc'
c
      logical matched(MP), attempted(MP)
      character aiter*2
      integer*4 ilarge, ipmmdx(MP), ilo, ihi, lut(MP), ncand,
     & starnum(2,MAXSTARS), pmmnum(MP), ibestmatch, nrematched, nrejected,
     & nmatched, pmmmatch(MP)
      real*4 dmag, test, template, stdmag(MP), PMMMAG(MAXSTARS), magtest,
     & x0, y0, erradius, newdmag, HWMAG, thedmag(MP), NODMAG, acoeff(4),
     & zcoeff(4)
      real*8 stdra(MP), stddec(MP), pmmra(MAXSTARS), pmmdec(MAXSTARS), scale,
     & test1, test2, test3, test4
      parameter( NODMAG=9.999 )
      parameter( HWMAG=0.8 )	!half-width of magnitude error box in PMM mags;
c				!this is 3-sigma for 14-18 standard J mag - the
c				!3-sigma half-width for 5-14 std J mag is 0.5
      common /coefblk/ acoeff, zcoeff
c
      do i=1,nstdobj
         attempted(i) = .false.
      end do
c
      call fitemplate(nstdobj,stdmag,pmmmag,ipmmdx,y0)
c
c Create logical array indicating if the star is matched
c
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) then
            matched(i) = .true.
            thedmag(i) = adjmag(ipmmdx(i),i) - template(y0,stdmag(i)) 
         else
            matched(i) = .false.
            thedmag(i) = NODMAG
         end if
      end do
c
c Find largest outlier in magnitude
c
      dmag = 0.0
      ilarge = 0
      do i=1,nstdobj
         if( matched(i) ) then
            test = abs( template(y0,stdmag(i)) - adjmag(ipmmdx(i),i) )
            if( test .gt. dmag ) then
               dmag = test
               ilarge = i
            end if
         end if
      end do
c
c Loop until the largest outlier is smaller than the acceptable width
c
      nrematched = 0
      nrejected = 0
c On first pass, use all the stars, and rematch or reject those outside 2HWMAG.
      do while( dmag .gt. 2.0*HWMAG )
c
c Attempt to rematch the largest outlier using a magnitude criterion inside
c the error box.
c
         if( .not.attempted(ilarge) ) then
            ilo = 1 + int(scale*(stdra(ilarge)-pmmra(1)-erradius/cosd(stddec(ilarge))))
            if( ilo.gt.2 .and. ilo.le.MLUT ) then
               ilo = lut(ilo - 2)
            else
               ilo = 1
            end if
            ihi = 1 + int(scale*(stdra(ilarge)-pmmra(1)+erradius/cosd(stddec(ilarge))))
            if( ihi.ge.1 .and. ihi.lt.MLUT ) then
               ihi = lut(ihi + 1)
            else
               ihi = lut(MLUT)
            end if
            ncand = 0
            test1 = stddec(ilarge) - erradius
            test2 = stddec(ilarge) + erradius
            test3 = stdra(ilarge) - erradius/cosd(stddec(ilarge))
            test4 = stdra(ilarge) + erradius/cosd(stddec(ilarge))
c           if( ilo.eq.1 .and. ihi.eq.MLUT ) then
c              ncand = 0
c           else
               do j=ilo,ihi
                  if( test1.le.pmmdec(j) .and. pmmdec(j).le.test2 
     &             .and. test3.le.pmmra(j) .and. pmmra(j).le.test4
     &             .and. pmmmag(j).lt.24.2 .and. starnum(2,j).gt.0 ) then
c! Note mag cutoff;
c! also note that STARNUM(2)>0 is used to employ only primary detections
                     ncand = ncand + 1
                     pmmnum(ncand) = j
                  end if
               end do
c           end if
            if( ncand .gt. 0 ) then
               ibestmatch = 1
               dmag = abs(adjmag(pmmnum(1),ilarge)-template(y0,stdmag(ilarge)))
               do j=2,ncand
                  newdmag = abs(adjmag(pmmnum(j),ilarge)-template(y0,stdmag(ilarge)))
                  if( newdmag .lt. dmag ) then
                     dmag = newdmag
                     ibestmatch = j
                  end if
               end do
c Record matches
               ipmmdx(ilarge) = pmmnum(ibestmatch)
               attempted(ilarge) = .true.
               nrematched = nrematched + 1
               thedmag(ilarge) = adjmag(ipmmdx(ilarge),ilarge) - template(y0,stdmag(ilarge))
               if( abs(thedmag(ilarge)) .gt. 9.999 ) thedmag(ilarge) = NODMAG
               pmmmatch(ilarge) = starnum(1,ipmmdx(ilarge))
            else
c Indicate no match
               ipmmdx(ilarge) = 0
               attempted(ilarge) = .true.
               matched(ilarge) = .false.
               nrejected = nrejected + 1
               thedmag(ilarge) = NODMAG
            end if
         else
c Already attempted match, so if this is still the largest outlier, the
c coords must be bad and this is a bad point.
            ipmmdx(ilarge) = 0
            matched(ilarge) = .false.
            nrejected = nrejected + 1
         end if
c Fit template to remaining points - the iteration is on the procedure
c [fit & delete one point].
         call fitemplate(nstdobj,stdmag,pmmmag,ipmmdx,y0)
c
c Find largest outlier among matched objects
c
         dmag = 0.0
         ilarge = 0
         do i=1,nstdobj
            if( matched(i) ) then
               test = abs( template(y0,stdmag(i)) - adjmag(ipmmdx(i),i) )
               if( test .gt. dmag ) then
                  dmag = test
                  ilarge = i
               end if
            end if
         end do
c Loop to process next largest outlier
      end do
c
c Do it again for just the middle portion of stars, with smaller tolerance
c
      do i=1,nstdobj
         attempted(i) = .false.
      end do
c
c Find largest outlier in magnitude
c
      dmag = 0.0
      ilarge = 0
      do i=1,nstdobj
         if( matched(i) .and. 7.0.le.stdmag(i) .and.stdmag(i).le.14.0 ) then
            test = abs( template(y0,stdmag(i)) - adjmag(ipmmdx(i),i) )
            if( test .gt. dmag ) then
               dmag = test
               ilarge = i
            end if
         end if
      end do
c
c Loop until the largest outlier is smaller than the acceptable width
c
c This is the second pass, with tighter mag tolerance
      do while( dmag .gt. HWMAG )
c
c Attempt to rematch the largest outlier using a magnitude criterion inside
c the error box.
c
         if( .not.attempted(ilarge) ) then
            ilo = 1 + int(scale*(stdra(ilarge)-pmmra(1)-erradius/cosd(stddec(ilarge))))
            if( ilo.gt.2 .and. ilo.le.MLUT ) then
               ilo = lut(ilo - 2)
            else
               ilo = 1
            end if
            ihi = 1 + int(scale*(stdra(ilarge)-pmmra(1)+erradius/cosd(stddec(ilarge))))
            if( ihi.ge.1 .and. ihi.lt.MLUT ) then
               ihi = lut(ihi + 1)
            else
               ihi = lut(MLUT)
            end if
            ncand = 0
            test1 = stddec(ilarge) - erradius
            test2 = stddec(ilarge) + erradius
            test3 = stdra(ilarge) - erradius/cosd(stddec(ilarge))
            test4 = stdra(ilarge) + erradius/cosd(stddec(ilarge))
            do j=ilo,ihi
               if( test1.le.pmmdec(j) .and. pmmdec(j).le.test2 
     &          .and. test3.le.pmmra(j) .and. pmmra(j).le.test4
     &          .and. pmmmag(j).lt.24.2 .and. starnum(2,j).gt.0 ) then
c! Note mag cutoff;
c! also note that STARNUM(2)>0 is used to employ only primary detections
                  ncand = ncand + 1
                  pmmnum(ncand) = j
               end if
            end do
            if( ncand .gt. 0 ) then
               ibestmatch = 1
               dmag = abs( adjmag(pmmnum(1),ilarge) - template(y0,stdmag(ilarge)) )
               do j=2,ncand
                  newdmag = abs(adjmag(pmmnum(j),ilarge)-template(y0,stdmag(ilarge)))
                  if( newdmag .lt. dmag ) then
                     dmag = newdmag
                     ibestmatch = j
                  end if
               end do
c Record matches
               ipmmdx(ilarge) = pmmnum(ibestmatch)
               attempted(ilarge) = .true.
               nrematched = nrematched + 1
               thedmag(ilarge) = adjmag(ipmmdx(ilarge),ilarge) - template(y0,stdmag(ilarge))
               if( abs(thedmag(ilarge)) .gt. 9.999 ) thedmag(ilarge) = NODMAG
               pmmmatch(ilarge) = starnum(1,ipmmdx(ilarge))
            else
c Indicate no match
               ipmmdx(ilarge) = 0
               attempted(ilarge) = .true.
               matched(ilarge) = .false.
               nrejected = nrejected + 1
               thedmag(ilarge) = NODMAG
            end if
         else
c Already attempted match, so if this is still the largest outlier, the
c coords must be bad and this is a bad point.
            ipmmdx(ilarge) = 0
            matched(ilarge) = .false.
            nrejected = nrejected + 1
         end if
c Fit template to remaining points - the iteration is on the procedure
c [fit & delete one point].
         call fitemplate(nstdobj,stdmag,pmmmag,ipmmdx,y0)
c
c Find largest outlier among matched objects
c
         dmag = 0.0
         ilarge = 0
         do i=1,nstdobj
            if( matched(i) .and. 7.0.le.stdmag(i) .and. stdmag(i).le.14.0 ) then
               test = abs( template(y0,stdmag(i)) - adjmag(ipmmdx(i),i) )
               if( test .gt. dmag ) then
                  dmag = test
                  ilarge = i
               end if
            end if
         end do
c Loop to process next largest outlier
      end do
c
c End of second pass
c
c Make third pass to attempt rematching of ALL bright (< 7 mag) stars
c
      do i=1,nstdobj
         if( matched(i) .and. stdmag(i).le.7.0 ) then
            ilo = 1 + int(scale*(stdra(i)-pmmra(1)-erradius/cosd(stddec(i))))
            if( ilo.gt.2 .and. ilo.le.MLUT ) then
               ilo = lut(ilo - 2)
            else
               ilo = 1
            end if
            ihi = 1 + int(scale*(stdra(i)-pmmra(1)+erradius/cosd(stddec(i))))
            if( ihi.ge.1 .and. ihi.lt.MLUT ) then
               ihi = lut(ihi + 1)
            else
               ihi = lut(MLUT)
            end if
            ncand = 0
            test1 = stddec(i) - erradius
            test2 = stddec(i) + erradius
            test3 = stdra(i) - erradius/cosd(stddec(i))
            test4 = stdra(i) + erradius/cosd(stddec(i))
c           if( ilo.eq.1 .and. ihi.eq.MLUT ) then
c              ncand = 0
c           else
               do j=ilo,ihi
                  if( test1.le.pmmdec(j) .and. pmmdec(j).le.test2 
     &             .and. test3.le.pmmra(j) .and. pmmra(j).le.test4
     &             .and. pmmmag(j).lt.24.2 .and. starnum(2,j).gt.0 ) then
c! Note mag cutoff;
c! also note that STARNUM(2)>0 is used to employ only primary detections
                     ncand = ncand + 1
                     pmmnum(ncand) = j
                  end if
               end do
c           end if
            if( ncand .gt. 0 ) then
               ibestmatch = 1
               dmag = abs( adjmag(pmmnum(1),i) - template(y0,stdmag(i)) )
               do j=2,ncand
                  newdmag = abs(adjmag(pmmnum(j),i)-template(y0,stdmag(i)))
                  if( newdmag .lt. dmag ) then
                     dmag = newdmag
                     ibestmatch = j
                  end if
               end do
c Record matches
               ipmmdx(i) = pmmnum(ibestmatch)
               nrematched = nrematched + 1
               thedmag(i) = adjmag(ipmmdx(i),i) - template(y0,stdmag(i))
               if( abs(thedmag(i)) .gt. 9.999 ) thedmag(i) = NODMAG
               pmmmatch(i) = starnum(1,ipmmdx(i))
            else
c Indicate no match
               ipmmdx(i) = 0
               matched(i) = .false.
               nrejected = nrejected + 1
               thedmag(i) = NODMAG
            end if
         end if
c Fit template to remaining points - the iteration is on the procedure
c [fit & delete one point].
         call fitemplate(nstdobj,stdmag,pmmmag,ipmmdx,y0)
      end do
c
      nmatched = 0
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) nmatched = nmatched + 1
      end do
      write(6,81) '=> ', nrejected, ' rejections, ', nrematched,
     & ' rematches for ', nmatched, ' stars matched total (phase '//aiter//') <='
 81   format(t1,a3,i4,(a),i4,(a),i4,(a))
c
      acoeff(1) = acoeff(1) + y0
c
c save the adjusted coefficients
c
      do i=1,4
        zcoeff(i) = acoeff(i)
      enddo
c
      return
      end
c
c
c
      SUBROUTINE CALCMAG (z,k,result)
c
c calculate plate magnitude for this star
c k: 1=J 2=F 3=N 4=O 5=E
c z(6) = standard magnitude/colors for this star
c       in order: V, B-V, U-B, V-R, R-I, V-I
c return: plate magnitude if it can determined for this object
c  else 99.999
c written 14-Oct-94 AAH
c
      REAL*4 z(6),fx(15,10),fy(15,10),base,rise,run
      REAL*4 result
      INTEGER indx,iflag,nentry(10),isub(2,10),jflag(10)
      INTEGER i,j,k,jj
      DATA iflag /0/
      COMMON/cmblk/nentry, isub, jflag, fx, fy
c
      IF (iflag.eq.0) THEN
        open (unit=33,file='tables.txt',status='old')
        DO i=1,10
          read (33,9000,end=10) nentry(i),(isub(j,i),j=1,2),jflag(i)
9000      format(8x,4i5)
          DO j=1,nentry(i)
            read (33,9001) fx(j,i),fy(j,i)
9001        format(2f7.3)
          ENDDO
        ENDDO
10      CONTINUE
        iflag = 1
        close(33)
      ENDIF
c now find right table for this star/plate
c four tests:
c (1) (B-V) best and good (B-V)
      indx = k*2-1
      jj = 2
      IF (jflag(indx).gt.0.and.fx(1,indx).le.z(jj)
     $  .and.z(jj).le.fx(nentry(indx),indx)) GOTO 100
c (2) (V-R) best and good (V-R)
      indx = k*2
      jj = 4
      IF (jflag(indx).gt.0.and.fx(1,indx).le.z(jj)
     $  .and.z(jj).le.fx(nentry(indx),indx)) GOTO 100
c (3) good (B-V)
      indx = k*2-1
      jj = 2
      IF (fx(1,indx).le.z(jj).and.
     $   z(jj).le.fx(nentry(indx),indx)) GOTO 100
c (4) good (V-R)
      indx = k*2
      jj = 4
      IF (fx(1,indx).le.z(jj).and.
     $   z(jj).le.fx(nentry(indx),indx)) GOTO 100
c else just return
      result = 99.999
      RETURN
100   CONTINUE
c find appropriate standard magnitude that forms (J-n) etc.
      base = z(isub(1,indx))
      IF (isub(2,indx).ne.0) base = base - z(isub(2,indx))
c do piecewise linear interpolation in appropriate table
      DO i=1,nentry(indx)-1
        IF (z(jj).ge.fx(i,indx).and.
     $      z(jj).le.fx((i+1),indx)) THEN
          rise = fy((i+1),indx) - fy(i,indx)
          run = fx((i+1),indx) - fx(i,indx)
          result = base + fx(i,indx) + (z(jj)-fx(i,indx))*rise/run
          GOTO 200
        ENDIF
      ENDDO
      result = 88.888
200   CONTINUE
      RETURN
      END
c
c This does linear least squares fit to the cleaned photometric data,
c fitting for all terms.
c
      SUBROUTINE PHASE2(nstdobj,stdmag,pmmmag,ipmmdx,r,sdev)
c
      include 'std.inc'
      include 'pcm.inc'
c
      real*4 stdmag(MP), pmmmag(MAXSTARS), acoeff(4), sdev(2), THRMAG,
     & x(MP), y(MP), w(MP), r(MP), stt, sx, sy, t(MP), sty, fitfunc, pl(4) 
      real*4 sig(MP), chisq, covar(4,4), zcoeff(4)	!
      real*4 BTHRMAG
      integer*4 nstdobj, ipmmdx(MP), npts, nmiddle, nextreme
      integer*4 lista(4), mfit
      parameter( THRMAG=14.0, BTHRMAG=7.0 )
      common /coefblk/ acoeff, zcoeff
      integer errflg
      common/blkz/errflg
c
c Stuff auxiliary arrays X and Y with valid data points for fitting.
c
      npts = 0
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) then
            npts = npts + 1
            x(npts) = stdmag(i)
            y(npts) = adjmag(ipmmdx(i),i)
            sig(npts) = 1.0	!
         end if
      end do
      do i=1,4
         lista(i) = i
      end do
c
      call NR_LFIT(x,y,sig,npts,acoeff,4,lista,4,covar,4,chisq)
      if (errflg.eq.1) return
c
c Compute standard deviation from the mean (y-distance between fit and y-data).
c
      sdev(1) = 0.0
      sdev(2) = 0.0
      nmiddle = 0
      nextreme = 0
      do i=1,npts
         r(i) = y(i) - fitfunc(x(i))
         if( BTHRMAG.le.x(i) .and. x(i).le.THRMAG ) then
            nmiddle = nmiddle + 1
            sdev(1) = sdev(1) + r(i)**2
         else
            nextreme = nextreme + 1
            sdev(2) = sdev(2) + r(i)**2
         end if
      end do
      if( nmiddle .gt. 4 ) then
         sdev(1) = sqrt(sdev(1)/float(nmiddle - 4))
      else
         sdev(1) = 0.0
      end if
      if( nextreme .gt. 4 ) then
         sdev(2) = sqrt(sdev(2)/float(nextreme - 4))
      else
         sdev(2) = 0.0
      end if
c
      return
      end
c
c
c
      REAL FUNCTION FITFUNC(x)
c
      real x, acoeff(4), zcoeff(4), pl(4)
      common /coefblk/ acoeff, zcoeff
c
      pl(1) = 1.0
      pl(2) = x
      do i=3,4
         pl(i) = (float(2*i-3)*x*pl(i-1) - float(i-2)*pl(i-2))/float(i-1)
      end do
      fitfunc = pl(4)*acoeff(4) + pl(3)*acoeff(3) + pl(2)*acoeff(2) +
     & pl(1)*acoeff(1)	!Legendre
c
      return
      end
c
c
c
      SUBROUTINE WIN1A(nstdobj,stdmag,pmmmag,ipmmdx)
c
      include 'std.inc'
      include 'pcm.inc'
c
      integer*4 nstdobj, ipmmdx(MP), GX1, GX2, GY1, GY2, npts
      real*4 stdmag(MP), pmmmag(MAXSTARS), x(MP), y(MP), xmn, xmx,
     & ymn, ymx
      parameter( GX1=1880, GX2=3124, GY1=1407, GY2=2324 )
c
      ymn = 8.0
      ymx = 25.0
      xmn = 4.0
      xmx = xmn + (ymx - ymn)*float(GX2-GX1)/float(GY2-GY1)
c
      npts = 0
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) then
            npts = npts + 1
            x(npts) = stdmag(i)
            y(npts) = adjmag(ipmmdx(i),i)
         end if
      end do
c
      call mgowindow(2,2,4)
      call mgosetlim(xmn,ymn,xmx,ymx)
      call mgosetexpand(1.0001)
      call mgosetltype(0)
      call mgosetlweight(1)
      call mgobox(1,2)
      call mgorelocate(1.8,16.5)
      call mgosetangle(90.0)
      call mgoputlabel(7,'PMM Mag',8)
      call mgosetangle(0.0)
      call mgopoints(41.0,1,x,y,npts)
      call mgorelocate(20.0,10.0)
      call mgopoint(4,1)
      call mgorelocate(21.0,10.0)
      call mgosetexpand(0.7)
      call mgoputlabel(8,'rejected',6)
      call mgorelocate(19.0,23.0)
      call mgoputlabel(7,'Phase 1',6)
      call mgorelocate(19.0,21.5)
      call mgoputlabel(15,'Reject outliers',6)
      call mgosetexpand(1.0001)
c
      return
      end
c
c
c
      SUBROUTINE WIN1B(nstdobj,stdmag,pmmmag,ipmmdx,acoeff)
c
      include 'std.inc'
      include 'pcm.inc'
c
      integer*4 nstdobj, ipmmdx(MP), ICPTS, GX1, GX2, GY1, GY2
      real*4 stdmag(MP), pmmmag(MAXSTARS), acoeff(4), x(MP), y(MP), step,
     & xmn, xmx, ymn, ymx, pl(4)
      parameter( ICPTS=101 )
      parameter( GX1=1880, GX2=3124, GY1=1407, GY2=2324 )
      real*4 u(ICPTS), v(ICPTS)
c
      ymn = 8.0
      ymx = 25.0
      xmn = 4.0
      xmx = xmn + (ymx - ymn)*float(GX2-GX1)/float(GY2-GY1)
c
      npts = 0
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) then
            npts = npts + 1
            x(npts) = stdmag(i)
            y(npts) = adjmag(ipmmdx(i),i)
         end if
      end do
c
      step = (xmx - xmn)/float(ICPTS - 1)
      do i=1,ICPTS
         u(i) = xmn + step*float(i-1)
         pl(1) = 1.0
         pl(2) = u(i)
         do j=3,4
            pl(j) = (float(2*j-3)*u(i)*pl(j-1) - float(j-2)*pl(j-2))/float(j-1)
         end do
         v(i) = pl(4)*acoeff(4) + pl(3)*acoeff(3) + pl(2)*acoeff(2) +
     &    pl(1)*acoeff(1)	!Legendre
      end do
c
      call mgopoints(120.0,1,x,y,npts)
      call mgoconnect(u,v,ICPTS)
      call mgorelocate(20.0,11.5)
      call mgopoint(12,0)
      call mgorelocate(20.7,11.5)
      call mgopoint(12,0)
      call mgorelocate(20.0,11.5)
      call mgopoint(4,1)
      call mgorelocate(21.7,11.5)
      call mgosetexpand(0.7)
      call mgoputlabel(8,'accepted',6)
      call mgosetexpand(1.0001)
c
      return
      end
c
c
c
      SUBROUTINE WIN2(nstdobj,stdid,stdmag,pmmmag,ipmmdx,acoeff)
c
      include 'std.inc'
      include 'pcm.inc'
c
      integer*4 nstdobj, ipmmdx(MP), stdid(MP), GX1, GX2, GY1, GY2, npts, ICPTS
      real*4 stdmag(MP), pmmmag(MAXSTARS), acoeff(4), x(MP), y(MP), style(MP),
     & xmn, xmx, ymn, ymx, step, pl(4)
      parameter( GX1=1880, GX2=3124, GY1=1407, GY2=2324 )
      parameter( ICPTS=101 )
      real*4 u(ICPTS), v(ICPTS)
c
      ymn = 8.0
      ymx = 25.0
      xmn = 4.0
      xmx = xmn + (ymx - ymn)*float(GX2-GX1)/float(GY2-GY1)
c
      npts = 0
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) then
            npts = npts + 1
            x(npts) = stdmag(i)
            y(npts) = adjmag(ipmmdx(i),i)
            if( stdid(i) .eq. 1 ) then
               style(npts) = 120.0
            else if( stdid(i) .eq. 2 ) then
               style(npts) = 40.0
            else if( stdid(i) .eq. 3 ) then
               style(npts) = 52.0
            else
               style(npts) = 30.0
            end if
         end if
      end do
c
      step = (xmx - xmn)/float(ICPTS - 1)
      do i=1,ICPTS
         u(i) = xmn + step*float(i-1)
         pl(1) = 1.0	!Legendre
         pl(2) = u(i)	!Legendre
         do j=3,4
            pl(j) = (float(2*j-3)*u(i)*pl(j-1) - float(j-2)*pl(j-2))/float(j-1)
         end do
         v(i) = pl(4)*acoeff(4) + pl(3)*acoeff(3) + pl(2)*acoeff(2) +
     &    pl(1)*acoeff(1)
      end do
c
      call mgowindow(2,2,2)
      call mgosetlim(xmn,ymn,xmx,ymx)
      call mgosetexpand(1.0001)
      call mgosetltype(0)
      call mgosetlweight(1)
      call mgobox(1,2)
      call mgoxlabel(14,'Standard J Mag')
      call mgorelocate(1.8,16.5)
      call mgosetangle(90.0)
      call mgoputlabel(7,'PMM Mag',8)
      call mgosetangle(0.0)
      call mgopoints(style,npts,x,y,npts)
      call mgoconnect(u,v,ICPTS)
      call mgorelocate(20.0,14.5)
      call mgopoint(12,0)
      call mgorelocate(21.0,14.5)
      call mgosetexpand(0.7)
      call mgoputlabel(6,'UBVcat',6)
      call mgosetexpand(1.0001)
      call mgorelocate(20.0,13.0)
      call mgopoint(4,0)
      call mgorelocate(21.0,13.0)
      call mgosetexpand(0.7)
      call mgoputlabel(5,'GSPC1',6)
      call mgosetexpand(1.0001)
      call mgorelocate(20.0,11.5)
      call mgopoint(5,2)
      call mgorelocate(21.0,11.5)
      call mgosetexpand(0.7)
      call mgoputlabel(5,'GSPC2',6)
      call mgosetexpand(1.0001)
      call mgorelocate(20.0,10.0)
      call mgopoint(3,0)
      call mgorelocate(21.0,10.0)
      call mgosetexpand(0.7)
      call mgoputlabel(5,'Other',6)
      call mgorelocate(19.0,23.0)
      call mgoputlabel(7,'Phase 2',6)
      call mgorelocate(19.0,21.5)
      call mgoputlabel(15,'Photometric fit',6)
      call mgosetexpand(1.0001)
c
      return
      end
c
c
c
      SUBROUTINE WIN3(nstdobj,stdid,stdmag,resid,ipmmdx)
c
      include 'std.inc'
      include 'pcm.inc'
c
      integer*4 nstdobj, ipmmdx(MP), stdid(MP), GX1, GX2, GY1, GY2, npts
      real*4 stdmag(MP), resid(MP), x(MP), y(MP), style(MP),
     & xmn, xmx, ymn, ymx
      parameter( GX1=1880, GX2=3124, GY1=1407, GY2=2324 )
c
      ymn = 8.0
      ymx = 25.0
      xmn = 4.0
      xmx = xmn + (ymx - ymn)*float(GX2-GX1)/float(GY2-GY1)
      ymn = -0.8
      ymx = 0.8
c
      npts = 0
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) then
            npts = npts + 1
            x(npts) = stdmag(i)
            y(npts) = resid(npts)
            if( stdid(i) .eq. 1 ) then
               style(npts) = 123.0
            else if( stdid(i) .eq. 2 ) then
               style(npts) = 43.0
            else if( stdid(i) .eq. 3 ) then
               style(npts) = 52.0
            else
               style(npts) = 33.0
            end if
         end if
      end do
c
      call mgowindow(2,2,1)
      call mgosetlim(xmn,ymn,xmx,ymx)
      call mgosetexpand(1.0001)
      call mgosetltype(0)
      call mgosetlweight(1)
      call mgobox(1,2)
      call mgoxlabel(14,'Standard J Mag')
      call mgorelocate(1.2,0.0)
      call mgosetangle(90.0)
      call mgoputlabel(18,'Residual (PMM Mag)',8)
      call mgosetangle(0.0)
      call mgopoints(style,npts,x,y,npts)
      call mgorelocate(20.0,-0.15)
      call mgopoint(12,3)
      call mgorelocate(21.0,-0.15)
      call mgosetexpand(0.7)
      call mgoputlabel(6,'UBVcat',6)
      call mgosetexpand(1.0001)
      call mgorelocate(20.0,-0.3)
      call mgopoint(4,3)
      call mgorelocate(21.0,-0.3)
      call mgosetexpand(0.7)
      call mgoputlabel(5,'GSPC1',6)
      call mgosetexpand(1.0001)
      call mgorelocate(20.0,-0.45)
      call mgopoint(5,2)
      call mgorelocate(21.0,-0.45)
      call mgosetexpand(0.7)
      call mgoputlabel(5,'GSPC2',6)
      call mgosetexpand(1.0001)
      call mgorelocate(20.0,-0.6)
      call mgopoint(3,3)
      call mgorelocate(21.0,-0.6)
      call mgosetexpand(0.7)
      call mgoputlabel(5,'Other',6)
      call mgosetexpand(1.0001)
c
      return
      end
c
c
c
      SUBROUTINE WIN4(nstdobj,ipmmdx,acoeff,sdev,bname,fld0ra,fld0dec)
c
      include 'std.inc'
      include 'pcm.inc'
c
      real*8 fld0ra, fld0dec
      real*4 acoeff(4), sdev(2), frasc, fsc
      integer*4 nstdobj, ipmmdx(MP), npts, ihr, imn, idg, iramn
      character bname*4, aline*80, asn*1
c
      npts = 0
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) npts = npts + 1
      end do
c
      call mgowindow(2,2,3)
      call mgosetlim(0.0,0.0,1.0,1.0)
      call mgosetltype(0)
      call mgosetlweight(1)
c
      call mgosetexpand(1.2)
      aline = 'Field '//bname
      call mgorelocate(0.0,0.9)
      call mgolabel(10,aline(1:10))
c
      call mgosetexpand(0.7)
      aline = 'Center (J2000) '
      call rad2dms(fld0ra,asn,ihr,iramn,frasc,.true.)
      call rad2dms(fld0dec,asn,idg,imn,fsc,.false.)
      write(aline(16:40),21) ihr,':',iramn,':',frasc, asn,idg,':',imn,':',fsc
 21   format(i2.2,a1,i2.2,a1,f6.3,1x,a1,i2.2,a1,i2.2,a1,f5.2)
      call mgorelocate(0.0,0.8)
      call mgolabel(40,aline(1:40))
c
      aline = ' '
      write(aline(1:24),31) nstdobj, ' standards on plate'
 31   format(i4,a20)
      call mgorelocate(0.0,0.7)
      call mgolabel(24,aline(1:24))
c
      aline = ' '
      write(aline(1:26),41) npts, ' standards used in fit'
 41   format(i4,a22)
      call mgorelocate(0.0,0.6)
      call mgolabel(26,aline(1:26))
c
      aline = 'Photometric (Legendre) solution:'
      call mgorelocate(0.0,0.5)
      call mgolabel(32,aline(1:32))
      do i=4,1,-2
         aline = ' '
         write(aline(1:40),51) 'a(', i-1, ')=', acoeff(i), 'a(', i-2, ')=', acoeff(i-1)
 51      format(3x,a2,i1,a2,g13.6,1x,a2,i1,a2,g13.6)
         call mgorelocate(0.0,0.33+0.05*(i-2))
         call mgolabel(40,aline(1:40))
      end do
c
      aline = ' '
      write(aline(1:26),61) 'Residuals ', 0.001*nint(1000.0*sdev(1)), '(7<mag<14)'
 61   format(a9,1x,f5.3,1x,a10)
      call mgorelocate(0.0,0.25)
      call mgolabel(26,aline(1:26))
      aline = ' '
      write(aline(1:30),62) 0.001*nint(1000.0*sdev(2)), '(<5 or >14mag)'
 62   format(10x,f5.3,1x,a14)
      call mgorelocate(0.0,0.15)
      call mgolabel(30,aline(1:30))
c
      return
      end
c
c
c
      SUBROUTINE NR_LFIT(X,Y,SIG,NDATA,A,MA,LISTA,MFIT,COVAR,NCVM,
     *CHISQ)
      PARAMETER (MMAX=50)
      DIMENSION X(NDATA),Y(NDATA),SIG(NDATA),A(MA),LISTA(MFIT),
     *    COVAR(NCVM,NCVM),BETA(MMAX),AFUNC(MMAX)
      integer errflg
      common/blkz/errflg
c
      KK=MFIT+1
      DO 12 J=1,MA
        IHIT=0
        DO 11 K=1,MFIT
          IF (LISTA(K).EQ.J) IHIT=IHIT+1
11      CONTINUE
        IF (IHIT.EQ.0) THEN
          LISTA(KK)=J
          KK=KK+1
        ELSE IF (IHIT.GT.1) THEN
          PAUSE 'Improper set in LISTA'
        ENDIF
12    CONTINUE
      IF (KK.NE.(MA+1)) PAUSE 'Improper set in LISTA'
      DO 14 J=1,MFIT
        DO 13 K=1,MFIT
          COVAR(J,K)=0.
13      CONTINUE
        BETA(J)=0.
14    CONTINUE
      DO 18 I=1,NDATA
        CALL FUNCS(X(I),AFUNC,MA)
        YM=Y(I)
        IF(MFIT.LT.MA) THEN
          DO 15 J=MFIT+1,MA
            YM=YM-A(LISTA(J))*AFUNC(LISTA(J))
15        CONTINUE
        ENDIF
        SIG2I=1./SIG(I)**2
        DO 17 J=1,MFIT
          WT=AFUNC(LISTA(J))*SIG2I
          DO 16 K=1,J
            COVAR(J,K)=COVAR(J,K)+WT*AFUNC(LISTA(K))
16        CONTINUE
          BETA(J)=BETA(J)+YM*WT
17      CONTINUE
18    CONTINUE
      IF (MFIT.GT.1) THEN
        DO 21 J=2,MFIT
          DO 19 K=1,J-1
            COVAR(K,J)=COVAR(J,K)
19        CONTINUE
21      CONTINUE
      ENDIF
      CALL NR_GAUSSJ(COVAR,MFIT,NCVM,BETA,1,1)
      if (errflg.eq.1) return
      DO 22 J=1,MFIT
        A(LISTA(J))=BETA(J)
22    CONTINUE
      CHISQ=0.
      DO 24 I=1,NDATA
        CALL FUNCS(X(I),AFUNC,MA)
        SUM=0.
        DO 23 J=1,MA
          SUM=SUM+A(J)*AFUNC(J)
23      CONTINUE
        CHISQ=CHISQ+((Y(I)-SUM)/SIG(I))**2
24    CONTINUE
      CALL NR_COVSRT(COVAR,NCVM,MA,LISTA,MFIT)
      RETURN
      END
c
c
c
      SUBROUTINE NR_COVSRT(COVAR,NCVM,MA,LISTA,MFIT)
      DIMENSION COVAR(NCVM,NCVM),LISTA(MFIT)
      DO 12 J=1,MA-1
        DO 11 I=J+1,MA
          COVAR(I,J)=0.
11      CONTINUE
12    CONTINUE
      DO 14 I=1,MFIT-1
        DO 13 J=I+1,MFIT
          IF(LISTA(J).GT.LISTA(I)) THEN
            COVAR(LISTA(J),LISTA(I))=COVAR(I,J)
          ELSE
            COVAR(LISTA(I),LISTA(J))=COVAR(I,J)
          ENDIF
13      CONTINUE
14    CONTINUE
      SWAP=COVAR(1,1)
      DO 15 J=1,MA
        COVAR(1,J)=COVAR(J,J)
        COVAR(J,J)=0.
15    CONTINUE
      COVAR(LISTA(1),LISTA(1))=SWAP
      DO 16 J=2,MFIT
        COVAR(LISTA(J),LISTA(J))=COVAR(1,J)
16    CONTINUE
      DO 18 J=2,MA
        DO 17 I=1,J-1
          COVAR(I,J)=COVAR(J,I)
17      CONTINUE
18    CONTINUE
      RETURN
      END
c
c
c
      SUBROUTINE NR_GAUSSJ(A,N,NP,B,M,MP)
      PARAMETER (NMAX=50)
      DIMENSION A(NP,NP),B(NP,MP),IPIV(NMAX),INDXR(NMAX),INDXC(NMAX)
      integer errflg
      common/blkz/errflg
      DO 11 J=1,N
        IPIV(J)=0
11    CONTINUE
      DO 22 I=1,N
        BIG=0.
        DO 13 J=1,N
          IF(IPIV(J).NE.1)THEN
            DO 12 K=1,N
              IF (IPIV(K).EQ.0) THEN
                IF (ABS(A(J,K)).GE.BIG)THEN
                  BIG=ABS(A(J,K))
                  IROW=J
                  ICOL=K
                ENDIF
              ELSE IF (IPIV(K).GT.1) THEN
                errflg = 1
                return
c               PAUSE 'Singular matrix (1)'
              ENDIF
12          CONTINUE
          ENDIF
13      CONTINUE
        IPIV(ICOL)=IPIV(ICOL)+1
        IF (IROW.NE.ICOL) THEN
          DO 14 L=1,N
            DUM=A(IROW,L)
            A(IROW,L)=A(ICOL,L)
            A(ICOL,L)=DUM
14        CONTINUE
          DO 15 L=1,M
            DUM=B(IROW,L)
            B(IROW,L)=B(ICOL,L)
            B(ICOL,L)=DUM
15        CONTINUE
        ENDIF
        INDXR(I)=IROW
        INDXC(I)=ICOL
        IF (A(ICOL,ICOL).EQ.0.) then
c           PAUSE 'Singular matrix (2)'
                errflg = 1
                return
        endif
        PIVINV=1./A(ICOL,ICOL)
        A(ICOL,ICOL)=1.
        DO 16 L=1,N
          A(ICOL,L)=A(ICOL,L)*PIVINV
16      CONTINUE
        DO 17 L=1,M
          B(ICOL,L)=B(ICOL,L)*PIVINV
17      CONTINUE
        DO 21 LL=1,N
          IF(LL.NE.ICOL)THEN
            DUM=A(LL,ICOL)
            A(LL,ICOL)=0.
            DO 18 L=1,N
              A(LL,L)=A(LL,L)-A(ICOL,L)*DUM
18          CONTINUE
            DO 19 L=1,M
              B(LL,L)=B(LL,L)-B(ICOL,L)*DUM
19          CONTINUE
          ENDIF
21      CONTINUE
22    CONTINUE
      DO 24 L=N,1,-1
        IF(INDXR(L).NE.INDXC(L))THEN
          DO 23 K=1,N
            DUM=A(K,INDXR(L))
            A(K,INDXR(L))=A(K,INDXC(L))
            A(K,INDXC(L))=DUM
23        CONTINUE
        ENDIF
24    CONTINUE
      RETURN
      END
c
c Build Legendre polynomials
c
      SUBROUTINE FUNCS(x,afunc,ma)
c
      integer ma
      dimension afunc(ma)
      real x
c
      afunc(1) = 1.0
      afunc(2) = x
      do i=3,ma
         afunc(i) = (float(2*i-3)*x*afunc(i-1) - float(i-2)*afunc(i-2))/float(i-1)
      end do
c
      return
      end
c
c
c
      SUBROUTINE PHASE3(nstdobj,stdra,stddec,stdmag,scale,lut,erradius,pmmra,
     & pmmdec,pmmmag,starnum,ipmmdx,pmmmatch,thedmag)
c
      include 'std.inc'
      include 'pcm.inc'
c
      logical matched(MP), attempted(MP)
      integer*4 ilarge, ipmmdx(MP), ilo, ihi, lut(MP), ncand,
     & starnum(2,MAXSTARS), pmmnum(MP), ibestmatch, nrematched, nrejected,
     & nmatched, pmmmatch(MP)
      real*4 dmag, test, fitfunc, stdmag(MP), PMMMAG(MAXSTARS), magtest,
     & x0, y0, erradius, newdmag, HWMAG, thedmag(MP), NODMAG, acoeff(4),
     & zcoeff(4)
      real*8 stdra(MP), stddec(MP), pmmra(MAXSTARS), pmmdec(MAXSTARS), scale,
     & test1, test2, test3, test4
      parameter( NODMAG=9.999 )
      parameter( HWMAG=0.8 )	!half-width of magnitude error box in PMM mags;
c				!this is 3-sigma for 14-18 standard J mag - the
c				!3-sigma half-width for 5-14 std J mag is 0.5
      common /coefblk/ acoeff, zcoeff
c
      do i=1,nstdobj
         attempted(i) = .false.
      end do
c
c Create logical array indicating if the star is matched
c
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) then
            matched(i) = .true.
            thedmag(i) = adjmag(ipmmdx(i),i) - fitfunc(stdmag(i)) 
         else
            matched(i) = .false.
            thedmag(i) = NODMAG
         end if
      end do
c
c Find largest outlier in magnitude
c
      dmag = 0.0
      ilarge = 0
      do i=1,nstdobj
         if( matched(i) ) then
            test = abs( fitfunc(stdmag(i)) - adjmag(ipmmdx(i),i) )
            if( test .gt. dmag ) then
               dmag = test
               ilarge = i
            end if
         end if
      end do
c
c Loop until the largest outlier is smaller than the acceptable width
c
      nrematched = 0
      nrejected = 0
      do while( dmag .gt. 2.0*HWMAG )
c
c Attempt to rematch the largest outlier using a magnitude criterion inside
c the error box.
c
         if( .not.attempted(ilarge) ) then
            ilo = 1 + int(scale*(stdra(ilarge)-pmmra(1)-erradius/cosd(stddec(ilarge))))
            if( ilo.gt.2 .and. ilo.le.MLUT ) then
               ilo = lut(ilo - 2)
            else
               ilo = 1
            end if
            ihi = 1 + int(scale*(stdra(ilarge)-pmmra(1)+erradius/cosd(stddec(ilarge))))
            if( ihi.ge.1 .and. ihi.lt.MLUT ) then
               ihi = lut(ihi + 1)
            else
               ihi = lut(MLUT)
            end if
            ncand = 0
            test1 = stddec(ilarge) - erradius
            test2 = stddec(ilarge) + erradius
            test3 = stdra(ilarge) - erradius/cosd(stddec(ilarge))
            test4 = stdra(ilarge) + erradius/cosd(stddec(ilarge))
c           if( ilo.eq.1 .and. ihi.eq.MLUT ) then
c              ncand = 0
c           else
               do j=ilo,ihi
                  if( test1.le.pmmdec(j) .and. pmmdec(j).le.test2 
     &             .and. test3.le.pmmra(j) .and. pmmra(j).le.test4
     &             .and. pmmmag(j).lt.24.2 .and. starnum(2,j).gt.0 ) then
c! Note mag cutoff;
c! also note that STARNUM(2)>0 is used to employ only primary detections
                     ncand = ncand + 1
                     pmmnum(ncand) = j
                  end if
               end do
c           end if
            if( ncand .gt. 0 ) then
               ibestmatch = 1
               dmag = abs( adjmag(pmmnum(1),ilarge) - fitfunc(stdmag(ilarge)) )
               do j=2,ncand
                  newdmag = abs(adjmag(pmmnum(j),ilarge)-fitfunc(stdmag(ilarge)))
                  if( newdmag .lt. dmag ) then
                     dmag = newdmag
                     ibestmatch = j
                  end if
               end do
c Record matches
               ipmmdx(ilarge) = pmmnum(ibestmatch)
               attempted(ilarge) = .true.
               nrematched = nrematched + 1
               thedmag(ilarge) = adjmag(ipmmdx(ilarge),ilarge)-fitfunc(stdmag(ilarge))
               if( abs(thedmag(ilarge)) .gt. 9.999 ) thedmag(ilarge) = NODMAG
               pmmmatch(ilarge) = starnum(1,ipmmdx(ilarge))
            else
c Indicate no match
               ipmmdx(ilarge) = 0
               attempted(ilarge) = .true.
               matched(ilarge) = .false.
               nrejected = nrejected + 1
               thedmag(ilarge) = NODMAG
            end if
         else
c Already attempted match, so if this is still the largest outlier, the
c coords must be bad and this is a bad point.
            ipmmdx(ilarge) = 0
            matched(ilarge) = .false.
            nrejected = nrejected + 1
         end if
c
c Find largest outlier among matched objects
c
         dmag = 0.0
         ilarge = 0
         do i=1,nstdobj
            if( matched(i) ) then
               test = abs( fitfunc(stdmag(i)) - adjmag(ipmmdx(i),i) )
               if( test .gt. dmag ) then
                  dmag = test
                  ilarge = i
               end if
            end if
         end do
c Loop to process next largest outlier
      end do
c
c Do it again for just the middle portion of stars, with smaller tolerance
c
      do i=1,nstdobj
         attempted(i) = .false.
      end do
c
c Find largest outlier in magnitude
c
      dmag = 0.0
      ilarge = 0
      do i=1,nstdobj
         if( matched(i) .and. 7.0.le.stdmag(i) .and.stdmag(i).le.14.0 ) then
            test = abs( fitfunc(stdmag(i)) - adjmag(ipmmdx(i),i) )
            if( test .gt. dmag ) then
               dmag = test
               ilarge = i
            end if
         end if
      end do
c
c Loop until the largest outlier is smaller than the acceptable width
c
c This is the second pass, with tighter mag tolerance
      do while( dmag .gt. HWMAG )
c
c Attempt to rematch the largest outlier using a magnitude criterion inside
c the error box.
c
         if( .not.attempted(ilarge) ) then
            ilo = 1 + int(scale*(stdra(ilarge)-pmmra(1)-erradius/cosd(stddec(ilarge))))
            if( ilo.gt.2 .and. ilo.le.MLUT ) then
               ilo = lut(ilo - 2)
            else
               ilo = 1
            end if
            ihi = 1 + int(scale*(stdra(ilarge)-pmmra(1)+erradius/cosd(stddec(ilarge))))
            if( ihi.ge.1 .and. ihi.lt.MLUT ) then
               ihi = lut(ihi + 1)
            else
               ihi = lut(MLUT)
            end if
            ncand = 0
            test1 = stddec(ilarge) - erradius
            test2 = stddec(ilarge) + erradius
            test3 = stdra(ilarge) - erradius/cosd(stddec(ilarge))
            test4 = stdra(ilarge) + erradius/cosd(stddec(ilarge))
c           if( ilo.eq.1 .and. ihi.eq.MLUT ) then
c              ncand = 0
c           else
               do j=ilo,ihi
                  if( test1.le.pmmdec(j) .and. pmmdec(j).le.test2 
     &             .and. test3.le.pmmra(j) .and. pmmra(j).le.test4
     &             .and. pmmmag(j).lt.24.2 .and. starnum(2,j).gt.0 ) then
c! Note mag cutoff;
c! also note that STARNUM(2)>0 is used to employ only primary detections
                     ncand = ncand + 1
                     pmmnum(ncand) = j
                  end if
               end do
c           end if
            if( ncand .gt. 0 ) then
               ibestmatch = 1
               dmag = abs( adjmag(pmmnum(1),ilarge) - fitfunc(stdmag(ilarge)) )
               do j=2,ncand
                  newdmag = abs(adjmag(pmmnum(j),ilarge)-fitfunc(stdmag(ilarge)))
                  if( newdmag .lt. dmag ) then
                     dmag = newdmag
                     ibestmatch = j
                  end if
               end do
c Record matches
               ipmmdx(ilarge) = pmmnum(ibestmatch)
               attempted(ilarge) = .true.
               nrematched = nrematched + 1
               thedmag(ilarge) = adjmag(ipmmdx(ilarge),ilarge) - fitfunc(stdmag(ilarge))
               if( abs(thedmag(ilarge)) .gt. 9.999 ) thedmag(ilarge) = NODMAG
               pmmmatch(ilarge) = starnum(1,ipmmdx(ilarge))
            else
c Indicate no match
               ipmmdx(ilarge) = 0
               attempted(ilarge) = .true.
               matched(ilarge) = .false.
               nrejected = nrejected + 1
               thedmag(ilarge) = NODMAG
            end if
         else
c Already attempted match, so if this is still the largest outlier, the
c coords must be bad and this is a bad point.
            ipmmdx(ilarge) = 0
            matched(ilarge) = .false.
            nrejected = nrejected + 1
         end if
c
c Find largest outlier among matched objects
c
         dmag = 0.0
         ilarge = 0
         do i=1,nstdobj
            if( matched(i) .and. 7.0.le.stdmag(i) .and. stdmag(i).le.14.0 ) then
               test = abs( fitfunc(stdmag(i)) - adjmag(ipmmdx(i),i) )
               if( test .gt. dmag ) then
                  dmag = test
                  ilarge = i
               end if
            end if
         end do
c Loop to process next largest outlier
      end do
c
c End of second pass
c
c Make third pass to attempt rematching of ALL bright (< 7 mag) stars
c
      do i=1,nstdobj
         if( matched(i) .and. stdmag(i).le.7.0 ) then
            ilo = 1 + int(scale*(stdra(i)-pmmra(1)-erradius/cosd(stddec(i))))
            if( ilo.gt.2 .and. ilo.le.MLUT ) then
               ilo = lut(ilo - 2)
            else
               ilo = 1
            end if
            ihi = 1 + int(scale*(stdra(i)-pmmra(1)+erradius/cosd(stddec(i))))
            if( ihi.ge.1 .and. ihi.lt.MLUT ) then
               ihi = lut(ihi + 1)
            else
               ihi = lut(MLUT)
            end if
            ncand = 0
            test1 = stddec(i) - erradius
            test2 = stddec(i) + erradius
            test3 = stdra(i) - erradius/cosd(stddec(i))
            test4 = stdra(i) + erradius/cosd(stddec(i))
c           if( ilo.eq.1 .and. ihi.eq.MLUT ) then
c              ncand = 0
c           else
               do j=ilo,ihi
                  if( test1.le.pmmdec(j) .and. pmmdec(j).le.test2 
     &             .and. test3.le.pmmra(j) .and. pmmra(j).le.test4
     &             .and. pmmmag(j).lt.24.2 .and. starnum(2,j).gt.0 ) then
c! Note mag cutoff;
c! also note that STARNUM(2)>0 is used to employ only primary detections
                     ncand = ncand + 1
                     pmmnum(ncand) = j
                  end if
               end do
c           end if
            if( ncand .gt. 0 ) then
               ibestmatch = 1
               dmag = abs( adjmag(pmmnum(1),i) - fitfunc(stdmag(i)) )
               do j=2,ncand
                  newdmag = abs(adjmag(pmmnum(j),i)-fitfunc(stdmag(i)))
                  if( newdmag .lt. dmag ) then
                     dmag = newdmag
                     ibestmatch = j
                  end if
               end do
c Record matches
               ipmmdx(i) = pmmnum(ibestmatch)
               nrematched = nrematched + 1
               thedmag(i) = adjmag(ipmmdx(i),i) - fitfunc(stdmag(i))
               if( abs(thedmag(i)) .gt. 9.999 ) thedmag(i) = NODMAG
               pmmmatch(i) = starnum(1,ipmmdx(i))
            else
c Indicate no match
               ipmmdx(i) = 0
               matched(i) = .false.
               nrejected = nrejected + 1
               thedmag(i) = NODMAG
            end if
         end if
      end do
c
      nmatched = 0
      do i=1,nstdobj
         if( ipmmdx(i) .ne. 0 ) nmatched = nmatched + 1
      end do
      write(6,81) '=> ', nrejected, ' rejections, ', nrematched,
     & ' rematches for ', nmatched, ' stars matched total (phase 3b) <='
 81   format(t1,a3,i4,(a),i4,(a),i4,(a))
c
      return
      end
c
c Read the NUMOBJ'th entry for COLORS, STDID, and GSCMATCH and transform
c STDMAG onto the plate system.
c
      SUBROUTINE FILLSTD(numobj,xx,colors,stdmag,stdid,gscmatch)
c
      include 'std.inc'
c
      REAL*8 ralo, rahi, declo, dechi
      REAL*4 stdmag(MP), calcmag, xx(6), colors(6,MP), tmag
      integer*4 numobj, stdid(MP)
      INTEGER pclflag
      CHARACTER stdorig*6, gscmatch(MP)*10
      integer errflg
      common/blkz/errflg
      common/plimblk/ ralo, rahi, declo, dechi, pclflag
c
  3   format(t1,(a))
c
      call calcmag(xx,1,tmag)	! "JFNOE"==12345
      stdmag(numobj) = tmag
      do i=1,6
         colors(i,numobj) = xx(i)
      end do
      backspace(13)
      read (13,902) stdorig, gscmatch(numobj)
902   format(63x,a6,4x,a10)
      if( stdorig .eq. 'Mermil' ) then
         stdid(numobj) = 1
      else if( stdorig .eq. 'gspc1 ' ) then
         stdid(numobj) = 2
      else if( stdorig .eq. 'gspc2 ' ) then
         stdid(numobj) = 3
      else if( stdorig .eq. 'NOFS  ' ) then
         stdid(numobj) = 4
      else if( stdorig .eq. 'aps   ' ) then
         stdid(numobj) = 5
      else
         stdid(numobj) = 0
      end if
c This is to eliminate matched stars with no determined J mag -- error returns
c are 88.888 or 99.999.
      if( stdmag(numobj) .lt. 88.0 ) numobj = numobj + 1
      if( numobj .gt. MP ) then
         write(6,994) 'Too many standards: ',numobj,ralo,rahi
994      format ((a),i10,2f12.8)
         errflg = 1
         return
      end if
c
      return
      end
