      program nodup
c
c remove duplicates in ubv.cat and sort on ra
c
      PARAMETER (NOBJ=150000)
      REAL*8 ra(NOBJ),dec(NOBJ),picon,deltrad,r,ra1,dec1
      REAL*4 v(NOBJ),ub(NOBJ),ri(NOBJ)
      REAL*4 bv(NOBJ),vr(NOBJ),vi(NOBJ)
      REAL*4 verr(NOBJ),bverr(NOBJ),uberr(NOBJ)
      REAL*4 vrerr(NOBJ),rierr(NOBJ),vierr(NOBJ)
      REAL*4 deltmag(NOBJ),deltdist(NOBJ)
      REAL*4 sumv,sumbv,sumub,sumvr,sumri,sumvi
      REAL*4 ras,decs
      REAL*4 vs,bvs,ubs,vrs,vis,ris
      INTEGER i,j,k,n1,n2,indx(NOBJ),dd,dm,rah,ram
      INTEGER gscreg(NOBJ),gscnum(NOBJ),flag(NOBJ)
      INTEGER nv,nbv,nvr,nub,nri,nvi,nkpts,npts
      INTEGER ii,jj,ndname,jflag,jknt
      CHARACTER*30 file1,file2
      CHARACTER*16 name(NOBJ)
      CHARACTER*6 source(NOBJ),avesource,ss
      CHARACTER*1 dsign
      CHARACTER*3 nobs(NOBJ)
      CHARACTER*10 dname(21000),compname
      DATA avesource/'Ave   '/
      DATA deltrad /5.0/  ! 5 arcsec
c
      picon = datan(1.D0)/45.
c convert deltrad (arcsec) to radians and square for ease
      deltrad = ((deltrad*picon)/3600.)**2
c     print *,' Enter input file name: '
c     read (5,'(a30)') file1
      print *,' Enter output file name: '
      read (5,'(a30)') file2
      open (unit=1,file='/uz6/xpmm/auxubv/ubv.cat',status='old',
     * readonly)
      open (unit=2,file=file2,status='new')
c
c read in double/variable file
c
      open (unit=3,file='/uz6/xpmm/auxubv/dupvar.dat',status='old',
     * readonly)
      i=1
10    continue
      read (3,994,end=11) dname(i)
994   format(a10)
      i=i+1
      goto 10
11    continue
      ndname = i-1
      jknt = 0
      close(3)
c
      write (2,906)
906   format (5x,'Name',11x,'RA(2000)',4x,'Dec(2000)',
     $  6x,'RA(rad)',4x,'Dec(rad)',4x,'V',6x,'B-V',4x,
     $   'U-B',4x,'V-R',4x,'R-I',4x,'V-I',2x,'deltmag',2x,'deltdist'
     $  /19x,'Verr',2x,'BVerr',2x,'UBerr',2x,'VRerr',2x,
     $  'RIerr',2x,'VIerr',4x,'Source',2x,'nobs',2x,'GSCreg',
     $  2x,'GSCnum')
c
      i=1
      read (1,*)
      read (1,*)
100   continue
      read(1,900,end=200) name(i),ra(i),dec(i),v(i),bv(i),ub(i),vr(i),
     $  ri(i),vi(i),deltmag(i),deltdist(i),
     $  verr(i),bverr(i),uberr(i),vrerr(i),rierr(i),vierr(i),
     $  source(i),nobs(i),gscreg(i),gscnum(i)
900   format(a16,27x,2f12.8,6f7.3,2f8.3/16x,6f7.3,5x,a6,a3,i5,i6)
c
c remove those stars listed as double or variable
c
      compname = name(i)(7:16)
      jflag = 0
      do j=1,ndname
        if (dname(j).eq.compname) then
          jflag = 1
          jknt = jknt + 1
          goto 150
        endif
      enddo
150   continue
      if (jflag.eq.1) goto 100
c
      i=min((i+1),NOBJ)
      goto 100
200   continue
      close(1)
      npts = i-1
      print *,'npts = ',npts
c now we've read the unsorted file.
c create arrays for later sort on ra
      do i=1,npts
        indx(i) = i
        flag(i) = 1
      enddo
      call sort(ra,indx,npts)
c now go thru file and remove duplicates
      k = 0
      i = 0
300   continue
      i = i+1
      if (i.eq.npts+1) goto 400
c if this object has been used for another average, skip
      if (flag(i).eq.0) goto 300
      ii = indx(i)
      nv = 1
      nbv = 1
      nub = 1
      nvr = 1
      nri = 1
      nvi = 1
      sumv = v(ii)
      sumbv = bv(ii)
      sumvr = vr(ii)
      sumub = ub(ii)
      sumvi = vi(ii)
      sumri = ri(ii)
      if (i.eq.npts) goto 350
c loop on remaining objects
      do j=i+1,npts
        jj=indx(j)
        if (flag(j).ne.0) then
        r = (ra(j)-ra(i))**2
c first test. sorted on ra, so bypass when ra greater than
c error box.
        if (r.gt.deltrad) goto 350
        r = r + (dec(jj)-dec(ii))**2
c then do full-up test to remove objects with discrepant dec
        if (r.le.deltrad) then
c object within deltrad of previous object.  add to sum
          flag(j) = 0
          if (sumv.ne.64.000.and.v(jj).ne.64.000) then
             sumv = sumv + v(jj)
             nv = nv+1
          endif
          if (sumv.eq.64.000.and.v(jj).ne.64.000) sumv = v(jj)
          if (sumbv.ne.64.000.and.bv(jj).ne.64.000) then
             sumbv = sumbv + bv(jj)
             nbv = nbv+1
          endif
          if (sumbv.eq.64.000.and.bv(jj).ne.64.000) sumbv=bv(jj)
          if (sumub.ne.64.000.and.ub(jj).ne.64.000) then
             sumub = sumub + ub(jj)
             nub = nub+1
          endif
          if (sumub.eq.64.000.and.ub(jj).ne.64.000) sumub=ub(jj)
          if (sumvr.ne.64.000.and.vr(jj).ne.64.000) then
             sumvr = sumvr + vr(jj)
             nvr = nvr+1
          endif
          if (sumvr.eq.64.000.and.vr(jj).ne.64.000) sumvr=vr(jj)
          if (sumri.ne.64.000.and.ri(jj).ne.64.000) then
             sumri = sumri + ri(jj)
             nri = nri + 1
          endif
          if (sumri.eq.64.000.and.ri(jj).ne.64.000) sumri=ri(jj)
          if (sumvi.ne.64.000.and.vi(jj).ne.64.000) then
             sumvi = sumvi + vi(jj)
             nvi = nvi+1
          endif
          if (sumvi.eq.64.000.and.vi(jj).ne.64.000) sumvi=vi(jj)
        endif
        endif
        enddo
c finished summing for this star. write to file.
350   continue
      vs = sumv/float(nv)
      bvs = sumbv/float(nbv)
      ubs = sumub/float(nub)
      vrs = sumvr/float(nvr)
      ris = sumri/float(nri)
      vis = sumvi/float(nvi)
      nv = nv+nbv+nub+nvr+nri+nvi
      ss = source(ii)
      if (nv.ne.6) ss = avesource
      ra1=ra(i)/(picon*15.)
      rah = ra1
      ra1 = (ra1-float(rah))*60.
      ram = ra1
      ras = (ra1-float(ram))*60.
      dec1 = dec(ii)/picon
      if (dec1.lt.0.0) then
        dsign = '-'
        dec1 = -dec1
      else
        dsign = '+'
      endif
      dd = dec1
      dec1 = (dec1-float(dd))*60.
      dm = dec1
      decs = (dec1-float(dm))*60.
      write(2,901) name(ii),rah,ram,ras,dsign,dd,dm,decs,
     $  ra(i),dec(ii),vs,bvs,ubs,vrs,ris,vis,deltmag(ii),
     $  deltdist(ii),verr(ii),bverr(ii),uberr(ii),vrerr(ii),rierr(ii),
     $  vierr(ii),ss,nobs(ii),gscreg(ii),gscnum(ii)
901   format(a16,1x,2i3,f7.3,1x,a1,i2.2,i3,f6.2,2f12.8,6f7.3,2f8.3/
     $   16x,6f7.3,5x,a6,a3,i5,i6)
      k = k + 1
      goto 300
400   continue
      print *,'Final number of stars = ',k
      print *,'Deleted due to dup/var = ',jknt
      close(2)
      stop
      end
      SUBROUTINE SORT (x,index,n)
c
c heapsort of array x with corresponding index array index
c from numerical recipies
c this version for real*8 guys
c
      REAL*8 x(n),xx
      INTEGER index(n)
      k = n/2+1
      ir = n
10    continue
      IF (k.gt.1) THEN
        k = k-1
        xx = x(k)
        ii = index(k)
      ELSE
        xx = x(ir)
        ii = index(ir)
        x(ir) = x(1)
        index(ir) = index(1)
        ir = ir-1
        IF (ir.eq.1) THEN
          x(1) = xx
          index(1) = ii
          RETURN
        ENDIF
      ENDIF
      i = k
      j = k+k
20    IF (j.le.ir) THEN
        IF (j.lt.ir) THEN
          IF (x(j).lt.x(j+1)) j = j+1
        ENDIF
        IF (xx.lt.x(j)) THEN
          x(i) = x(j)
          index(i) = index(j)
          i = j
          j = j+j
        ELSE
          j = ir+1
        ENDIF
      GOTO 20
      ENDIF
      x(i) = xx
      index(i) = ii
      GOTO 10
      END

