      SUBROUTINE  oepairs(id,np,p1,p2,
     *                     n1,x1,y1,m1,
     *                     n2,x2,y2,m2,
     *                     nc,xc,yc, pass)
c
c...Transform, Check, And Keep The Pairs
c
      IMPLICIT
     *            NONE
      PARAMETER
     *            scale = 1.0D08,
     *            billion = 1000*1000*1000,
     *            million = 1000*1000
      INTEGER
     *            np, p1(*), p2(*), n1, x1(*), y1(*), m1(*), n2, x2(*),
     *            y2(*), m2(*), nc, id, xx1, yy1, xx2, yy2, i, i1, i2,
     *            mm1, mm2, j, pass(*)
      DOUBLE PRECISION
     *            xc(*), yc(*), sx, sxx, sy, syy, x, y, dv(10), xhat,
     *            yhat
c
 9001 FORMAT (' O+E F=', i3, '  NP=', i7, '  X=', f6.2, '+/-', f5.2,
     *        '  Y=', f6.2, '+/-', f5.2, ' microns')
c
c...Outer Loop Over Pairs
c
  100 sx = 0.0D00
      sy = 0.0D00
      sxx = 0.0D00
      syy = 0.0D00
      DO i=1,np
        i1 = p1(i)
        IF ((i1.lt.1).or.(i1.gt.n1)) THEN
      write (*,9991) i,i1,i2
      pause
 9991 format (' Illegal POE(1) Index', 3i10)
        ENDIF
        i2 = p2(i)
        IF ((i2.lt.1).or.(i2.gt.n2)) THEN
      write (*,9992) i,i1,i2
      pause
 9992 format (' Illegal POE(2) Index', 3i10)
        ENDIF
c
c...Transform (2), Update (1) With Mean Values, And Sum The Residuals
c
        x = x2(i2)/SCALE
        y = y2(i2)/SCALE
        xhat = 0.0D00
        yhat = 0.0D00
        dv( 1) = 1.0D00
        dv( 2) = x
        dv( 3) = y
        IF (nc.gt.3) THEN
          dv( 4) = x*x
          dv( 5) = x*y
          dv( 6) = y*y
          dv( 7) = x*x*x
          dv( 8) = x*x*y
          dv( 9) = x*y*y
          dv(10) = y*y*y
        ENDIF
        DO j=1,nc
          xhat = xhat + dv(j)*xc(j)
          yhat = yhat + dv(j)*yc(j)
        ENDDO
        xx1 = x1(i1)
        xx2 = xhat*SCALE + 0.5D00
        yy1 = y1(i1)
        yy2 = yhat*SCALE + 0.5D00
        x1(i1) = (xx1+xx2+1)/2
        y1(i1) = (yy1+yy2+1)/2
        x = (xx2-xx1)
        y = (yy2-yy1)
        sx = sx + x
        sxx = sxx + x*x
        sy = sy + y
        syy = syy + y*y
c
c...Pack The Magnitudes To Indicate That This Is A Pair
c
        mm1 = MAX(1,MIN(998,(mm1+5)/10))
        mm2 = MAX(1,MIN(998,(mm2+5)/10))
        m1(i1) = BILLION + (id*MILLION) + mm1*1000 + mm2
      ENDDO
c
c...Convert Unpaired Magnitudes Just In Case They Are GSC Pairs
c
      DO i=1,n1
        IF (m1(i).lt.BILLION) THEN
          mm1 = MAX(1,MIN(998,(mm1+5)/10))
          m1(i) = (id*MILLION) + mm1*1000 + 999
        ENDIF
      ENDDO
c
c...Do Statistics To Reassure The User
c
      sx = sx/np
      sxx = SQRT(sxx/np - sx*sx)
      sy = sy/np
      syy = SQRT(syy/np - sy*sy)
      sx = 0.01D00*sx
      sy = 0.01D00*sy
      sxx = 0.00717D00*sxx
      syy = 0.00717D00*syy
      WRITE (*,9001) id,np,sx,sxx,sy,syy
      pass(5) = 100.0D00*sx
      pass(6) = 100.0D00*sxx
      pass(7) = 100.0D00*sy
      pass(8) = 100.0D00*syy
      RETURN
      END
