      SUBROUTINE  looper4xlb(zone)
c
c...Loop Over ZONE File Chunk At A Time
c
      INCLUDE
     *            'ugap4x4x.inc'
      INTEGER
     *            ntotal, nmost, nlast, nchunk, i, n, err, fd, j, l, k,
     *            C_ROOPEN, C_READER, nt, x1, x2, x3, zone, k1, k2,
     *            ra, spd, nte
      BYTE
     *            bb(65)
      DOUBLE PRECISION
     *            twopi, radian, torad, toint, rr, dd, gl, gb, spadd,
     *            spsub
c
 9001 FORMAT (' Read Error ', i12)
 9002 FORMAT (' Cannot Open ', a)
 9003 FORMAT (' Checks', 4i12)
 9004 FORMAT (' Chunk', 6i12)
 9005 FORMAT (' RA/SPD Error', 5i12)
 9006 FORMAT (' Tag Check (should be 0): ' i12)
c
c...Set Up Loop Parameters
c
  100 ntotal = ff(NRA) + ll(NRA) - 1
      nchunk = ((ntotal-1)/NMAX) + 1
      nmost = NMAX
      nlast = ntotal - ((nchunk-1)*nmost)
      root(nroot-2:nroot) = 'cat'
      DO i=1,nroot
        bb(i) = ICHAR(root(i:i))
      ENDDO
      bb(nroot+1) = 0
      fd = C_ROOPEN(bb)
      IF (fd.le.2) THEN
        WRITE (*,9002) root(1:nroot)
        WRITE (3,9002) root(1:nroot)
        CALL EXIT
      ENDIF
      twopi = 8.0D00*ATAN(1.0D00)
      radian = 360.0D00/twopi
      torad = 1.0D00/(100.0D00*3600.0D00*radian)
      toint = 4.0D00*radian
      spadd = 4.0D00*90.0D00
      spsub = twopi/4.0D00
c
c...Sanity Check On Tag Values
c
      nte = 0
      DO i=1,ntag
        IF ((tag(i).le.0).or.(tag(i).gt.ntotal)) THEN
          nte = nte+1
      if (nte.ge.318200) then
      write (*,9993) nte,i,tag(i),ntotal
      if (nte.eq.318212) pause
      endif
 9993 format (4i12)
        ENDIF
      ENDDO
      WRITE (*,9006) nte
      WRITE (3,9006) nte
c
c...Loop
c
      nt = 0
      DO j=1,nchunk
        IF (j.eq.nchunk) THEN
          n = nlast
        ELSE
          n = nmost
        ENDIF
        rfrst = 1
        rlast = n
        tfrst = (j-1)*nmost + 1
        tlast = tfrst + n - 1
        err = C_READER(fd,buf,3*4*n)
        WRITE (*,9004) j,nchunk,tfrst,tlast,n,err
        WRITE (3,9004) j,nchunk,tfrst,tlast,n,err
        IF (err.ne.0) THEN
          WRITE (*,9001) err
          WRITE (3,9001) err
          CALL EXIT
        ENDIF
c
c...Apply The Tags
c
        DO i=1,ntag
          l = tag(i)
          IF ((l.ge.tfrst).and.(l.le.tlast)) THEN
            buf(3,l+1-tfrst) = TAGVAL
            nt = nt+1
          ENDIF
        ENDDO
c
c...Count IN and OUT
c
        DO i=1,n
          ra = buf(1,i)/DEGREE
          spd = buf(2,i)/DEGREE
          IF ((ra.lt.0).or.(ra.ge.1440)
     *    .or.(spd.lt.0).or.(spd.gt.720)) THEN
            WRITE (*,9005) nchunk,i,buf(1,i),buf(2,i),buf(3,i)
            WRITE (3,9005) nchunk,i,buf(1,i),buf(2,i),buf(3,i)
          ELSE
            IF (buf(3,i).eq.TAGVAL) THEN
              outbox(ra,spd) = outbox(ra,spd)+1
            ELSE
              rr = buf(1,i)*torad
              dd = buf(2,i)*torad - spsub
              CALL sla_EQGAL(rr,dd,gl,gb)
              ra = gl*toint
              spd = gb*toint + spadd
              inbox(ra,spd) = inbox(ra,spd)+1
            ENDIF
          ENDIF
        ENDDO
c
c...End Of Loop
c
      ENDDO
      CALL c_closer(fd)
      i = ntag-nt
      WRITE (*,9003) zone,ntag,nt,i
      WRITE (3,9003) zone,ntag,nt,i
      RETURN
      END
