#include	<stdio.h>
#include	<sys/types.h>
#include	<unistd.h>
/*
 **************************************************************************
 *
 *   C_OPENER  --  Open A NEW File
 */
c_opener_(bb)
char bb[];
{
	return(creat(bb,0644));
}
/*
 ***************************************************************************
 *
 *   C_CLOSER  --  Close A File
 */
c_closer_(fd)
int *fd;
{
	return(close(*fd));
}
/*
 ***************************************************************************
 *
 *  C_WRITER  --  Write Into File Implementing BIG_ENDIAN
 */
c_writer_(fd,buf,n)
int *fd, *n;
char buf[];
{
	int i, nn;
	char b;

	nn = (*n);
	for (i=0; i<nn; i+=4) {
		b = buf[i  ];
		buf[i  ] = buf[i+3];
		buf[i+3] = b;
		b = buf[i+1];
		buf[i+1] = buf[i+2];
		buf[i+2] = b;
	}
	i = write(*fd,buf,nn);
	if (nn == i)
		return(0);
	else
		return(i);
}
/*
 *****************************************************************************
 *
 *  C_READER  --  Read From File Implementing BIG_ENDIAN
 */
c_reader_(fd,buf,n)
int *fd, *n;
char buf[];
{
	int i, nn;
	char b;

	nn = (*n);
	i = read(*fd,buf,nn);
	if (i == nn) {
		for (i=0; i<nn; i+=4) {
			b = buf[i  ];
			buf[i  ] = buf[i+3];
			buf[i+3] = b;
			b = buf[i+1];
			buf[i+1] = buf[i+2];
			buf[i+2] = b;
		}
		return(0);
	} else
		return(i);
}
/*
 ***************************************************************************
 *
 *   C_ROOPEN -- Open A ReadOnly File
 */
c_roopen_(bb)
char bb[];
{
	return(open(bb,0));
}
/*
 ****************************************************************************
 *
 *  C_GENLEN  --  Return The Length Of A File
 */
c_genlen_(bb)
char bb[];
{
	int fd, n;

	if ((fd=open(bb,0)) < 3)
		return(-1);
	n = (int)lseek(fd, 0, SEEK_END);
	close(fd);
	return(n);
}
/*
 ****************************************************************************
 *
 *   position  --  Move file pointer
 */
c_position_(fd,nb)
int *fd,*nb;
{
	return(lseek(*fd, *nb, SEEK_SET));
}
