      PROGRAM  exam7d
c
c...Look At UGAP7D Output Files And Measure Dispersion In Each Bin
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 25,
     *         bright = 12,
     *         faint = 21
      INTEGER
     *         i, ix, sn(NMAX), j
      DOUBLE PRECISION
     *         x, y, xbar, xres, sx(NMAX), sxx(NMAX)
      CHARACTER*1
     *         who
c
 9001 FORMAT (2f10.0)
 9002 FORMAT (1x, a, 3f8.2, i12)
c
c...Outer Loop Over Color
c
  100 DO j=1,2
        IF (j.eq.1) THEN
          who = 'b'
        ELSE
          who = 'r'
        ENDIF
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name='ugap7d.'//who,
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
      DO i=BRIGHT,FAINT
        sx(i) = 0.0D00
        sxx(i) = 0.0D00
        sn(i) = 0
      ENDDO
c
c...Process
c
  110   READ (1,9001,end=120) x,y
        xbar = 0.5D00*(x+y)
        xres = 0.5D00*(x-y)
        ix = xbar
        IF ((ix.ge.BRIGHT).and.(ix.le.FAINT)) THEN
          sx(ix) = sx(ix) + xres
          sxx(ix) = sxx(ix) + xres*xres
          sn(ix) = sn(ix) + 1
        ENDIF
        GO TO 110
  120   CLOSE (1)
c
c...Statistics
c
        DO i=BRIGHT,FAINT
          IF (sn(i).gt.1) THEN
            sx(i) = sx(i)/sn(i)
            sxx(i) = SQRT(sxx(i)/sn(i) - sx(i)*sx(i))
            x = i+0.5
            WRITE (*,9002) who,x,sx(i),sxx(i),sn(i)
          ENDIF
        ENDDO
      ENDDO
      CALL EXIT
      END
