      SUBROUTINE  rawproc(who)
c
c...Calibrate NSRAW Files
c
      INCLUDE
     *            'ugap7.inc'
      PARAMETER
     *            zone = 600
      CHARACTER*(*)
     *            who
      INTEGER
     *            ss, nn, sfield, smag, nfield, nmag, i, fake, scmag,
     *            ncmag
      REAL
     *            x, y
c
 9001 FORMAT (2i10)
 9002 FORMAT (2f10.2)
c
c...Open Files And Initialize
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../../newbin/bc3/nsraw.'//who,
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='ugap7d.'//who,
     *      status='unknown',
     *      unit=2
     *     )
c
c...Read, Convert, and Save
c
  110 READ (1,9001,end=120) ss,nn
      sfield = ss/10000
      smag = ss - sfield*10000
      nfield = nn/10000
      nmag = nn - nfield*10000
      IF (who.eq.'b') THEN
        fake = (sfield-1037)*MILLION + ((smag+5)/10)*THOUSAND
        CALL calibrate(ZONE,fake)
        i = fake/MILLION
        fake = fake - i*MILLION
        scmag = fake/THOUSAND
      ELSE
        fake = (sfield-1037)*MILLION + ((smag+5)/10)
        CALL calibrate(ZONE,fake)
        i = fake/THOUSAND
        scmag = fake - i*THOUSAND
      ENDIF
      IF (nfield.eq.0) THEN
        ncmag = (nmag+5)/10
      ELSE
        IF (who.eq.'b') THEN
          fake = nfield*MILLION + ((nmag+5)/10)*THOUSAND
          CALL calibrate(ZONE,fake)
          i = fake/MILLION
          fake = fake - i*MILLION
          ncmag = fake/THOUSAND
        ELSE
          fake = nfield*MILLION + ((nmag+5)/10)
          CALL calibrate(ZONE,fake)
          i = fake/THOUSAND
          ncmag = fake - i*THOUSAND
        ENDIF
      ENDIF
      x = 0.1*ncmag
      y = 0.1*scmag
      WRITE (2,9002) x,y
      GO TO 110
c
c...All Done
c
  120 CLOSE (1)
      CLOSE (2)
      RETURN
      END
