      SUBROUTINE  each(n)
c
c...Data Are In BUF.  Look at each catalog entry
c
      INCLUDE
     *            'ugapa.inc'
      PARAMETER
     *            p_half = circle/2,
     *            m_half = -p_half,
     *            rmult = 5.0D00
      INTEGER
     *            i, n, r, d, q, dd, k, m
      DOUBLE PRECISION
     *            dr, ds
c
 9001 FORMAT (' Illegal SPD', 3i12)
 9002 FORMAT (' Illegal RA', 3i12)
c
c...Loop Over Entries.  Compute pixel for each from RA/SPD.
c
  100 DO i=1,n
        d = 1 + (buf(2,i)-soffset)/sscale
        IF ((d.lt.1).or.(d.gt.nd)) THEN
          WRITE (*,9001) d,soffset,sscale
          CALL EXIT
        ENDIF
        r = buf(1,i)-roffset(d)
        IF (r.lt.0) THEN
          r = r+CIRCLE
        ELSEIF (r.gt.CIRCLE) THEN
          r = r-circle
        ENDIF
        r = 1 + r/rscale(d)
        IF ((r.lt.1).or.(r.gt.nzone(d))) THEN
          WRITE (*,9002) r,d,nzone(d)
          CALL EXIT
        ENDIF
        CALL getqual(buf(3,i),q,m)
c
c...Combine Distance And Magnitude
c
        k = buf(1,i)-r0(r,d)
        k = MOD(k,CIRCLE)
        IF (k.lt.M_HALF) THEN
          k = k+CIRCLE
        ELSEIF (k.gt.P_HALF) THEN
          k = k-CIRCLE
        ENDIF
        dr = cd(d)*k
        ds = buf(2,i)-s0(d)
        dd = RMULT*SQRT(dr*dr+ds*ds)/size
        dd = 1000*dd + m
c
c...If Cell Is Empty, Use This One
c
        IF (dist(r,d).lt.0) THEN
          dist(r,d) = dd
          qual(r,d) = q
          ra(r,d) = buf(1,i)
          spd(r,d) = buf(2,i)
          mag(r,d) = buf(3,i)
        ELSE
c
c...If This Q Is Better Than Current, Use It
c
          IF (q.lt.qual(r,d)) THEN
            dist(r,d) = dd
            qual(r,d) = q
            ra(r,d) = buf(1,i)
            spd(r,d) = buf(2,i)
            mag(r,d) = buf(3,i)
c
c...If It Is The Same, Use The Closer One
c
          ELSEIF (q.eq.qual(r,d)) THEN
            IF (dd.lt.dist(r,d)) THEN
              dist(r,d) = dd
              qual(r,d) = q
              ra(r,d) = buf(1,i)
              spd(r,d) = buf(2,i)
              mag(r,d) = buf(3,i)
             ENDIF
          ENDIF
        ENDIF
      ENDDO
      RETURN
      END
