      PROGRAM  xjproc
c
c...Look At The XJxxxx.MAG Files
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1000,
     *         nn = 20
      INTEGER
     *         nlb, ntb, i, j, n, mn, mx, npair(NMAX), nfind, nper(NN),
     *         id
      REAL
     *         x, y, sigmax(NMAX), sigmay(NMAX), minmag(NMAX), z, zmin,
     *         maxmag(NMAX), sx(NN), sy(NN), minm(NN), maxm(NN), magn
      CHARACTER*64
     *         lb, tb
c
 9001 FORMAT ('AUXUJ:xj', i4.4, '.mag')
 9002 FORMAT (q, a)
 9003 FORMAT (i3, i8, 5f6.2, i8, f6.2)
 9004 FORMAT (i3, i8, 2f6.2, 2i5)
c
c...Open Output File
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='xjproc.lis',
     *      status='unknown',
     *      unit=1
     *     )
c
c...Just Loop Over Everybody
c
      DO j=1,NMAX
        WRITE (lb,9001) j
        nlb = 16
        CALL f_doenv(lb(1:nlb),ntb,tb)
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=130,
     *        form='formatted',
     *        name=tb(1:ntb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=2
     *       )
        nfind = 0
  110   READ (2,9004,err=110,end=120) i,n,x,y,mn,mx
        IF ((x.le.0.0).or.(y.le.0.0)) GO TO 110
        nfind = nfind+1
        nper(nfind) = n
        sx(nfind) = x
        sy(nfind) = y
        minm(nfind) = 0.01*mn
        maxm(nfind) = 0.01*mx
        id = i
        GO TO 110
  120   CLOSE (2)
c
c...See What We Found
c
        IF (nfind.gt.3) THEN
          x = sx(1)
          y = sy(1)
          z = SQRT(x*x+y*y)
          zmin = z
          n = nper(1)
          magn = minm(1)
          DO i=2,nfind-1
            x = sx(i)
            y = sy(i)
            z = SQRT(x*x+y*y)
            zmin = MIN(z,zmin)
            IF (nper(i).gt.n) THEN
              n = nper(i)
              magn = minm(i)
            ENDIF
          ENDDO
          WRITE (1,9003) id,nper(nfind),sx(nfind),sy(nfind),
     *    minm(nfind),maxm(nfind),zmin,n,magn
        ENDIF
  130   CONTINUE
      ENDDO
      CLOSE (1)
      CALL EXIT
      END
