#include	<sys/time.h>
#include	<signal.h>
#include	<errno.h>
void (*sleep_save)();
extern char lb[];
#define	SLEEP_EPS	500000
/*
 *************************************************************************
 *
 *   timopen
 */
c_timopen_()
{
	return(0);
}
/*
 *************************************************************************
 *
 *   timclose
 */
c_timclose_()
{
	return(0);
}
/*
 ************************************************************************
 *
 *   sleep_sig -- Because uncaught alarm is fatal, this might just
 *		save our tag end one day.  It should never be executed
 *		if our process is running properly
 */
void sleep_sig()
{
	sprintf(lb, "\nSLEEP_SIG");
	x_write3_(lb);
	signal(SIGALRM,sleep_sig);
	return;
}
/*
 ****************************************************************************
 *
 *   sleep  --  Sleep For A While But Don't Go Away
 */
c_sleep_(s_addr)
double *s_addr;
{
	struct itimerval old, new;
	int t, us, sec;
	double s;
/*
 *   Sanity Check
 */
	s = *s_addr;
	if ((s<0.01) || (s>200.0))
		return(-1);
/*
 *   Compute Alarm Value After Adding Offset For Testing
 */
	sec = s;
	us = 1000000.0*(s-sec);
	us += SLEEP_EPS;
	if (us >= 1000000) {
		us -= 1000000;
		sec += 1;
	}
/*
 *   Prepare To Catch Our Signal Just In Case
 */
	sleep_save = signal(SIGALRM,sleep_sig);
/*
 *   Compute Real Time Timer Values
 */
	new.it_value.tv_sec = sec;
	new.it_value.tv_usec = us;
	new.it_interval.tv_sec = 0;
	new.it_interval.tv_usec = 0;
	setitimer(ITIMER_REAL,&new,&old);
/*
 *   Spin-Wait For It To Happen
 */
	for (;;) {
		getitimer(ITIMER_REAL,&old);
		if (old.it_value.tv_sec == 0) {
			if (old.it_value.tv_usec <= SLEEP_EPS)
				break;
		}
	}
/*
 *   Enter Null Value To Stop Timer
 */
	new.it_value.tv_sec = 0;
	new.it_value.tv_usec = 0;
	setitimer(ITIMER_REAL,&new,&old);
	signal(SIGALRM,sleep_sig);
	return(0);
}
/*
 **********************************************************************
 *
 *   Memory Lock/Unlock
 */
c_memlock_(addr,len)
char *addr;
int *len;
{
	int i;

	i = mpin(addr,*len);
	if (i != 0) {
		sprintf(lb, "\nMPIN %d %d", i,errno);
		x_write3_(lb);
	}
	return(i);
}
c_memunlock_(addr,len)
char *addr;
int *len;
{
	return(munpin(addr,*len));
}
