      SUBROUTINE  checkit
c
c...Make Sure That Zone Is Sorted In RA
c
c	NOTE:  Rings near (but not at) the pole will fail the 2-way
c	merge algorithm.  If we sense that the ring is not sorted,
c	sort and save it.
c
      INCLUDE
     *         'ugap12.inc'
      INTEGER
     *         i, n, nlb, j
      CHARACTER*64
     *         lb
      CHARACTER*3
     *         cz
c
 9001 FORMAT (' Zone ', i3, ' Is OK.  N=', i12)
 9002 FORMAT (i3.3)
 9003 FORMAT (i10)
 9004 FORMAT (' Zone ', i3, ' Is Out Of Order.  N=', i12)
 9005 FORMAT (' Zone ', i3, ' Is Too Big.  N=', i12)
 9006 FORMAT (' Cannot Open ', a)
c
c...Get Zone And Count
c
  100 WRITE (cz,9002) zone
      CALL f_doenv('UGAPOUT:ring'//cz//'.hdr',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9003) n
      CLOSE (1)
      IF (n.gt.NSMAX) THEN
        WRITE (*,9005) zone,n
        RETURN
      ENDIF
c
c...Get DATA
c
      lb(nlb-2:nlb) = 'dat'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=(4*n),
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      CALL fastgobble(1,n,bigvec)
      CLOSE (1)
c
c...Check It
c
      DO i=2,n
        IF (bigbuf(RA,i).lt.bigbuf(RA,i-1)) GO TO 110
      ENDDO
      WRITE ( *,9001) zone,n
      WRITE (10,9001) zone,n
      RETURN
c
c...Out Of Order.  Sort It The Long Way
c
  110 WRITE ( *,9004) zone,n
      WRITE (10,9004) zone,n
      DO i=1,n
        zzz(i) = bigbuf(RA,i)
        iii(i) = i
      ENDDO
      CALL iuqsrt(n,zzz,iii)
      DO i=1,n
        bigbuf(RA,i) = zzz(i)
      ENDDO
      DO j=2,4
        DO i=1,n
          zzz(i) = bigbuf(j,i)
        ENDDO
        DO i=1,n
          bigbuf(j,i) = zzz(iii(i))
        ENDDO
      ENDDO
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      recl=(4*n),
     *      recordtype='fixed',
     *      status='old',
     *      unit=1
     *     )
      CALL fastungobble(1,n,bigvec)
      CLOSE (1)
      RETURN
c
c...No File
c
  200 WRITE (*,9006) lb(1:nlb)
      RETURN
      END
