      PROGRAM  genring
c
c...Generate RINGS.DAT
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nspd = 33
      CHARACTER*1
     *         s
      CHARACTER*2
     *         survey
      INTEGER
     *         field, spd, fmin(NSPD), fmax(NSPD), i
      REAL
     *         dd, mm
c
c...Initialization
c
  100 DO i=1,NSPD
        fmin(i) = 0
        fmax(i) = 0
      ENDDO
c
 9001 FORMAT (i6, 1x, a, 27x, a, 2f2.0)
 9002 FORMAT (i6, 30x, a, 2f2.0, 27x, a)
 9003 FORMAT (i3, 2i5)
c
c...Process SOUTH.CAT
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/south.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001)
  110 READ (1,9001,end=120) field,survey,s,dd,mm
      IF (survey.ne.'SB') GO TO 110
      field = field+1000
      dd = dd + mm/60.0
      IF (s.eq.'-') THEN
        dd = -dd
      ENDIF
      spd = 92.5+dd
      spd = (spd/5)+1
      IF ((spd.lt.1).or.(spd.gt.12)) GO TO 110
      IF (fmin(spd).eq.0) THEN
        fmin(spd) = field
        fmax(spd) = field
      ELSE
        fmin(spd) = MIN(field,fmin(spd))
        fmax(spd) = MAX(field,fmax(spd))
      ENDIF
      GO TO 110
  120 CLOSE (1)
c
c...Process POSSI.CAT
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/possi.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002)
  130 READ (1,9002,end=140) field,s,dd,mm,survey
      IF (survey.ne.'aO') GO TO 130
      dd = dd+mm/60.0
      IF (s.eq.'-') THEN
        dd = -dd
      ENDIF
      spd = 93.0+dd
      spd = (spd/6)+3
      IF ((spd.lt.13).or.(spd.gt.33)) GO TO 130
      IF (fmin(spd).eq.0) THEN
        fmin(spd) = field
        fmax(spd) = field
      ELSE
        fmin(spd) = MIN(field,fmin(spd))
        fmax(spd) = MAX(field,fmax(spd))
      ENDIF
      GO TO 130
  140 CLOSE (1)
c
c...Save RINGS.DAT
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='rings.dat',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,NSPD
        IF (i.le.12) THEN
          spd = 5*(i-1)
        ELSE
          spd = 6*(i-3)
        ENDIF
        WRITE (1,9003) spd,fmin(i),fmax(i)
      ENDDO
      CLOSE (1)
      CALL EXIT
      END
