      SUBROUTINE  magbox(dochop,yesmag)
c
c...Profile The Fit By Magnitude Bin
c
      INCLUDE
     *            'tbproc.inc'
      DOUBLE PRECISION
     *            sxbox(25), sxxbox(25), dv(NCMAX), x, z, zc, zo, zr
      INTEGER
     *            dochop, i, j, k, snbox(25), nin, nlb, yesmag
      CHARACTER*64
     *            lb
c
 9002 FORMAT (' N(pair)=', i10, '  N(mag)=', i10, '  N(fit)=', i10)
 9003 FORMAT (i2, i10, 2f10.2)
 9004 FORMAT (3i3, f10.2, 3i10)
 9005 FORMAT (i2, 2(1x, 1pe15.8))
c
c...Initialization
c
  100 DO i=minmag,maxmag
        sxbox(i) = 0.0D00
        sxxbox(i) = 0.0D00
        snbox(i) = 0
      ENDDO
      nin = 0
      yesmag = 0
      DO i=1,npair
        IF (idx(i).gt.0) THEN
          yesmag = yesmag+1
        ENDIF
      ENDDO
c
c...Accumulation
c
      DO i=1,npair
        IF ((dochop.eq.0).or.(tmp(i).ne.0)) THEN
          k = d1(pair1(i))/100
          IF ((k.ge.minmag).and.(k.le.maxmag)) THEN
            x = d2(pair2(i))
            z = d1(pair1(i))
            dv(1) = 1.0D00
            zc = mcoef(1)
            IF (nmcoef.le.1) THEN
              zc = zc+x
            ELSE
              DO j=2,nmcoef
                dv(j) = dv(j-1)*x
                zc = zc + mcoef(j)*dv(j)
              ENDDO
            ENDIF
            zr = 0.01D00*(z-zc)
            sxbox(k) = sxbox(k) + zr
            sxxbox(k) = sxxbox(k) + zr*zr
            snbox(k) = snbox(k) + 1
            nin = nin+1
          ENDIF
        ENDIF
      ENDDO
c
c...Statistics
c
      DO i=minmag,maxmag
        IF (snbox(i).ge.1) THEN
          sxbox(i) = sxbox(i)/snbox(i)
          IF (snbox(i).lt.2) THEN
            sxxbox(i) = 0.0D00
          ELSE
            sxxbox(i) = SQRT(sxxbox(i)/snbox(i) - sxbox(i)*sxbox(i))
          ENDIF
        ENDIF
      ENDDO
      WRITE (*,9002) npair,yesmag,nin
c
c...Correct For Equal Weight
c
      x = SQRT(2.0D00)
      DO i=minmag,maxmag
        sxxbox(i) = sxxbox(i)/x
      ENDDO
c
c...Save
c
      CALL f_doenv(fnout(1:nfnout)//'.phx',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,9004) minmag,maxmag,nmcoef,sigmam,npair,nin,yesmag
      DO i=minmag,maxmag
        WRITE (1,9003) i,snbox(i),sxbox(i),sxxbox(i)
      ENDDO
      DO i=1,nmcoef
        WRITE (1,9005) i,mcoef(i),smcoef(i)
      ENDDO
      CLOSE (1)
      RETURN
      END
