      SUBROUTINE  iterb(old,fatal,nc,manual)
c
c...Full Array Iteration
c
      INCLUDE
     *         'tbproc.inc'
      PARAMETER
     *         npfudge = 100000,
     *         npclose = 100,
     *         nitmax = 50
      INTEGER
     *         ok, err, nold, fatal, nc, manual, niter, old, first
c
 9001 FORMAT (' Fatal Error In Pairfit')
 9002 FORMAT (' NPAIR=', i8, '  Sx=', f10.2, '   Sy=', f10.2,
     *        '  NCoef=', i2, '  Niter=', i2)
 9003 FORMAT (' Enter Find Radius (Micron): ' $)
 9004 FORMAT (f10.0)
c
c...Initialization
c
  100 rmicron = 20.0
      zonerad = -1
c
c...Zone Processing
c
  105 CALL zoneproc(old,manual)
c
c...Loop At This Set Of Conditions
c
      nold = npair
      niter = 0
  110 CALL xformpar
      CALL dofind
      CALL pairfit(x1, xcoef,sxcoef,sigmax, err)
      IF (err.ne.0) THEN
        WRITE (*,9001)
        fatal = 9
        RETURN
      ENDIF
      CALL pairfit(y1, ycoef,sycoef,sigmay, err)
      IF (err.ne.0) THEN
        WRITE (*,9001)
        fatal = 10
        RETURN
      ENDIF
      sigmax = 0.01D00*sigmax
      sigmay = 0.01D00*sigmay
      WRITE (*,9002) npair,sigmax,sigmay,ncoef,niter
      CALL dumpit(0)
c
c...Iterate Until NPAIR Is The Same
c
      IF (manual.le.0) THEN
        IF (zonerad.gt.0) THEN
          IF (npair.le.500) THEN
            IF ((npair-nold).eq.0) GO TO 105
          ELSE
            IF ((ABS(npair-nold)).lt.(npair/NPCLOSE)) GO TO 105
          ENDIF
        ENDIF
        IF (ABS(npair-nold).gt.(npair/NPCLOSE)) THEN
          nold = npair
          niter = niter+1
          IF (niter.gt.NITMAX) THEN
            fatal = 17
            RETURN
          ENDIF
          GO TO 110
        ENDIF
      ELSE
        CALL isitok(ok)
        IF (ok.ge.0) THEN
          IF (ok.eq.0) THEN
  120       WRITE (*,9003)
            READ  (*,9004,err=120,end=200) rmicron
            GO TO 110
          ELSEIF (ok.eq.1) THEN
            GO TO 110
          ELSEIF (ok.eq.2) THEN
            GO TO 105
          ENDIF
        ENDIF
      ENDIF
c
c...Try Bigger Zone
c
      IF (zonerad.gt.0) GO TO 105
c
c...Final (Hopefully Quick) Iteration For More Plate Constants)
c
      IF (nc.ne.ncoef) THEN
        ncoef = nc
        first = 1
  130   CALL dofind
        CALL pairfit(x1, xcoef,sxcoef,sigmax, err)
        IF (err.ne.0) THEN
          WRITE (*,9001)
          fatal = 7
          RETURN
        ENDIF
        CALL pairfit(y1, ycoef,sycoef,sigmay, err)
        IF (err.ne.0) THEN
          WRITE (*,9001)
          fatal = 8
          RETURN
        ENDIF
        sigmax = 0.01D00*sigmax
        sigmay = 0.01D00*sigmay
        WRITE (*,9002) npair,sigmax,sigmay,ncoef,niter
        CALL dumpit(0)
        IF ((first.ne.0)
     *  .or.(ABS(npair-nold).gt.MAX(1,npair/NPFUDGE))) THEN
          first = 0
          nold = npair
          CALL xformpar
          GO TO 130
        ENDIF
      ENDIF
      RETURN
c
c...Read EOF
c
  200 CALL EXIT
      END
