      PROGRAM  fields
c
c...Count Field Overlaps
c
      IMPLICIT
     *          NONE
      PARAMETER
     *          nmax = 1*1000*1000,
     *          np1 = 937+100+894,
     *          nfmax = 50,
     *          million = 1000*1000
      INTEGER
     *          id, nr, i, nfn, buf(2,NMAX), vec(2*NMAX), over(NP1),
     *          nfield, field(NFMAX), pid
      CHARACTER*64
     *          fn
      EQUIVALENCE
     *          (buf(1,1),vec(1))
c
 9001 FORMAT (i4, i10, 1x, q, a)
 9002 FORMAT (20i5)
 9003 FORMAT (' Working On ', a)
c
c...Initialization
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='calfield.01',
     *      status='unknown',
     *      unit=3
     *     )
c
c...Outer Loop Is Over List Of Files
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='callist.01',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9001,end=120) id,nr,nfn,fn
      WRITE (*,9003) fn(1:nfn)
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=fn(1:nfn),
     *      readonly,
     *      recl=(2*nr),
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=2
     *     )
      READ (2,rec=1) (vec(i),i=1,2*nr)
      CLOSE (2)
      DO i=1,NP1
        over(i) = 0
      ENDDO
c
c...Inner Loop Find Primary Fields That Overlap
c
      DO i=1,nr
        pid = buf(1,i)/MILLION
        over(pid) = 1
      ENDDO
      nfield = 0
      DO i=1,NP1
        IF (over(i).ne.0) THEN
          nfield = nfield+1
          field(nfield) = i
        ENDIF
      ENDDO
      WRITE (3,9002) id,nfield,(field(i),i=1,nfield)
      GO TO 110
c
c...All Done
c
  120 CLOSE (2)
      CLOSE (3)
      CALL EXIT
      END
