      SUBROUTINE  tycread(who)
c
c...Read The Tycho Files
c
      INCLUDE
     *            'tycho.inc'
      INTEGER
     *            who, no, ne, i, n, nlb, ntb, j, mag
      DOUBLE PRECISION
     *            b, v, o, e
      CHARACTER*1
     *            c
      CHARACTER*64
     *            lb, tb
c
 9001 FORMAT ('AUXTYC:auxtyc', a, '/to', i4.4, '.fit')
 9002 FORMAT (2x, i10)
 9003 FORMAT (' Cannot Open ', a)
 9004 FORMAT (' Too Many Stars', 2i10, 1x, a)
c
c...TO Files
c
  100 i = who/100
      IF (i.le.9) THEN
        c = CHAR(ICHAR('0')+i)
      ELSE
        c = 'z'
      ENDIF
      WRITE (lb,9001) c,who
      nlb = 25
      CALL f_doenv(lb(1:nlb),ntb,tb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002)
      READ (1,9002)
      READ (1,9002) no
      CLOSE (1)
      IF (no.gt.NTMAX) THEN
        WRITE (*,9004) no,NTMAX,tb(1:ntb)
        no = -1
        ne = -1
        RETURN
      ENDIF
      tb(ntb-2:ntb) = 'res'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      recl=no,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=5) (od2(i),i=1,no)
      READ (1,rec=6) (od1(i),i=1,no)
      READ (1,rec=7) (oid(i),i=1,no)
      CLOSE (1)
      write (*,9991) no
      j = 0
      DO i=1,no
        mag = MOD(od1(i),10000)
        IF ((mag.gt.0).and.(mag.lt.2500)) THEN
          j = j+1
          od1(j) = mag
          od2(j) = MOD(od2(i),10000)
          oid(j) = oid(i)
          oix(j) = j
        ENDIF
      ENDDO
      no = j
      CALL iuqsrt(no,oid,oix)
      write (*,9992) no
 9991 format (' Before ', i10)
 9992 format ('  After ', i10)
c
c...TE Files
c
      tb(ntb-8:ntb-8) = 'e'
      tb(ntb-2:ntb) = 'fit'
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002)
      READ (1,9002)
      READ (1,9002) ne
      CLOSE (1)
      IF (ne.gt.NTMAX) THEN
        WRITE (*,9004) ne,NTMAX,tb(1:ntb)
        no = -3
        ne = -3
        RETURN
      ENDIF
      tb(ntb-2:ntb) = 'res'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      recl=ne,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=5) (ed2(i),i=1,ne)
      READ (1,rec=6) (ed1(i),i=1,ne)
      READ (1,rec=7) (eid(i),i=1,ne)
      CLOSE (1)
      write (*,9991) ne
      j = 0
      DO i=1,ne
        mag = MOD(ed1(i),10000)
        IF ((mag.gt.0).and.(mag.lt.2500)) THEN
          j = j+1
          ed1(j) = mag
          ed2(j) = MOD(ed2(i),10000)
          eid(j) = eid(i)
          eix(j) = j
        ENDIF
      ENDDO
      ne = j
      CALL iuqsrt(ne,eid,eix)
      write (*,9992) ne
c
c...Return Only Fully Matching Pairs
c
      mo = 0
      me = 0
      DO i=1,no
        CALL bisect(oid(i),ne,eid,j)
        IF (j.gt.0) THEN
          b = 0.01D00*od1(oix(i))
          v = 0.01D00*ed1(eix(j))
          CALL bvtooe(b,v,o,e)
          IF ((o.ne.TAG).and.(e.ne.TAG)) THEN
            mo = mo+1
            pmo(mo) = o
            smo(mo) = 0.01D00*od2(oix(i))
            me = me+1
            pme(me) = e
            sme(me) = 0.01D00*ed2(eix(j))
      write (*,9993) mo,pmo(mo),smo(mo),me,pme(me),sme(me)
 9993 format (2(i5, 2f10.2))
          ENDIF
        ENDIF
      ENDDO
      RETURN
c
c..Big Problem
c
  200 WRITE (*,9003) tb(1:ntb)
      no = -2
      ne = -2
      RETURN
      END
