      SUBROUTINE  tychor
c
c...Load The Tycho Magnitudes
c
      INCLUDE
     *            'tycho.inc'
      INTEGER
     *            nlb, i, id, flag
      DOUBLE PRECISION
     *            pmm, tyc, phat, dv
      CHARACTER*64
     *            lb
c
 9001 FORMAT (q, a)
 9002 FORMAT (5x, 2f8.2, 11(8x), 2i8)
 9003 FORMAT (' N(ROK)=', i6)
c
c...Outer Loop Is Over ROK Files
c
  100 CALL system('\ls $PIPROG/*.rok >tychor.inp')
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='delete',
     *      form='formatted',
     *      name='tychor.inp',
     *      status='old',
     *      unit=1
     *     )
      nr = 0
  110 READ (1,9001,end=140) nlb,lb
c
c...Inner Loop Collects The TYCHO Pairs
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=110,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=2
     *     )
  120 READ (2,9002,end=130) tyc,pmm,flag,id
      IF (flag.ne.2) GO TO 120
      phat = 0.0D00
      dv = 1.0D00
      IF (nrpoly(id).eq.1) THEN
        phat = pmm + rpoly(1,id)
      ELSE
        DO i=1,nrpoly(id)
          phat = phat + dv*rpoly(i,id)
          dv = dv*pmm
        ENDDO
      ENDIF
      nr = nr+1
      rt(nr) = tyc
      rp(nr) = phat
      rs(nr) = id
      GO TO 120
  130 CLOSE (2)
      GO TO 110
  140 WRITE (*,9003) nb
      RETURN
      END
