      SUBROUTINE  nsmean(nn,xx,yy,wide, nq,xq,yq,wq,pq)
c
c...Do Chopped Mean In Each Histogram Zone
c
      INCLUDE
     *            'nsfit.inc'
      INTEGER
     *            nn, nq, i, j, sn(NXHIST)
      DOUBLE PRECISION
     *            xx(*), yy(*), xq(*), yq(*), wq(*), pq(*), y, wide,
     *            sy(NXHIST), syy(NXHIST), yl(NXHIST), yh(NXHIST)
c
c...Initialization
c
  100 DO i=1,NXHIST
        sn(i) = 0
        sy(i) = 0.0D00
        syy(i) = 0.0D00
        yl(i) = TAG
        yh(i) = TAG
      ENDDO
      DO i=1,nq
        j = xq(i)
        yl(j) = yq(i) - wide*wq(i)
        yh(j) = yq(i) + wide*wq(i)
      ENDDO
c
c...Summation
c
      DO i=1,nn
        j = xx(i)
        IF (yl(j).ne.TAG) THEN
          y = yy(i)
          IF ((y.ge.yl(j)).and.(y.le.yh(j))) THEN
            sn(j) = sn(j) + 1
            sy(j) = sy(j) + y
            syy(j) = syy(j) + y*y
          ENDIF
        ENDIF
      ENDDO
c
c...Statistics
c
      y = 0.0D00
      DO i=1,NXHIST
        y = y+sn(i)
      ENDDO
      DO i=1,nq
        j = xq(i)
        wq(i) = 100.0D00*sn(j)/y
        IF (sn(j).le.0) THEN
          yq(i) = TAG
          wq(i) = TAG
        ELSEIF (sn(j).eq.1) THEN
          yq(i) = sy(j)
          wq(i) = 0.0D00
        ELSE
          yq(i) = sy(j)/sn(j)
          wq(i) = SQRT(syy(j)/sn(j) - yq(i)*yq(i))
        ENDIF
      ENDDO
      RETURN
      END
