      SUBROUTINE  mufind
c
c...Look In Sorted Lists For Pairs
c
      INCLUDE
     *            'p1p2.inc'
      PARAMETER
     *            nqmax = 100
      INTEGER
     *            get, low, high, r, xl, xh, nfind, i,
     *            ifind(NQMAX), jfind(NQMAX), test, yl,
     *            yh, yt, iz
      DOUBLE PRECISION
     *            dx, dy, dr, rfind(NQMAX), z, rsqr
c
 9001 FORMAT (' MUFIND Found ', i6, ' Possible Associations')
c
c...Initialization
c
  100 get = 0
      ntry = 0
      low = 1
      high = 1
      r = radius*XYSCALE + 0.5D00
      rsqr = (r/XYSCALE)**2
c
c...Outer Loop Over (1) Index
c
  110 get = get+1
      IF (get.gt.n1) THEN
        WRITE (*,9001) ntry
        RETURN
      ENDIF
      xl = x1(get) - r
      xh = x1(get) + r
      yl = y1(get) - r
      yh = y1(get) + r
c
c...Inner Loop Brackets (2)
c
  120 CONTINUE
      IF (x2hat(low).lt.xl) THEN
        IF (low.lt.n2) THEN
          low = low+1
          GO TO 120
        ENDIF
      ENDIF
      IF (x2hat(low).gt.xh) GO TO 110
      IF (high.lt.low) THEN
        high = low
      ENDIF
  130 CONTINUE
      IF (high.lt.n2) THEN
        IF (x2hat(high+1).le.xh) THEN
          high = high+1
          GO TO 130
        ENDIF
      ENDIF
c
c...Test All Entries In This Range
c
      nfind = 0
      DO test=low,high
        yt = y2hat(test)
        IF ((yt.ge.yl).and.(yt.le.yh)) THEN
          dy = ((yt-y1(get))/XYSCALE)**2
          IF (dy.le.rsqr) THEN
            dx = ((x2hat(test)-x1(get))/XYSCALE)**2
            dr = dx+dy
            IF (dr.le.rsqr) THEN
              IF (nfind.lt.NQMAX) THEN
                nfind = nfind+1
                ifind(nfind) = get
                jfind(nfind) = idx2(test)
                rfind(nfind) = SQRT(dr)
                IF (nfind.eq.1) THEN
                  iz = nfind
                  z = rfind(iz)
                ELSE
                  IF (rfind(nfind).lt.z) THEN
                    iz = nfind
                    z = rfind(iz)
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Save
c
      IF (nfind.gt.0) THEN
        DO i=1,nfind
          ntry = ntry+1
          itry(ntry) = ifind(i)
          jtry(ntry) = jfind(i)
          ktry(ntry) = ntry
          rtry(ntry) = rfind(i)
          IF (i.eq.iz) THEN
            ltry(ntry) = 1
          ELSE
            ltry(ntry) = 0
          ENDIF
        ENDDO
      ENDIF
c
c...Loop Until Completion.  RETURN Is On GET
c
      GO TO 110
      END
