      SUBROUTINE  nodup2
c
c...Remove Duplicate Entries
c
      INCLUDE
     *            'p1p2.inc'
      PARAMETER
     *            arcsec = 1.0D00,
     *            nfmax = 100
      INTEGER
     *            test, low, high, xl, xh, yl, yh, nfind, rad,
     *            ifind(NFMAX), mfind(NFMAX), i, j
      REAL
     *            dr, rfind(NFMAX), dx, dy, rsqr
c
 9001 FORMAT (' NODUP2 Removed ', i12)
c
c...Initializations
c
  100 DO i=1,n2
        idx2(i) = i
      ENDDO
      CALL iuqsrt(n2,x2,idx2)
      CALL ireord(n2,idx2,y2,tmp)
      CALL ireord(n2,idx2,m2,tmp)
      CALL ireord(n2,idx2,j2,tmp)
      test = 0
      low = 1
      high = 1
      rad = XYSCALE*ARCSEC/TELSCALE
      rsqr = (rad/XYSCALE)**2
c
c...Outer Loop Over Tested Star
c
  110 test = test+1
      IF (test.gt.n2) GO TO 200
      IF (x2(test).eq.TAG) GO TO 110
      xl = x2(test)-rad
      xh = x2(test)+rad
      yl = y2(test)-rad
      yh = y2(test)+rad
c
c...Look For LOW Limit
c
  120 IF (low.le.n2) THEN
        IF (x2(low).eq.TAG) THEN
          low = low+1
          GO TO 120
        ELSEIF (x2(low).lt.xl) THEN
          low = low+1
          GO TO 120
        ENDIF
      ENDIF
c
c...Look For HIGH Limit
c
      high = MAX(low,test)
      i = high
  130 i = i+1
      IF (i.le.n2) THEN
        IF (x2(i).eq.TAG) THEN
          GO TO 130
        ELSEIF (x2(i).le.xh) THEN
          high = i
          GO TO 130
        ENDIF
      ENDIF
c
c...Range From LOW to HIGH Needs To Be Examined
c
      nfind = 0
      DO i=low,high
        dx = (x2(i)-x2(test))/XYSCALE
        dy = (y2(i)-y2(test))/XYSCALE
        dr = dx*dx + dy*dy
        IF (dr.le.rsqr) THEN
          IF (nfind.lt.NFMAX) THEN
            nfind = nfind+1
            ifind(nfind) = i
            mfind(nfind) = m2(i)
          ENDIF
        ENDIF
      ENDDO
c
c...Put Selection Logic Somewhere Else
c
      IF (nfind.gt.1) THEN
        CALL select(nfind,ifind,mfind,j)
        DO i=1,nfind
          IF (i.ne.j) THEN
            x2(ifind(i)) = TAG
          ENDIF
        ENDDO
      ENDIF
c
c...All Done
c
      GO TO 110
  200 j = 0
      DO i=1,n2
        IF (x2(i).ne.TAG) THEN
          j = j+1
          x2(j) = x2(i)
          y2(j) = y2(i)
          m2(j) = m2(i)
          j2(j) = j2(i)
        ENDIF
      ENDDO
      i = n2-j
      n2 = j
      WRITE (*,9001) i
      RETURN
      END
