      PROGRAM  itercal
c
c...Driver For Iterative Photometric Calibration Of USNO-A
c
      IMPLICIT
     *         NONE
      INTEGER
     *         i, n
      CHARACTER*2
     *         cb
c
 9001 FORMAT (i2.2)
 9002 FORMAT (i10)
c
c...Clear Out PAR And Previous Solutions
c
  100 i = 0
c
c...Use Utilities To Do Each Step
c
  110 i = i+1
      WRITE (cb,9001) i
      CALL system('calib '//cb)
      CALL system('parfit '//cb)
      CALL system('summary '//cb)
c
c...Output Of SUMMARY Tells Us When To Stop
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='summary.'//cb,
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002) n
      CLOSE (1)
      IF (n.gt.0) GO TO 110
c
c...Take A Few More Iterations To Let Things Settle
c
      DO n=1,2
        i = i+1
        WRITE (cb,9001) i
        IF (n.eq.1) THEN
          CALL system('calib '//cb)
        ELSE
          CALL system('fakecalib '//cb)
        ENDIF
        CALL system('parfit '//cb)
        CALL system('summary '//cb)
      ENDDO
      CALL EXIT
      END
