      PROGRAM  color1
c
c...Playing With Fits To Each Star
c
      INCLUDE
     *          'color1.inc'
      CHARACTER*64
     *         in, out
      INTEGER
     *         nin, nout, i, n, err, j, nrej, nok, saveit, k, l
      DOUBLE PRECISION
     *         m1, m2, m3, m4, m5, snr(NCMAX)
c
 9001 FORMAT (q, a)
 9002 FORMAT (2i5, 5f6.0, 2i5)
 9003 FORMAT (2i10, f10.2, 2i10)
 9004 FORMAT (2(1x,1pe14.7))
 9005 FORMAT (t71, i4, 1x, a, t1, 2i4, i2, f5.2, 3(f9.4,f5.1))
 9006 FORMAT (' Processing ', a)
 9007 FORMAT (i5, 1x, a)
 9008 FORMAT (' Mode=', i1, '  N(ok)=', i3, '   N(rej)=', i3)
c
c...Generate And Open File Of Star
c
  100 CALL loadtable
      CALL loadaah
      mode = 2
      saveit = 1
      CALL system('\ls $PIPROG >color1.inp')
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='color1.inp',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='color1.out',
     *      status='unknown',
     *      unit=3
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='color1.no',
     *      status='unknown',
     *      unit=4
     *     )
      IF (saveit.ne.0) THEN
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name='color1.dat',
     *        status='unknown',
     *        unit=10
     *       )
      ENDIF
      nrej = 0
      nplate = 0
c
c...Outer Loop Over Stars
c
  110 READ (1,9001,err=110,end=150) nsname,sname
      IF (nsname.le.3) GO TO 110
      IF (sname(nsname-2:nsname).ne.'.ph') GO TO 110
      nsname = nsname-3
      WRITE (*,9006) sname(1:nsname)
      CALL f_doenv('PIPROG:'//sname(1:nsname)//'.ph',nin,in)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=in(1:nin),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=2
     *     )
      mm = 0
c
c...Inner Loop Over Star
c
  120 READ (2,9002,err=120,end=130) i,j,m1,m2,m3,m4,m5,k,l
      mm = mm+1
      mo(mm) = m1
      me(mm) = m2
      bb(mm) = m3
      vv(mm) = m4
      ii(mm) = m5
      IF (mm.eq.1) THEN
        plate = l
      ENDIF
      GO TO 120
  130 CLOSE (2)
c
c...Do The Fit Where It Is Easy To Play With
c
      nc = 2
      CALL vminusi(err)
      IF (err.ne.0) GO TO 200
      CALL select1(err)
      IF (err.ne.0) GO TO 200
      CALL dofit1(err)
      IF (err.ne.0) GO TO 200
c
c...See If Trimming Helps
c
      CALL trim1
      IF (ntrim.ne.0) THEN
        CALL dofit1(err)
        IF (err.ne.0) THEN
          err = err-3
          GO TO 200
        ENDIF
      ENDIF
c
c...Save The Fits In 2 Places
c
      out = in
      nout = nin
      out(nout-1:nout) = 'ft'
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=out(1:nout),
     *      status='unknown',
     *      unit=2
     *     )
      WRITE (2,9003) nc,mm,sg,nuse,ntrim
      DO i=1,nc
        WRITE (2,9004) cc(i),ss(i)
      ENDDO
      CLOSE (2)
      IF (nsname.lt.10) THEN
        DO i=nsname+1,10
          sname(i:i) = ' '
        ENDDO
      ENDIF
      nsname = 10
      DO i=1,nc
        snr(i) = ABS(cc(i)/ss(i))
        snr(i) = MIN(snr(i),99.9D00)
      ENDDO
      WRITE (3,9005) plate,sname(1:nsname),nuse,ntrim,nc,sg,
     *               (cc(i),snr(i),i=1,nc)
      nok = nok+1
c
c...Determine A Unique Plate Number.  Append PHX Data If Needed.
c
      j = plate
      DO plate=1,nplate
        IF (plid(plate).eq.j) GO TO 140
      ENDDO
      nplate = nplate+1
      plid(nplate) = j
      plate = nplate
  140 CONTINUE
c
c...Save The Data
c
      IF (saveit.ne.0) THEN
        CALL savedata(nok)
      ENDIF
      GO TO 110
c
c...All Done
c
  150 CLOSE (1)
      CLOSE (3)
      CLOSE (4)
      IF (saveit.ne.0) THEN
        CLOSE (10)
      ENDIF
      WRITE (*,9008) mode,nok,nrej
      CALL EXIT
c
c...Common Error Processing
c
  200 WRITE (4,9007) err,sname(1:nsname)
      nrej = nrej+1
      GO TO 110
      END
