      PROGRAM  compare
c
c...See If ZeroPoints Are At All Close
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nfmax = 937
      DOUBLE PRECISION
     *         cmag(NFMAX), pmag(NFMAX), zp(NFMAX), cc(10),
     *         x, y, z
      INTEGER
     *         i, j, id(NFMAX), np, nc
c
 9001 FORMAT (i5, 2f10.0)
 9002 FORMAT (i3, 3f10.0, i5)
 9003 FORMAT (i5, 4f10.2)
c
c...Ingest The PHXBAR Results
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='phxbar.out',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO j=1,NFMAX
        READ (1,9001) i,cmag(j),pmag(j)
        IF (i.ne.j) THEN
          STOP 'PHX Problem'
        ENDIF
      ENDDO
      CLOSE (1)
c
c...Read COLOR2 File
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='color2.fit',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9002,err=110,end=120) i,x,y,z,j
      IF (j.gt.0) THEN
        np = np+1
        zp(np) = x
        id(np) = j
      ELSE
        nc = nc+1
        cc(nc) = x
      ENDIF
      GO TO 110
  120 CLOSE (1)
c
c...Loop And Compare
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='compare.out',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,np
        x = cmag(id(i))
        y = zp(i)
        DO j=1,nc
          y = y + cc(j)*x**j
        ENDDO
        z = pmag(id(i))-y
        WRITE (1,9003) id(i),cmag(id(i)),pmag(id(i)),y,z
      ENDDO
      CLOSE (2)
      CALL EXIT
      END
