      SUBROUTINE  dofit1(nn,mo,me,vv,ii,bb,rr,jj, nc,cc,ss,sg, err)
c
c...Least Squares Fit Of Some Kind
c
      IMPLICIT
     *            NONE
      PARAMETER
     *            ncmax = 5
      INTEGER
     *            nn, nc, i, j, k, ising, jj(*), nin, nfree, err
      DOUBLE PRECISION
     *            mo(*), me(*), vv(*), ii(*), bb(*), cc(*), ss(*),
     *            sg, chisq, y, yc, yr, dv(NCMAX), zlhs(NCMAX),
     *            zrhs(NCMAX,NCMAX), rr(*)
c
c...Initialization
c
  100 DO i=1,nc
        cc(i) = 0.0D00
        zlhs(i) = 0.D00
        DO j=1,nc
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
      nin = 0
c
c...Accumulation
c
      DO i=1,nn
        IF (jj(i).ne.0) THEN
          CALL gimmedv(mo(i),me(i),vv(i),ii(i),bb(i), y, nc,dv)
          DO j=1,nc
            zlhs(j) = zlhs(j) + dv(j)*y
            DO k=1,nc
              zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
            ENDDO
          ENDDO
          nin = nin+1
        ENDIF
      ENDDO
c
c...Inversion
c
      nfree = nin - (nc+1)
      IF (nfree.le.0) THEN
        err = -1
        RETURN
      ENDIF
      CALL inv1(nc,zrhs,ising)
      IF (ising.ne.0) THEN
        err = -2
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,nc
        DO j=1,nc
          cc(i) = cc(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=1,nn
        CALL gimmedv(mo(i),me(i),vv(i),ii(i),bb(i), y, nc,dv)
        yc = 0.0D00
        DO j=1,nc
          yc = yc + dv(j)*cc(j)
        ENDDO
        yr = y-yc
        rr(i) = yr
        IF (jj(i).ne.0) THEN
          chisq = chisq + yr*yr
        ENDIF
      ENDDO
c
c...Errors
c
      sg = SQRT(chisq/nfree)
      DO i=1,nc
        ss(i) = sg*SQRT(zrhs(i,i))
      ENDDO
      err = 0
      RETURN
      END
