      PROGRAM  piexam
c
c...Look At Pi Program Stars For Those With Enough Photometry For The PMM
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nphmax = 1000
      INTEGER
     *         nlb, nph, nphname(NPHMAX), nproc, i, id, n, nok, j, s
      REAL
     *         vv, bv, vi, x, y
      CHARACTER*20
     *         lb, phname(NPHMAX)
c
 9001 FORMAT (q, a)
 9002 FORMAT (' Found ', i3, ' PHT Files')
 9003 FORMAT (i4, 2f10.0, 3f7.0)
 9004 FORMAT (a, 2i5)
 9005 FORMAT (' N(proc)=', i4, '  N(ok)=', i4)
c
c...Generate And Open Pi Program Files
c
  100 CALL system('\ls /ux2/ccdpi >pi.lis')
      CALL system('echo "***" >>pi.lis')
      CALL system('\ls /ux2/ccdcand >>pi.lis')
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='pi.lis',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      nproc = 0
      s = 0
c
c...Generate And Open Photometry Files
c
      CALL system('\ls /ux2/newph >pi.pht')
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='pi.pht',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=2
     *     )
      nph = 0
c
c...Open The Output File
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='piexam.out',
     *      status='unknown',
     *      unit=3
     *     )
      nok = 0
c
c...Ingest The Photometry File Names
c
  110 READ (2,9001,err=110,end=120) nlb,lb
      IF (lb(nlb-3:nlb).ne.'.pht') GO TO 110
      nph = nph+1
      phname(nph) = lb
      nphname(nph) = nlb-4
      GO TO 110
  120 CLOSE (2)
      WRITE (*,9002) nph
c
c...Outer Loop Over Pi Program Stars
c
  130 READ (1,9001,err=130,end=160) nlb,lb
      IF ((nlb.eq.3).and.(lb(1:3).eq.'***')) THEN
        s = 1
        GO TO 130
      ENDIF
      IF (lb(nlb-3:nlb).ne.'.lis') GO TO 130
      nlb = nlb-4
      DO i=1,nph
        IF (lb(1:nlb).eq.phname(i)(1:nphname(i))) THEN
          nproc = nproc+1
c
c...Read The PHT File To See If There Are Enough Useful Entries
c
          OPEN (
     *          access='sequential',
     *          carriagecontrol='list',
     *          dispose='keep',
     *          form='formatted',
     *          name='/ux2/newph/'//lb(1:nlb)//'.pht',
     *          readonly,
     *          shared,
     *          status='old',
     *          unit=2
     *         )
          n = 0
  140     READ (2,9003,err=140,end=150) id,x,y,vv,vi,bv
          IF ((ABS(id).ne.1).and.(vv.gt.0.0)) THEN
            n = n+1
          ENDIF
          GO TO 140
  150     CLOSE (2)
          IF (n.ge.10) THEN
            nok = nok+1
            IF (nlb.lt.10) THEN
              DO j=nlb+1,10
                lb(j:j) = ' '
              ENDDO
              nlb = 10
            ENDIF
            WRITE (3,9004) lb(1:nlb),n,s
          ENDIF
          GO TO 130
        ENDIF
      ENDDO
      GO TO 130
  160 CLOSE (1)
c
c...All Done
c
      WRITE (*,9005) nproc,nok
      CALL EXIT
      END
