      PROGRAM  plotmag
c
c...Plot A LIST.1 or .2 File By Magnitude
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         bright = 2.0,
     *         faint = 0.2,
     *         nmax = 1000
      REAL
     *         xx(NMAX,2), yy(NMAX,2), mm(NMAX,2), x, y, m,
     *         xmin, xmax, ymin, ymax, xbar, ybar, xwide, ywide,
     *         mmin(2), mmax(2), t, t0, SECNDS
      CHARACTER*64
     *         lb
      INTEGER
     *         i, nlb, nn(2), j
      CHARACTER*6
     *         fn(2)
      DATA
     *         fn/'list.1', 'list.2'/
c
 9001 FORMAT (i6, 3f10.0)
c
  100 xmin = 0.0
      xmax = 0.0
      ymin = 0.0
      ymax = 0.0
      DO i=1,2
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=fn(i),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        nn(i) = 0
  110   READ (1,9001,end=120) j,x,y,m
        nn(i) = nn(i)+1
        xx(nn(i),i) = x
        yy(nn(i),i) = y
        mm(nn(i),i) = m
        xmin = MIN(xmin,x)
        xmax = MAX(xmax,x)
        ymin = MIN(ymin,y)
        ymax = MAX(ymax,y)
        IF (nn(i).eq.1) THEN
          mmin(i) = m
          mmax(i) = m
        ELSE
          mmin(i) = MIN(mmin(i),m)
          mmax(i) = MAX(mmax(i),m)
        ENDIF
        GO TO 110
  120   CLOSE (1)
      ENDDO
c
c...Set Limits
c
      x = 1.25*MAX(xmax,-xmin,ymax,-ymin)
      xmin = -x
      xmax = x
      ymin = -x
      ymax = x
      CALL mgoinit
      CALL mgosetup(-7)
      CALL mgoerase
      CALL mgosetlim(xmin,ymin,xmax,ymax)
      CALL mgobox(1,1)
      CALL mgoxlabel(6,'LIST.1')
      x = BRIGHT
      y = (FAINT-BRIGHT)/(mmax(1)-mmin(1))
      DO i=1,nn(1)
        m = x + y*(mm(i,1)-mmin(1))
        CALL mgosetexpand(m)
        CALL mgopoints(203.,1, xx(i,1),yy(i,1),1)
      ENDDO
      CALL mgoprntplot(i)
c
c...Wait And Do It Again
c
      t0 = SECNDS(0.0)
  130 t = SECNDS(t0)
      IF (t.le.2.0) GO TO 130
      CALL mgoerase
      CALL mgobox(1,1)
      CALL mgoxlabel(6,'LIST.2')
      x = BRIGHT
      y = (FAINT-BRIGHT)/(mmax(2)-mmin(2))
      DO i=1,nn(2)
        m = x + y*(mm(i,2)-mmin(2))
        CALL mgosetexpand(m)
        CALL mgopoints(203.,1, xx(i,2),yy(i,2),1)
      ENDDO
      CALL mgoprntplot(i)
      CALL EXIT
      END
