      PROGRAM  newacc
c
c...Check The ACC Files
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nzone = 96,
     *         nchunk = 1*1000*1000
      REAL
     *         ra(NZONE)
      INTEGER
     *         nlb, i, frst(NZONE), long(NZONE), nloop, nmost, l,
     *         nlast, buf(3,NCHUNK), fd, err, C_ROOPEN, C_READER, t,
     *         j, k, total, test(NZONE+1), zone, of(NZONE), ol(NZONE),
     *         C_GENLEN, m, nbyte, nrec
      CHARACTER*80
     *         lb
      BYTE
     *         bb(81)
c
 9001 FORMAT (f5.2, 2i12)
 9003 FORMAT (' T=', i2, '  Obs=', i12, '   ACC=', i12, ' Err=', i12)
 9004 FORMAT ('/uv6/xpmm/zone/zone', i4.4, '.acc')
 9005 FORMAT (' Checking ', a)
 9006 FORMAT (' Read Error=', i12)
 9007 FORMAT (' File Size=', i12, ' Records')
 9008 FORMAT (' CAT Length Error', 2i12)
c
c...Eat The ACC File
c
  100 DO zone=1725,0,-75
      WRITE (lb,9004) zone
      nlb = 27
      WRITE (*,9005) lb(1:nlb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(nlb-11:nlb),
     *      status='unknown',
     *      unit=2
     *     )
      DO i=1,NZONE
        READ (1,9001) ra(i),frst(i),long(i)
      ENDDO
      CLOSE (1)
c
c...Get Length Of File From Disk
c
      lb(nlb-2:nlb) = 'cat'
      DO i=1,nlb
        bb(i) = ICHAR(lb(i:i))
      ENDDO
      bb(nlb+1) = 0
      nbyte = C_GENLEN(bb)
      nrec = nbyte/12
      IF (MOD(nbyte,12).ne.0) THEN
        WRITE (*,9008) nbyte,nrec
      ENDIF
      WRITE (*,9007) nrec
c
c...Compute The Test Values
c
      DO i=1,NZONE+1
        test(i) = i*0.25*15.0D00*3600.0D00*100.0D00 + 0.5D00
      ENDDO
c
c...Compute The Parameters Of The CHUNK Reads
c
      nloop = ((nrec-1)/NCHUNK) + 1
      nmost = NCHUNK
      nlast = nrec - (nloop-1)*NCHUNK
      t = 1
      fd = C_ROOPEN(bb)
      IF (fd.lt.3) THEN
        CALL EXIT
      ENDIF
      total = 0
c
c...Do The Loop
c
      of(1) = 1
      DO i=1,nloop
        IF (i.eq.nloop) THEN
          m = nlast
        ELSE
          m = nmost
        ENDIF
        err = C_READER(fd,buf,12*m)
        IF (err.ne.0) THEN
          WRITE (*,9006) err
          pause
        ENDIF
        DO j=1,m
          IF (buf(1,j).ge.test(t)) THEN
            t = t+1
            k = total+j
            err = k-frst(t)
            of(t) = k
            IF (err.ne.0) THEN
              WRITE (*,9003) t,k,frst(t),err
            ENDIF
            IF (t.ge.NZONE) GO TO 110
          ENDIF
        ENDDO
        total = total+m
      ENDDO
      CALL c_closer(fd)
  110 CONTINUE
      DO i=2,NZONE
        ol(i-1) = of(i)-of(i-1)
      ENDDO
      ol(NZONE) = nrec+1-of(NZONE)
      DO i=1,NZONE
        WRITE (2,9001) ra(i),of(i),ol(i)
      ENDDO
      CLOSE (2)
      ENDDO
      CALL EXIT
      END
