      SUBROUTINE  piprog(sname,id,which,xo,yo,mo,lo,err)
c
c...Read PIPROG UA Files Into User Catalog
c
      INCLUDE
     *            'reverse.inc'
      INTEGER
     *            id, which, xo(*), yo(*), mo(*), lo(*), err, nlb,
     *            ncoef, i, npi, j, z, k, j2, k2, f, n, m, l
      DOUBLE PRECISION
     *            sigmax, sigmay, rcent, dcent, xcoef(NCMAX),
     *            ycoef(NCMAX), sxcoef(NCMAX), sycoef(NCMAX), m1, m2,
     *            u1, u2, m3
      CHARACTER*(*)
     *            sname
      CHARACTER*11
     *            rstr, dstr
      CHARACTER*64
     *            lb
c
 9001 FORMAT (i3, 2(1x,a), 3f6.2, i5, i12, 2f6.2, 2i12, i5)
 9002 FORMAT (2i10, 2f10.2, 2f10.5)
 9003 FORMAT (4(1x,1pe14.7))
c
c...Ingest UA File
c
  100 CALL f_doenv('PIPROG:'//sname//'.ua',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002) ncoef,npi,sigmax,sigmay,rcent,dcent
      DO i=1,ncoef
        READ (1,9003) xcoef(i),ycoef(i),sxcoef(i),sycoef(i)
      ENDDO
      n = 0
      id = -98765
      DO i=1,npi
        READ (1,9001) m,rstr,dstr,m1,m2,m3,z,k,u1,u2,j2,k2,f
        IF ((id.le.0).and.(f.gt.0)) THEN
          id = f
        ENDIF
        IF (id.eq.f) THEN
          n = n+1
          xo(n) = j2
          yo(n) = k2
          j = 10.0D00*m1 + 0.5D00
          k = 10.0D00*m2 + 0.5D00
          l = 10.0D00*m3 + 0.5D00
          mo(n) = (1000000*j) + (1000*k) + l
          lo(n) = m
        ENDIF
      ENDDO
      CLOSE (1)
c
c...Sort On RA And Update Global Variables
c
      IF (dcent.ge.-25.0D00) THEN
        src = 1
      ELSE
        IF (f.le.606) THEN
          src = 3
        ELSE
          src = 1
        ENDIF
      ENDIF
      nn(which) = n
      DO i=1,n
        xe(i) = i
      ENDDO
      CALL iuqsrt(n,xo,xe)
      CALL ireord(n,xe,yo,ye)
      CALL ireord(n,xe,mo,ye)
      CALL ireord(n,xe,lo,ye)
      RETURN
c
c...No File
c
  200 err = -7
      RETURN
      END
