      SUBROUTINE  runpack
c
c...Unpack The Various Red Variables
c
      INCLUDE
     *            'usexid.inc'
      PARAMETER
     *            mag_err = 1,
     *            amp_err = 2,
     *            r0_err = 4,
     *            m00_err = 8,
     *            pcnt_err = 16
      INTEGER
     *            i, err, u, nlb, source
      REAL
     *            x, y, s, c
      CHARACTER*64
     *            lb
c
 9001 FORMAT (i5, 5f8.2, 8f7.2, 3i8)
c
c...BUF Contains (4) = IDST
c
  100 DO i=1,nk
        prmag(i) = 0.01*rbuf(kridx(i))
        IF (prmag(i).ge.25.0) THEN
          prerr(i) = MAG_ERR
        ELSE
          prerr(i) = 0
        ENDIF
      ENDDO
c
c...Process (1) = IAST
c
      CALL p1xid(field,'se',1,nb,bbuf,err)
      DO i=1,nk
        CALL xiast(bbuf(kridx(i)),pramp(i),prm00(i))
        IF ((pramp(i).le.225.0).and.(prmag(i).le.18.0)) THEN
          prerr(i) = IOR(prerr(i),AMP_ERR)
        ENDIF
      ENDDO
c
c...Process (2) = IBST
c
      CALL p1xid(field,'se',2,nb,bbuf,err)
      DO i=1,nk
        CALL xibst(bbuf(kridx(i)),prsig(i),prr0(i))
        IF (prr0(i).ge.700.0) THEN
          prerr(i) = IOR(prerr(i),R0_ERR)
        ENDIF
      ENDDO
c
c...Process (3) = ICST
c
      CALL p1xid(field,'se',3,nb,bbuf,err)
      DO i=1,nk
        CALL xicst(bbuf(kridx(i)),prm00(i))
        IF (prm00(i).le.0.0) THEN
          prerr(i) = IOR(prerr(i),M00_ERR)
        ENDIF
      ENDDO
c
c...Process (5) = IEST
c
      CALL p1xid(field,'se',5,nb,bbuf,err)
      DO i=1,nk
        CALL xiest(bbuf(kridx(i)),prdiag(i))
      ENDDO
c
c...Process (8) = ITST
c
      CALL p1xid(field,'se',8,nb,bbuf,err)
      DO i=1,nk
        CALL xitst(bbuf(kridx(i)),prnin(i),prnsat(i))
      ENDDO
c
c...Process (9)+(10) = IXST+IYST
c
      CALL p1xid(field,'se',9,nb,bbuf,err)
      DO i=1,nk
        CALL xixst(bbuf(kridx(i)),prrad(i))
      ENDDO
      CALL p1xid(field,'se',10,nb,bbuf,err)
      DO i=1,nk
        CALL xiyst(bbuf(kridx(i)),prrad(i))
      ENDDO
c
c...Do The Integral
c
      DO i=1,nk
        s = prsig(i)*prsig(i)
        x = -prr0(i)/s
        y = EXP(x)
        print(i) = -3.14*s*pramp(i)*LOG(y/(y+1.0))
      ENDDO
c
c...Take LOG Of Various Things
c
      DO i=1,nk
        CALL xidrlog(prr0(i),prr0(i))
        CALL xidrlog(prm00(i),prm00(i))
        CALL xidrlog(prdiag(i),prdiag(i))
        CALL xidrlog(print(i),print(i))
        CALL intmag(print(i))
        CALL xidilog(prnin(i),prlnin(i))
        CALL xidilog(prnsat(i),prlnsat(i))
        x = prnsat(i)
        y = MAX(prnin(i),1)
        prpcnt(i) = 100.0*x/y
        IF (prpcnt(i).ge.45.0) THEN
          prerr(i) = IOR(prerr(i),PCNT_ERR)
        ENDIF
      ENDDO
c
c...Split According To Error
c
      CALL f_doenv('PIPROG:'//sname(1:nsname)//'.rok',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=1
     *     )
      lb(nlb-2:nlb) = 'rer'
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=2
     *     )
      DO i=1,nk
        IF (prerr(i).eq.0) THEN
          u = 1
        ELSE
          u = 2
        ENDIF
        c = kbmag(i)-krmag(i)
        IF (i.le.nfrompi) THEN
          source = 1
        ELSE
          source = 2
        ENDIF
        WRITE (u,9001) i,krmag(i),prmag(i),c,pramp(i),prsig(i),
     *                 prr0(i),prm00(i),prdiag(i),prrad(i),prlnin(i),
     *                 prlnsat(i),prpcnt(i),print(i),prerr(i),source,
     *                 field
      ENDDO
      CLOSE (1)
      CLOSE (2)
      RETURN
      END
