      SUBROUTINE  pfit(nn,xx,yy,ww,rr,in, nc,cc,sc,sigma)
c
c...Do The Least Squares Fit
c
      INCLUDE
     *            'parfit.inc'
      INTEGER
     *            nn, in(*), nc, i, j, k, ising, nin
      DOUBLE PRECISION
     *            xx(*), yy(*), rr(*), cc(*), sc(*), sigma, yc, yr,
     *            chisq, x, y, ww(*), w
c
 9001 FORMAT (' Fatal Error In PFIT')
c
c...Initialization
c
  100 DO j=1,nc
        cc(j) = 0.0D00
        zlhs(j) = 0.0D00
        DO i=1,nc
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
      nin = 0
c
c...Accumulation
c
      DO i=1,nn
        IF (in(i).ne.0) THEN
          x = xx(i)
          y = yy(i)
          w = ww(i)
          dv(1) = 1.0D00
          DO j=2,nc
            dv(j) = dv(j-1)*x
          ENDDO
          DO j=1,nc
            zlhs(j) = zlhs(j) + dv(j)*y*w
            DO k=1,nc
              zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)*w
            ENDDO
          ENDDO
          nin = nin+1
        ENDIF
      ENDDO
c
c...Inversion
c
      CALL matinv(nc,ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        CALL EXIT
      ENDIF
c
c...Coefficients
c
      DO i=1,nc
        DO j=1,nc
          cc(i) = cc(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiQsuared
c
      DO i=1,nn
        x = xx(i)
        y = yy(i)
        w = ww(i)
        dv(1) = 1.0D00
        DO j=2,nc
          dv(j) = dv(j-1)*x
        ENDDO
        yc = 0.0D00
        DO j=1,nc
          yc = yc + dv(j)*cc(j)
        ENDDO
        yr = y-yc
        IF (in(i).ne.0) THEN
          chisq = chisq + yr*yr*w
        ENDIF
        rr(i) = yr
      ENDDO
c
c...Errors
c
      i = MAX(1,nin-(nc+1))
      sigma = SQRT(chisq/i)
      DO i=1,nc
        sc(i) = sigma*zrhs(i,i)
      ENDDO
      RETURN
      END
