      SUBROUTINE  cdlook(fi,nfo,fo)
c
c...Look At CD-ROM LookUp Table
c
      INCLUDE
     *            'sdss.inc'
      PARAMETER
     *            nlook = 4
      CHARACTER*(*)
     *            fi, fo
      CHARACTER*6
     *            test, val
      CHARACTER*4
     *            dir
      CHARACTER*3
     *            look(NLOOK)
      CHARACTER*2
     *            color
      INTEGER
     *            nlb, nfo, ns, np, nfi, s, p, ilook, done
      CHARACTER*64
     *            lb
      DATA
     *   look/'uw0', 'uw1', 'ue0', 'ue1'/
c
 9001 FORMAT (2i5)
 9002 FORMAT (a, 1x, q, a)
 9003 FORMAT (' Did Not Find', 2(' >>', a, '<<'))
 9004 FORMAT (' Cannot Open P1CD.DIR')
 9005 FORMAT (' Cannot Open >>', a, '<<')
 9006 FORMAT ('/', a, '/xpmm/lists/', a)
c
c...Dumb Way
c
  100 nfi = LEN(fi)
      test = fi(nfi-10:nfi-5)
      color = fi(nfi-10:nfi-9)
      IF ((color.eq.'so').or.(color.eq.'se')) THEN
        dir = 'p1cd'
      ELSEIF ((color.eq.'uj').or.(color.eq.'sj')
     *    .or.(color.eq.'sf').or.(color.eq.'sn')) THEN
        dir = 'p2cd'
      ELSEIF ((color.eq.'sb').or.(color.eq.'sr')) THEN
        dir = 'sscd'
      ELSE
        STOP 'Illegal CD'
      ENDIF
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name='../../binary/cddir/'//dir//'.dir',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001) ns,np
      DO p=1,np
        DO s=1,ns
          READ (1,9002) val,nlb,lb
          IF (test.eq.val) GO TO 110
        ENDDO
      ENDDO
      nlb = 0
  110 CLOSE (1)
c
c...Last Gasp.  Look On Disk If Not Found On CD-ROM
c
      IF (nlb.gt.0) THEN
        done = 0
      ELSE
        DO ilook=1,NLOOK
          WRITE (lb,9006) look(ilook),fi
          nlb = 16+nfi
          OPEN (
     *          access='sequential',
     *          carriagecontrol='list',
     *          dispose='keep',
     *          err=120,
     *          form='formatted',
     *          name=lb(1:nlb),
     *          readonly,
     *          shared,
     *          status='old',
     *          unit=1
     *         )
          done = 1
          GO TO 130
  120   CONTINUE
        ENDDO
        nlb = -1
      ENDIF
c
c...Open Or Show Error
c
  130 IF (nlb.le.0) THEN
        WRITE (*,9003) fi,test
        nfo = -1
      ELSE
        nfo = nlb
        fo(1:nfo) = lb(1:nlb)
        IF (done.eq.0) THEN
          OPEN (
     *          access='sequential',
     *          carriagecontrol='list',
     *          dispose='keep',
     *          err=210,
     *          form='formatted',
     *          name=fo(1:nfo),
     *          readonly,
     *          shared,
     *          status='old',
     *          unit=1
     *         )
        done = 1
        ENDIF
      ENDIF
      RETURN
c
c...Errors
c
  200 WRITE (*,9004)
      nfo = -1
      RETURN
  210 WRITE (*,9005) fo(1:nfo)
      nfo = -2
      RETURN
      END
