      SUBROUTINE  p2read
c
c...Read POSSII.CAT
c
      INCLUDE
     *            'posstycho.inc'
      CHARACTER*132
     *            lb, qb
      CHARACTER*7
     *            cplate, cdate, cdec
      CHARACTER*6
     *            cra, cfilt
      CHARACTER*5
     *            ctype, cha, ctime
      CHARACTER*3
     *            mon, monlist(12)
      INTEGER
     *            nlb, nident, err, id, exp, mm, dd, yy, nqb,
     *            rah, ram, decd, decm, uthh, utmm, hah, ham,
     *            cyy, cdn, j
      DOUBLE PRECISION
     *            ra2000, dec2000, ra, dec, ut, ep, ras, decs, dist,
     *            mra, mdec, ha
      DATA
     *            monlist/'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN',
     *                    'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/
c
 9001 FORMAT (i6)
 9002 FORMAT (q, a)
 9003 FORMAT (i6, 3(1x,a), 1x,a, 1x,a, 2f10.0, 2(1x,a), 2x,i3,
     *        2x,a)
 9004 FORMAT (i2, a, i2)
 9005 FORMAT (2i2, f2.0)
 9006 FORMAT (i2, 1x, i2)
 9008 FORMAT (i1, 1x, i2, 1x)
c
c...Look In Catalog
c
  100 DO id=1,NP2
        p1ra(id) = TAG
        p1dec(id) = TAG
        p1djm(id) = TAG
        p1ut(id) = TAG
        p1ha(id) = TAG
      ENDDO
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/possii.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002)
c
c...Read Each Line
c
  110 READ (1,9002,end=130) nlb,lb
      IF (color.eq.'SJ') THEN
        IF (lb(69:69).ne.'J') GO TO 110
      ELSEIF (color.eq.'UJ') THEN
        IF (lb(8:8).ne.'U') GO TO 110
      ELSEIF (color.eq.'SF') THEN
        IF (lb(69:69).ne.'F') GO TO 110
      ELSEIF (color.eq.'SN') THEN
        IF (lb(9:9).ne.'N') GOT O 110
      ENDIF
      READ (lb(1:nlb),9003) id,cplate,cdate,ctime,cra,cdec,
     *                      ra2000,dec2000,ctype,cfilt,exp,cha
      READ (cdate,9004) dd,mon,yy
      yy = yy+1900
c
c...Parse Catalog Entry
c
      DO mm=1,12
        IF (monlist(mm).eq.mon) GO TO 120
      ENDDO
  120 READ (cra,9005) rah,ram,ras
      CALL sla_DTF2R(rah,ram,ras, ra,j)
      IF (j.ne.0) GO TO 200
      READ (cdec(2:7),9005) decd,decm,decs
      CALL sla_DAF2R(decd,decm,decs, dec,j)
      IF (j.ne.0) GO TO 200
      IF (INDEX(cdec,'-').gt.0) THEN
        dec = -dec
      ENDIF
      READ (ctime,9006) uthh,utmm
      ut = uthh + utmm/60.0D00 + exp/120.0D00
c
c...Precess To J2000 And Copy Into Common
c
      CALL sla_CALDJ(yy,mm,dd, p1djm(id),j)
      IF (j.ne.0) GO TO 200
      CALL sla_CALYD(yy,mm,dd, cyy,cdn,j)
      IF (j.ne.0) GO TO 200
      IF (MOD(yy,4).eq.0) THEN
        ep = cyy + (cdn + ut/24.0D00 - 1)/366.0D00
      ELSE
        ep = cyy + (cdn + ut/24.0D00 - 1)/365.0D00
      ENDIF
      p1ra(id) = ra
      p1dec(id) = dec
      CALL sla_PRECES('FK5',ep,2000.0D00,p1ra(id),p1dec(id))
      p1ut(id) = ut
      READ (cha,9008) hah,ham
      ha = hah + ham/60.0D00
      IF (cha(5:5).eq.'E') THEN
        ha = -ha
      ENDIF
      p1ha(id) = ha*15.0D00/radian
      GO TO 110
  130 CLOSE (1)
      RETURN
c
c...Errors
c
  200 STOP 'SSREAD SLA Error'
      END
