      SUBROUTINE  eatit(r1,r2,dz,d1,d2)
c
c...Ingest ACC And Loop Over DAT
c
      INCLUDE
     *            'uafirst.inc'
      INTEGER
     *            dz, i, i1, i2, fr, nr, C_ROOPEN, fd, nlb, err,
     *            C_POSITION, n, nmost, nlast, jr1, jr2, jd1, jd2,
     *            C_CLOSER, C_READER, m, j
      DOUBLE PRECISION
     *            r1, r2, d1, d2
      CHARACTER*64
     *            lb
      BYTE
     *            bb(65)
c
 9001 FORMAT ('/uv6/xpmm/zone/zone', i4.4, '.acc')
 9002 FORMAT (5x, 2i12)
 9003 FORMAT (' Cannot Open ', a)
 9004 FORMAT (' Fatal Error Accessing ', a)
 9005 FORMAT (' Too Many Stars - Quitting Early')
c
c...Eat The ACC File
c
  100 IF (dz.ne.oldzone) THEN
        WRITE (lb,9001) dz
        nlb = 27
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=200,
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        DO i=1,NACC
          READ (1,9002) frec(i),nrec(i)
        ENDDO
        CLOSE (1)
        oldzone = dz
      ENDIF
c
c...Compute Offset And Length
c
      i1 = r1/3.75D00
      i1 = MAX(1,MIN(NACC,i1+1))
      i2 = r2/3.75D00
      i2 = MAX(1,MIN(NACC,i2+1))
      fr = frec(i1)-1
      nr = 0
      DO i=i1,i2
        nr = nr+nrec(i)
      ENDDO
c
c...Open And Position File
c
      lb(nlb-2:nlb) = 'cat'
      DO i=1,nlb
        bb(i) = ICHAR(lb(i:i))
      ENDDO
      bb(nlb+1) = 0
      fd = C_ROOPEN(bb)
      IF (fd.lt.3) THEN
        WRITE (*,9003) lb(1:nlb)
        CALL EXIT
      ENDIF
      IF (fr.gt.0) THEN
        err = C_POSITION(fd,12*fr)
        IF (err.le.0) THEN
          WRITE (*,9004) lb(1:nlb)
          CALL EXIT
        ENDIF
      ENDIF
c
c...Set Up Search Parameters
c
      n = ((nr-1)/NCHUNK) + 1
      IF (n.gt.1) THEN
        nmost = NCHUNK
        nlast = nr - (n-1)*NCHUNK
      ELSE
        nmost = 0
        nlast = nr
      ENDIF
      jr1 = CONVERT*r1
      jr2 = CONVERT*r2
      jd1 = CONVERT*(d1+90.0D00)
      jd2 = CONVERT*(d2+90.0D00)
c
c...Do The Search
c
      DO i=1,n
        IF (i.eq.n) THEN
          m = nlast
        ELSE
          m = nmost
        ENDIF
        err = C_READER(fd,buf,12*m)
        IF (err.ne.0) THEN
          WRITE (*,9004) lb(1:nlb)
          CALL EXIT
        ENDIF
        DO j=1,m
          IF (buf(1,j).ge.jr1) THEN
            IF (buf(1,j).le.jr2) THEN
              IF ((buf(2,j).ge.jd1).and.(buf(2,j).le.jd2)) THEN
                nsav = nsav+1
                sav(nsav,1) = buf(1,j)
                sav(nsav,2) = buf(2,j)
                sav(nsav,3) = buf(3,j)
                sav(nsav,4) = oldzone
                sav(nsav,5) = fr+j
                IF (nsav.ge.NSAVMAX) THEN
                  WRITE (*,9005)
                  GO TO 110
                ENDIF
              ENDIF
            ELSE
              GO TO 110
            ENDIF
          ENDIF
        ENDDO
        fr = fr+m
      ENDDO
  110 err = C_CLOSER(fd)
      RETURN
c
c...You Better Not Get Here
c
  200 WRITE (*,9003) lb(1:nlb)
      CALL EXIT
      END
