      SUBROUTINE  plproc_4(npl,plx,ply)
c
c...Look At The List Of Pixels And Process Them
c
      INCLUDE
     *            '../all4.inc'
      PARAMETER
     *            zpmin = 5.0,
     *            tooclose = 2.5
      INTEGER
     *            npl, plx(*), ply(*), imax, x0, y0,
     *            npeak, i, x, y, ipeak(PLMAX), m, nkeep, n, j,
     *            idx(PLMAX), tmp(PLMAX)
      REAL
     *            test, z, zmax, zpeak(PLMAX), q, dx, dy
c
  100 npeak = 0
      nblob = nblob+1
c
c...Find All Pixels As Bright As Their Neighbors Or Brighter
c
      DO i=1,npl
        x = plx(i)
        y = ply(i)
        z = data(x,y)
        zmax = MAX(data(x-1,y-1),data(x  ,y-1),data(x+1,y-1),
     *             data(x-1,y  ),              data(x+1,y  ),
     *             data(x-1,y+1),data(x  ,y+1),data(x+1,y+1))
        IF (z.ge.zmax) THEN
          npeak = npeak+1
          IF (npeak.le.PLMAX) THEN
            zpeak(npeak) = z
            ipeak(npeak) = i
          ENDIF
        ENDIF
      ENDDO
c
c...No Peaks Found.  But FIND Saw Something So Just Choose The Brightest Pixel.
c
      IF (npeak.le.0) THEN
        imax = 1
        zmax = data(plx(1),ply(1))
        DO i=2,npl
          z = data(plx(i),ply(i))
          IF (z.gt.zmax) THEN
            imax = i
            zmax = z
          ENDIF
        ENDDO
        CALL pllog_4(plx(imax),ply(imax),npl,1,npeak)
        RETURN
      ENDIF
c
c...Use NPL As A Test To Keep From Finding Too Many Peaks
c
      i = npl/parmagnify
      IF (i.lt.9) THEN
        nkeep = 1 + (i/3)
      ELSE
        z = i
        nkeep = SQRT(z) + 0.001
      ENDIF
c
c...Log The Brightest Peak
c
      imax = 1
      zmax = zpeak(imax)
      m = npl/nkeep
      DO i=1,npeak
        IF (zpeak(i).gt.zmax) THEN
          zmax = zpeak(i)
          imax = i
        ENDIF
      ENDDO
      x0 = plx(ipeak(imax))
      y0 = ply(ipeak(imax))
      CALL pllog_4(x0,y0,m,1,npeak)
      DO i=imax+1,npeak
        ipeak(i-1) = ipeak(i)
        zpeak(i-1) = zpeak(i)
      ENDDO
      npeak = npeak-1
      nkeep = nkeep-1
c
c...Remove Multiple Detections Of Saturated Images.  Algorithm Is To Go
c	From Brightest To Peak.  If All Pixels Are Saturated, Then This
c	Is The Same Blob.
c
      test = frdn2(nframe)
      IF (zmax.ge.test) THEN
        DO i=1,npeak
          IF (zpeak(i).ge.test) THEN
            dx = plx(ipeak(i)) - x0
            dy = ply(ipeak(i)) - y0
            n = MAX(ABS(dx),ABS(dy))
            IF (n.gt.1) THEN
              dx = dx/n
              dy = dy/n
            ENDIF
            DO j=1,n-1
              x = x0 + j*dx
              y = y0 + j*dy
              IF (data(x,y).lt.test) GO TO 110
            ENDDO
            ipeak(i) = -1
  110       CONTINUE
          ENDIF
        ENDDO
        j = 0
        DO i=1,npeak
          IF (ipeak(i).gt.0) THEN
            j = j+1
            ipeak(j) = ipeak(i)
            zpeak(j) = zpeak(i)
          ENDIF
        ENDDO
        npeak = j
        IF (npeak.le.0) RETURN
      ENDIF
c
c...Compute A Quality Index.
c
c	Contrast Between This Pixel And Those A Little Ways Away.
c	(Ignore if contrast is too low)
c
      n = 0
      DO i=1,npeak
        x = plx(ipeak(i))
        y = ply(ipeak(i))
        z = data(x+4,y) + data(x+3,y+3) + data(x,y+4) + data(x-3,y+3)
     *    + data(x-4,y) + data(x-3,y-3) + data(x,y-4) + data(x+3,y-3)
        z = zpeak(i) - 0.125*z
        IF (z.ge.ZPMIN) THEN
          n = n+1
          idx(n) = n
          ipeak(n) = ipeak(i)
          zpeak(n) = z
        ENDIF
      ENDDO
      npeak = n
      IF (npeak.gt.1) THEN
        CALL fdqsrt(npeak,zpeak,idx)
        DO i=1,npeak
          tmp(i) = ipeak(i)
        ENDDO
        DO i=1,npeak
          ipeak(i) = tmp(idx(i))
        ENDDO
      ENDIF
c
c...List Is Now Sorted On Quality.  Choose By Quantity And Proximity
c
      n = 0
      DO i=1,npeak
        IF (ipeak(i).gt.0) THEN
          n = n+1
          x = plx(ipeak(i))
          y = ply(ipeak(i))
          CALL pllog_4(x,y,m,n+1,nkeep+1)
          DO j=i+1,npeak
            dx = plx(ipeak(j))-x
            dy = ply(ipeak(j))-y
            IF ((dx*dx+dy*dy).le.TOOCLOSE) THEN
              ipeak(j) = 0
            ENDIF
          ENDDO
          IF (n.ge.nkeep) GO TO 120
        ENDIF
      ENDDO
  120 CONTINUE
c
c...All Done
c
      RETURN
      END
