      INTEGER FUNCTION dev_camopen
c
c...Open New 61-inch Compumotor Camera Channel
c
      INCLUDE
     *           'devices.inc'
      INCLUDE
     *           '($SSDEF)'
      CHARACTER*8
     *           camname
      INTEGER*4
     *           ret, SYS$TRNLOG, SYS$ASSIGN, SYS$SETEF,
     *           ncamname
c
  100 ret=SYS$TRNLOG(
     1               'CAM$DEV',
     2               ncamname,
     3               camname,
     4              ,
     5              ,
     6
     *              )
      ret=SYS$ASSIGN(
     1               camname(1:ncamname),
     2               cam_chan,
     3              ,
     4
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_camopen = -1
        RETURN
      ENDIF
      cam_efn = 46
      ret = SYS$SETEF(%VAL(cam_efn))
      cam_iosb(1) = SS$_NORMAL
      dev_camopen = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_camclose
c
c...Return Compumotor Camera Channel
c
      INCLUDE
     *           'devices.inc'
      INTEGER*4
     *           ret, SYS$DASSGN
c
  100 ret = SYS$DASSGN(
     1                 %VAL(cam_chan)
     *                )
      cam_chan = 0
      cam_efn = 0
      dev_camclose = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_camread(buf, n)
c
c...Read String If There Is Anything
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      BYTE
     *              buf(*)
      INTEGER*4
     *              ret, SYS$QIOW, n, i
c
c...Read Or TimeOut
c
  100 ret = SYS$QIOW(
     1              %VAL(cam_efn),
     2              %VAL(cam_chan),
     3              %VAL(IO$_READVBLK+IO$M_TIMED),
     4              cam_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9              %VAL(3),
     A             ,
     B             ,
     C
     *             )
      IF  ((ret.ne.SS$_NORMAL).or.(cam_iosb(1).ne.SS$_NORMAL)) THEN
        dev_camread = -1
        RETURN
      ENDIF
      cam_iosb(2) = cam_iosb(2) + 1
      buf(cam_iosb(2)) = 13
      buf(cam_iosb(2)+1) = 0
      dev_camread = cam_iosb(2)
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_camwrite(buf, n)
c
c...Write String
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      INTEGER*4
     *              ret, SYS$QIOW, n, i
      BYTE
     *              buf(*), dummy
c
c...Flush The TypeAhead Buffer
c
  100 ret = SYS$QIOW(
     1              %VAL(cam_efn),
     2              %VAL(cam_chan),
     3              %VAL(IO$_READVBLK+IO$M_PURGE),
     4              cam_iosb,
     5             ,
     6             ,
     7              dummy,
     8              %VAL(0),
     9             ,
     A             ,
     B             ,
     C
     *             )
c
c...Write Our Message
c
      ret = SYS$QIOW(
     1              %VAL(cam_efn),
     2              %VAL(cam_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              cam_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_camwrite = -1
        RETURN
      ENDIF
      dev_camwrite = n
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_cambar(buf, n)
c
c...Read BarCode String
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      BYTE
     *              buf(*)
      INTEGER*4
     *              ret, SYS$QIOW, i, j, m, n
      INTEGER*2
     *              cambuf(4)
c
c...Sense The Number Of Characters Waiting
c
  100 ret = SYS$QIOW(
     1              %VAL(cam_efn),
     2              %VAL(cam_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              cam_iosb,
     5             ,
     6             ,
     7              cambuf,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_cambar = -1
        RETURN
      ENDIF
      IF (cambuf(1).le.0) THEN
        dev_cambar = 0
        RETURN
      ENDIF
c
c...Read The Message.  Barcode reader inserts CR/NL
c
      ret = SYS$QIOW(
     1              %VAL(cam_efn),
     2              %VAL(cam_chan),
     3              %VAL(IO$_TTYREADALL+IO$M_TIMED),
     4              cam_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9              %VAL(3),
     A             ,
     B             ,
     C
     *             )
      IF ((ret.ne.SS$_NORMAL).or.(cam_iosb(1).ne.SS$_NORMAL)) THEN
        dev_cambar = -2
        RETURN
      ENDIF
c
c...Make True ASCII And Strip Out CR/NL, etc.
c
      m = 0
      DO i=1,cam_iosb(2)
        j = buf(i)
        j = IAND(j,127)
        IF ((j.gt.32).and.(j.lt.127)) THEN
          m = m+1
          buf(m) = j
        ENDIF
      ENDDO
      dev_cambar = m
      RETURN
      END
