      SUBROUTINE  cc_fast1ae(err)
c
c...AutoExposure For Finding Density Range For Normal Exposures
c
c	Uses F_DNEXP On SGx
c
      INCLUDE
     *            'c.inc'
      INCLUDE
     *            'nd.inc'
      PARAMETER
     *            exp_min = 30,
     *            exp_max = 110,
     *            nitmax = 4,
     *            nd_step = 0.499,
     *            nd_nudge = 0.2
      INTEGER
     *            err, e, emin, emax, n
      REAL
     *            d, dmin, dmax
c
 9001 FORMAT (i5)
 9002 FORMAT (' 0)   Den=', f4.2, '   Exp=', i3)
 9003 FORMAT (' 0)   DMin=', f4.2, '   DMax=', f4.2 /)
c
c...Go To Maximum Density.  Hard Error If Too Short (Bright).
c
  100 d = ND_MAX
      CALL cc_cmdensity(1,0,d)
      nlb = 7
      lb(1:nlb) = '1=DNEXP'
      CALL cc_sg1talk(err)
      IF (err.ne.0) RETURN
      READ (lb(1:nlb),9001,err=200) e
      WRITE (*,9002) d,e
      IF (e.lt.EXP_MIN) THEN
        dmin = d
        dmax = d
        err = -88
        GO TO 130
      ENDIF
c
c...If Too Faint, Decrement Density
c
      IF (e.gt.EXP_MAX) THEN
  105   dmax = d
        emax = e
        d = d - ND_STEP
        IF (d.lt.ND_MIN) THEN
          dmin = dmax
          err = 88
          GO TO 130
        ENDIF
        CALL cc_cmdensity(1,0,d)
        nlb = 7
        lb(1:nlb) = '1=DNEXP'
        CALL cc_sg1talk(err)
        IF (err.ne.0) RETURN
        READ (lb(1:nlb),9001,err=200) e
        WRITE (*,9002) d,e
        IF (e.gt.EXP_MAX) GO TO 105
c
c...Iterate If Too Short (Bright) Until An Acceptable Exposure Is Found
c
        IF (e.lt.EXP_MIN) THEN
          dmin = d
          emin = e
          n = 0
  110     d = (dmin+dmax)/2.0
          CALL cc_cmdensity(1,0,d)
          nlb = 7
          lb(1:nlb) = '1=DNEXP'
          CALL cc_sg1talk(err)
          IF (err.ne.0) RETURN
          READ (lb(1:nlb),9001,err=200) e
          WRITE (*,9002) d,e
          IF (e.lt.EXP_MIN) THEN
            dmin = d
            emin = e
            n = n+1
            IF (n.le.NITMAX) GO TO 110
            err = 89
            GO TO 130
          ELSEIF (e.gt.EXP_MAX) THEN
            dmax = d
            emax = e
            n = n+1
            IF (n.le.NITMAX) GO TO 110
            err = 89
            GO TO 130
          ENDIF
        ENDIF
      ENDIF
c
c...Value Of D Yields EXP_MIN <= E <= EXP_MAX
c
  120 dmax = d + ALOG10(REAL(EXP_MAX)/REAL(e))
      dmax = MAX(ND_MIN,MIN(ND_MAX,dmax))
      dmin = d + ALOG10(REAL(EXP_MIN)/REAL(e))
      dmin = MAX(ND_MIN,MIN(ND_MAX,dmin))
      err = 0
c
c...Common Exit
c
  130 den_1d(1) = dmin
      den_1d(2) = dmax
      den_1n = 2
      WRITE (*,9003) dmin,dmax
      RETURN
c
c...Real Problem
c
  200 err = -99
      RETURN
      END
