      SUBROUTINE  cc_recal(err)
c
c...Delete Or Read The calib.0/calib.1 Files That Define The Z Laser Encoders
c
c	NOTE:  Enter Absoulte Z Zero Point As LAST+1 Entry
      INCLUDE
     *            'c.inc'
      PARAMETER
     *            dztol = 0.015D00
      DOUBLE PRECISION
     *            z0, z1, v0, v1, zref, z
      INTEGER
     *            err
      CHARACTER*1
     *            op
c
 9001 FORMAT (17x, 2(1x, f8.4), 10x, f8.4)
 9002 FORMAT (/ ' RECAL Cannot Load CALIB.x' /)
c
c...Initialize
c
  100 nz01 = 0
      op = lb(6:6)
c
c...OP=='0' Means Delete Previous Calibration
c
      IF (op.eq.'0') THEN
  110   OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='delete',
     *        err=120,
     *        form='formatted',
     *        name='calib.0',
     *        status='old',
     *        unit=88
     *       )
        CLOSE (88,dispose='delete')
        GO TO 110
  120   OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='delete',
     *        err=130,
     *        form='formatted',
     *        name='calib.1',
     *        status='old',
     *        unit=88
     *     )
        CLOSE (88,dispose='delete')
        GO TO 120
  130   err = 0
c
c...OP=='1' Reloads Calibration
c
      ELSEIF (op.eq.'1') THEN
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=200,
     *        form='formatted',
     *        name='calib.0',
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=88
     *       )
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=210,
     *        form='formatted',
     *        name='calib.1',
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=89
     *     )
  140   READ (88,9001,err=220,end=150) z0,v0,z
        READ (89,9001,err=220,end=220) z1,v1
        IF (ABS(z1-z0).gt.DZTOL) GO TO 220
        nz01 = nz01+1
        z01ref(nz01) = 0.5D00*(z0+z1)
        z0cal(nz01) = v0
        z1cal(nz01) = v1
        IF (nz01.eq.1) THEN
          zref = z - z01ref(nz01)
        ENDIF
        IF (nz01.lt.NZ01MAX) GO TO 140
  150   CLOSE (88)
        CLOSE (89)
        IF (nz01.lt.NZ01MAX) THEN
          z01ref(nz01+1) = zref
        ELSE
          nz01 = nz01-1
          z01ref(nz01+1) = zref
        ENDIF
        err = 0
c
c...Unknown Call
c
      ELSE
        err = -1
      ENDIF
      RETURN
c
c...Error Exits
c
  200 err = -2
      WRITE (*,9002)
      RETURN
  210 CLOSE (88)
      WRITE (*,9002)
      err = -3
      RETURN
  220 CLOSE (88)
      CLOSE (89)
      WRITE (*,9002)
      err = -4
      RETURN
      END
