c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pjopen
c
c...PJA0 Is DT2762 A/D
c
      INCLUDE
     *           'devices.inc'
      INCLUDE
     *           '($SSDEF)'
      INTEGER*4
     *           ret, SYS$ASSIGN, SYS$SETEF
c
  100 ret=SYS$ASSIGN(
     1               'PJA0',
     2               pj_chan,
     3              ,
     4
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_pjopen = 1
        RETURN
      ENDIF
      pj_efn = 47
      ret = SYS$SETEF(%VAL(pj_efn))
      pj_iosb(1) = SS$_NORMAL
      dev_pjopen = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pjclose
c
c...Return PJA0 Channel
c
      INCLUDE
     *           'devices.inc'
      INTEGER*4
     *           ret, SYS$DASSGN
c
  100 ret = SYS$DASSGN(
     1                 %VAL(pj_chan)
     *                )
      pj_chan = 0
      pj_efn = 0
      dev_pjclose = 0
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pjread(buf,channel,gain,nsample)
c
c...Read Samples
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            ret, SYS$QIOW
      INTEGER
     *            nbytes, channel, gain, nsample
      BYTE
     *            buf(*)
c
  100 ret = SYS$QIOW(
     1               %VAL(pj_efn),
     2               %VAL(pj_chan),
     3               %VAL(IO$_READVBLK),
     4               pj_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(channel),
     9               %VAL(gain),
     A               %VAL(nsample),
     B             ,
     C
     *             )
      IF (ret.eq.SS$_NORMAL) THEN
        dev_pjread = 0
      ELSE
        dev_pjread = ret
      ENDIF
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION  dev_pjvolt(channel,gain,volt)
c
c...Return The Voltage
c
      INCLUDE
     *            'devices.inc'
      INTEGER
     *            err, DEV_PJREAD, channel, gain, c, g
      INTEGER*2
     *            buf
      REAL
     *            volt, fullscale(0:3)
      DATA
     *            fullscale/10.0, 5.0, 2.5, 1.25/
c
  100 c = IAND(channel,15)
      g = IAND(gain,3)
      err = DEV_PJREAD(buf,c,g,1)
      IF (err.eq.0) THEN
        volt = buf*fullscale(g)/4095.0
      ELSE
        volt = -1.0
      ENDIF
      dev_pjvolt = err
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION  dev_pjtovolt(buf,gain,nsample,volt)
c
c...Convert DN To Volts For Multiple Sample Request
c
      INCLUDE
     *              'devices.inc'
      INTEGER*2
     *              buf(*)
      INTEGER
     *              gain, nsample, g, i
      REAL
     *              volt(*), fullscale(0:3)
      DATA
     *              fullscale/10.0, 5.0, 2.5, 1.25/
c
  100 g = IAND(gain,3)
      DO i=1,nsample
        volt(i) = buf(i)*fullscale(g)/4095.0
      ENDDO
      dev_pjtovolt = 0
      RETURN
      END
