      INTEGER FUNCTION dev_pkopen
c
c...Called Once To Initialize Things
c
      INCLUDE
     *         'devices.inc'
      INCLUDE
     *         '($SSDEF)'
      INCLUDE
     *         '($SECDEF)'
      INTEGER*4
     *         SYS$CRMPSC, SYS$ASSIGN, SYS$QIOW, SYS$SETEF,
     *         ret, mask(2), npage, nvbn
c
c...Allocate Device
c
c	WARNING -- Do Not Test For Error Because Inter-VAX Communication
c		Needs The Device Open By Everybody.   This Is No Problem
c		Because All Communication Is Done In Mapped Memory Not
c		Device Driver.
c
  100 ret = SYS$ASSIGN(
     1                 'PKA0:',
     2                 pk_chan,
     3                ,
     4
     *                )
c
c...Create And Map 22-bit Q-Bus For Mapped Data Arrays
c
      pkm_in(1) = %LOC(pk_all(1))
      pkm_in(2) = pkm_in(1) + 2047
      npage = (pkm_in(2)+1-pkm_in(1))/512
      nvbn = (dec_mbase + pkm_addr)/512
      ret = SYS$CRMPSC(
     1                 pkm_in,
     2                 pkm_out,
     3                ,
     4                 %VAL(SEC$M_PFNMAP+SEC$M_WRT),
     5                ,
     6                ,
     7                ,
     8                 %VAL(0),
     9                 %VAL(npage),
     A                 %VAL(nvbn),
     B                ,
     C
     *                )
      IF ((ret.ne.SS$_NORMAL).and.(ret.ne.SS$_CREATED)) THEN
        dev_pkopen = -2
        RETURN
      ENDIF
      IF ((pkm_in(1).ne.pkm_out(1))
     *.or.(pkm_in(2).ne.pkm_out(2))) THEN
        STOP 'PKA0 Memory Is Not Page Aligned'
      ENDIF
c
c...Create And Map 22-bit Q-Bus For Mapped IO Register Page
c
      pkc_in(1) = %LOC(pkc_page(1))
      pkc_in(2) = pkc_in(1) + 511
      npage = 1
      nvbn = (dec_cbase + pkc_addr)/512
      ret = SYS$CRMPSC(
     1                 pkc_in,
     2                 pkc_out,
     3                ,
     4                 %VAL(SEC$M_PFNMAP+SEC$M_WRT),
     5                ,
     6                ,
     7                ,
     8                 %VAL(0),
     9                 %VAL(npage),
     A                 %VAL(nvbn),
     B                ,
     C
     *                )
      IF ((ret.ne.SS$_NORMAL).and.(ret.ne.SS$_CREATED)) THEN
        dev_pkopen = -3
        RETURN
      ENDIF
      IF ((pkc_in(1).ne.pkc_out(1))
     *.or.(pkc_in(2).ne.pkc_out(2))) THEN
        STOP 'PKA0 CSRs Are Not Page Aligned'
      ENDIF
c
c...That's All
c
      pk_efn = 32
      ret = SYS$SETEF(%VAL(pk_efn))
      pk_iosb(1) = SS$_NORMAL
      dev_pkopen = 0
      RETURN
      END
c
c-------------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pkclose
c
c...Give Everything Back
c
c	Don't Bother With Error Checking
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            ret, SYS$DASSGN, SYS$DELTVA
c
  100 ret = SYS$DELTVA(
     1                 pkc_out
     *                )
      ret = SYS$DELTVA(
     1                 pkm_out
     *                )
      ret = SYS$DASSGN(
     1                 %VAL(pk_chan)
     *                )
      pk_efn = 0
      pk_chan = 0
      dev_pkclose = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pkclear
c
c...Clear (i.e. Set To Space) Entire Buffer
c
      INCLUDE
     *            'devices.inc'
      INTEGER
     *            i
c
  100 DO i=1,1024
        pk_all(i) = 32
      ENDDO
      dev_pkclear = 0
      RETURN
      END
c
c------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pkwrite(buf,n)
c
c...Write A String In Normal Video
c
      INCLUDE
     *            'devices.inc'
      BYTE
     *            buf(*)
      INTEGER
     *            n
      INTEGER
     *            ix, iy, iz, i1, i2, i, j
c
  100 iz = ZEXT(buf(1)) - ICHAR('0')
      iy = ZEXT(buf(2)) - 32
      ix = ZEXT(buf(3)) - 32
      IF (n.le.1024) THEN
        i1 = iy*64 + ix + 1
        i2 = i1 + n - 4
      ELSE
        i1 = 1025
        i2 = n
      ENDIF
      IF ((i1.lt.1).or.(i1.gt.2048)) THEN
        dev_pkwrite = -1
        RETURN
      ENDIF
      IF ((i2.lt.1).or.(i2.gt.2048)) THEN
        dev_pkwrite = -2
        RETURN
      ENDIF
      IF (i1.le.1024) THEN
        i2 = MIN(i2,1024)
      ENDIF
c
c...Do It
c
      j = 3
      IF (iz.eq.0) THEN
        DO i=i1,i2
          j = j+1
          pk_all(i) = IAND(127,ZEXT(buf(j)))
        ENDDO
      ELSE
        DO i=i1,i2
          j = j+1
          pk_all(i) = IAND(127,ZEXT(buf(j))) - 128
        ENDDO
      ENDIF
      dev_pkwrite = 0
      RETURN
      END
c
c------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pkrscr(buf,n)
c
c...Read Screen
c
c	5 Jun 89 Modified To Remove The Reverse Video Attribute Bit
c
      INCLUDE
     *            'devices.inc'
      BYTE
     *            buf(*)
      INTEGER
     *            n
      INTEGER
     *            i, i1
c
  100 i1 = MAX(0,MIN(1024,n))
      DO i=1,i1
        IF (pk_all(i).ge.0) THEN
          buf(i) = pk_all(i)
        ELSE
          buf(i) = pk_all(i) + 128
        ENDIF
      ENDDO
      dev_pkrscr = i1
      RETURN
      END
c
c------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pkrmes(buf,n)
c
c...Read Message Buffer
c
      INCLUDE
     *            'devices.inc'
      BYTE
     *            buf(*)
      INTEGER
     *            n
      INTEGER
     *            i, i1
c
  100 i1 = MAX(0,MIN(1024,ZEXT(pk_all(1025)),n))
      DO i=1,i1
        buf(i) = pk_all(i+1024)
      ENDDO
      dev_pkrmes = i1
      pk_all(1025) = 0
      RETURN
      END
c
c------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pkqmes(n)
c
c...Return Number Of Message Characters Waiting
c
      INCLUDE
     *            'devices.inc'
      INTEGER
     *            n
c
  100 n = MAX(0,MIN(1024,ZEXT(pk_all(1025))))
      dev_pkqmes = 0
      RETURN
      END
c
c------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pknorm(ix,iy,buf)
c
c...Write A String In Normal Video
c
      INCLUDE
     *            'devices.inc'
      CHARACTER*(*)
     *            buf
      INTEGER
     *            ix, iy, i1, i2, i, j
c
  100 i1 = MAX(1,MIN(2048, (iy-1)*64 + ix))
      i2 = MAX(1,MIN(2048, i1+LEN(buf)-1))
      IF (i2.ge.i1) THEN
        j = 0
        DO i=i1,i2
          j = j+1
          pk_all(i) = ICHAR(buf(j:j))
        ENDDO
      ENDIF
      dev_pknorm = 0
      RETURN
      END
c
c------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pkrev(ix,iy,buf)
c
c...Write A String In Reverse Video
c
      INCLUDE
     *            'devices.inc'
      CHARACTER*(*)
     *            buf
      INTEGER
     *            ix, iy, i1, i2, i, j
c
  100 i1 = MAX(1,MIN(2048, (iy-1)*64 + ix))
      i2 = MAX(1,MIN(2048, i1+LEN(buf)-1))
      IF (i2.ge.i1) THEN
        j = 0
        DO i=i1,i2
          j = j+1
          pk_all(i) = ICHAR(buf(j:j)) - 128
        ENDDO
      ENDIF
      dev_pkrev = 0
      RETURN
      END
