c
c---------------------------------------------------------------------------
c
      SUBROUTINE  py_open(iclear, iext, inv, ivideo)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            iclear, iext, inv, ivideo
c
  100 CALL py_1reset
      IF (iclear.ne.0) THEN
        CALL py_1clear
      ENDIF
      CALL py_lutload('0')
      CALL py_setinv(inv)
      CALL py_vidsel(ivideo)
      CALL py_exttim(iext)
      RETURN
      END
c
c------------------------------------------------------------------------
c
      SUBROUTINE  py_close
c
      INCLUDE
     *            'devices.inc'
c
      CALL py_pass(0)
      CALL py_mode(0)
      CALL py_ilsel(0)
      CALL py_olsel(0)
      CALL py_bufsel(0,0)
      CALL py_vidsel(0)
      CALL py_exttim(0)
      CALL py_display(1)
      RETURN
      END
c
c-------------------------------------------------------------------------------
c
      SUBROUTINE  py_field
c
c...Wait For Even Field
c
      INCLUDE
     *            'devices.inc'
      INTEGER*2
     *            i, mask
      DATA
     *            mask/'2000'x/
c
  100 i = pyc_outcsr
      IF (IAND(i,mask).ne.0) GO TO 100
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  py_1reset
c
      INCLUDE
     *            'devices.inc'
      INTEGER*2
     *          mask1, mask2, zero
      DATA
     *          mask1/'0100000'o/,
     *          mask2/'0000200'o/,
     *          zero /'0000000'o/
c
      pyc_incsr1 = mask1
      CALL py_wait
      pyc_incsr1 = zero
      pyc_incsr2 = zero
      pyc_outcsr = mask2
      CALL py_1int(0)
      CALL py_picsel(0)
      CALL py_curmode(0)
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      SUBROUTINE  py_picsel(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg
      INTEGER*2
     *            i, mask1, mask2
      DATA
     *            mask1/'0177757'o/,
     *            mask2/'0000020'o/
c
  100 i = pyc_outcsr
      IF (IAND(arg,1).eq.0) THEN
        i = IAND(i, mask1)
      ELSE
        i = IOR(i, mask2)
      ENDIF
      pyc_outcsr = i
      RETURN
      END
c
c------------------------------------------------------------------------
c
      SUBROUTINE  py_1int(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg, mask2
      INTEGER*2
     *            i, j, mask1
      DATA
     *            mask1/'0177677'o/,
     *            mask2/'0000100'o/
c
      i = pyc_incsr1
      i = IAND(i, mask1)
      j = IAND(ISHFT(arg,6), mask2)
      pyc_incsr1 = IOR(i,j)
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      SUBROUTINE  py_ilsel(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *           arg, mask2
      INTEGER*2
     *           i, j, mask1
      DATA
     *           mask1/'0177770'o/,
     *           mask2/'0000007'o/
c
      i = pyc_incsr1
      i = IAND(i, mask1)
      j = IAND(arg,mask2)
      pyc_incsr1 = IOR(i,j)
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  py_olsel(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg, mask2
      INTEGER*2
     *            i, j, mask1
      DATA
     *            mask1/'0177770'o/,
     *            mask2/'0000007'o/
c
      i = pyc_outcsr
      i = IAND(i, mask1)
      j = IAND(arg, mask2)
      pyc_outcsr = IOR(i,j)
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  py_wcur(x,y)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            x, y
      INTEGER*2
     *            i, j, mask1, mask2
      DATA
     *            mask1/'0177400'o/,
     *            mask2/'0000377'o/
c
      i = y
      i = IAND(ISHFT(i, 7), mask1)
      j = x
      j = IAND(ISHFT(j,-1), mask2)
      pyc_cursor = IOR(i,j)
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      SUBROUTINE  py_rcur(x,y)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            x, y, i, mask
      DATA
     *            mask/'0776'o/
     
c
      i = pyc_cursor
      y = IAND(ISHFT(i,-7), mask)
      x = IAND(ISHFT(i, 1), mask)
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      SUBROUTINE  py_curmode(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg
      INTEGER*2
     *            i, mask1, mask2
      DATA
     *            mask1/'0177677'o/,
     *            mask2/'0000100'o/
c
      i = pyc_outcsr
      IF (IAND(arg,1).eq.0) THEN
        i = IAND(i, mask1)
      ELSE
        i = IOR(i, mask2)
      ENDIF
      pyc_outcsr = i
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      SUBROUTINE  py_iload(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg, j
      INTEGER*2
     *            i, i1, i2, o
c
      CALL py_wait
      i1 = pyc_incsr1
      i2 = pyc_incsr2
      o  = pyc_outcsr
      CALL py_ilsel(arg)
      CALL py_mode(3)
      CALL py_alu(0, 1, 10)
      i = 0
      DO j=1,256
        pyc_index = i
        pyc_inlut = pyc_buf(j)
        i = i+1
      ENDDO
      CALL py_csr(i1,i2,o)
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      SUBROUTINE  py_oload(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            j, arg
      INTEGER*2
     *            i, k1, k2, mask1, mask2, i1, i2, o
      DATA
     *            mask1/'0177400'o/,
     *            mask2/'0000377'o/
c
      CALL py_wait
      i1 = pyc_incsr1
      i2 = pyc_incsr2
      o  = pyc_outcsr
      CALL py_mode(3)
      CALL py_alu(0, 1, 10)
      CALL py_olsel(arg)
      i = 0
      DO j=1,256
        pyc_index = i
        k1 = IAND(ISHFT(pyc_buf(j),8), mask1)
        k2 = IAND(pyc_buf(j), mask2)
        pyc_redgrn = IOR(k1,k2)
        pyc_blue = k2
        i = i+1
      ENDDO
      CALL py_csr(i1,i2,o)
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  py_mode(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg, mask2
      INTEGER*2
     *            i, j, mask1
      DATA
     *            mask1/'0177617'o/,
     *            mask2/'0000160'o/
c
      i = pyc_incsr2
      i = IAND(i, mask1)
      j = IAND(ISHFT(arg,4), mask2)
      pyc_incsr2 = IOR(i,j)
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      SUBROUTINE  py_alu(carry, mode, func)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            carry, mode, func, mask2, mask3
      INTEGER*2
     *            i, i1, i2, i3, mask1, mask4, cshft
      DATA
     *            cshft/15/,
     *            mask1/'0100000'o/,
     *            mask2/'0040000'o/,
     *            mask3/'0036000'o/,
     *            mask4/'0001777'o/
c
      i = carry
      i1 = IAND(ISHFT(i,cshft), mask1)
      i2 = IAND(ISHFT(mode ,14), mask2)
      i3 = IAND(ISHFT(func ,10), mask3)
      i = pyc_incsr2
      i = IAND(i, mask4)
      pyc_incsr2 = IOR(i1, IOR(i2, IOR(i3, i)))
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      SUBROUTINE  py_vidsel(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg, mask2
      INTEGER*2
     *            i, j, mask1
      DATA
     *            mask1/'0176377'o/,
     *            mask2/'0001400'o/
c
      i = pyc_incsr2
      i = IAND(i, mask1)
      j = IAND(ISHFT(arg,8), mask2)
      pyc_incsr2 = IOR(i,j)
      RETURN
      END
c
c------------------------------------------------------------------------------
c
      SUBROUTINE  py_bufsel(in, out)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            in, out
c
      CALL py_setin(in)
      CALL py_setout(out)
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      SUBROUTINE  py_setin(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg, mask2
      INTEGER*2
     *            i, j, mask1
      DATA
     *           mask1/'0177577'o/
     *           mask2/'0000200'o/
c
      i = pyc_incsr2
      i = IAND(i, mask1)
      j = IAND(ISHFT(arg, 7), mask2)
      pyc_incsr2 = IOR(i,j)
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      SUBROUTINE  py_setout(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg, mask2
      INTEGER*2
     *            i, j, mask1
      DATA
     *           mask1/'0177757'o/
     *           mask2/'0000020'o/
c
      i = pyc_outcsr
      i = IAND(i, mask1)
      j = IAND(ISHFT(arg, 4), mask2)
      pyc_outcsr = IOR(i,j)
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      SUBROUTINE  py_pass(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg
      INTEGER*2
     *            i, j, mask1, mask2
      DATA
     *            mask1/'0177767'o/,
     *            mask2/'0000010'o/
c
      IF (IAND(arg,1).eq.0) THEN
        i = pyc_incsr1
        pyc_incsr1 = IAND(i,mask1)
        CALL py_oldwait
      ELSE
        CALL py_oldwait
        i = pyc_incsr1
        pyc_incsr1 = IOR(i,mask2)
      ENDIF
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  py_oldwait
c
c...Even With QIO Stuff This Is Needed For PASS Mode Operation
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            j
      INTEGER*2
     *            i, mask1, mask2
      DATA
     *            mask1/'0000010'o/,
     *            mask2/'0000200'o/
c
 9001 FORMAT (' No Wait In Pass Mode')
 9002 FORMAT (' DT2651 Waited Too Long')
c
      i = pyc_incsr1
      IF (IAND(i,mask1).ne.0) THEN
        WRITE (*,9001)
        RETURN
      ENDIF
      DO j=1,200000
        i = pyc_incsr1
        IF (IAND(i,mask2).eq.0) THEN
          RETURN
        ENDIF
      ENDDO
      WRITE (*,9002)
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      SUBROUTINE  py_wait
c
c...QIO Version Of WAIT
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INTEGER*4
     *            ret, SYS$WAITFR
c
 9001 FORMAT (' DT2651 RET=', z8)
c
  100 ret = SYS$WAITFR(
     1                 %VAL(py_efn)
     *                )
      IF (py_iosb(1).ne.SS$_NORMAL) THEN
        WRITE (*,9001) py_iosb(1)
        py_iosb(1) = SS$_NORMAL
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      SUBROUTINE  py_exttim(arg)
c
c	WARNING:   This Waits 1 Second To Make Sure DT2651 Is In Sync
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg, mask2
      INTEGER*2
     *            i, j, mask1
      REAL*4
     *            x, y
      DATA
     *            mask1/'0177737'o/,
     *            mask2/'0000040'o/
c
      i = pyc_outcsr
      i = IAND(i,mask1)
      j = IAND(ISHFT(arg,5), mask2)
      pyc_outcsr = IOR(i,j)
      IF (j.ne.0) THEN
        pyc_sync = 1
      ELSE
        pyc_sync = 8
      ENDIF
      x = SECNDS(0.0)
  110 y = SECNDS(x)
      IF (y.lt.1.0) GO TO 110
      RETURN
      END
c
c-------------------------------------------------------------------------
c
      SUBROUTINE  py_dbp(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg
      INTEGER*2
     *            i1, i2, i3, i4, i5
c
 9001 FORMAT (' (',i3, ')   I1=',o7, '   I2=',o7, '   O=',o7,
     *        '   C=',o7, '   S=',o7)
c
      i1 = pyc_incsr1
      i2 = pyc_incsr2
      i3 = pyc_outcsr
      WRITE (*,9001) arg,i1,i2,i3
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  py_oldgo
c
      INCLUDE
     *            'devices.inc'
      INTEGER*2
     *            i, mask1
      DATA
     *            mask1/'0000200'o/
c
      i = pyc_incsr1
      pyc_incsr1 = IOR(i,mask1)
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      SUBROUTINE  py_go
c
c...QIO Version Of GO
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($IODEF)'
      INCLUDE
     *            '($SSDEF)'
      INTEGER*4
     *            ret, SYS$QIO
c
 9001 FORMAT (' py_GO Failed...RET=', z8)
c
  100 ret = SYS$QIO(
     1              %VAL(py_efn),
     2              %VAL(py_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              py_iosb,
     5             ,
     6             ,
     7              %VAL(1),
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        WRITE (*,9001) ret
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      SUBROUTINE  py_csr(i1, i2, o)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*2
     *            i1, i2, o
c
      pyc_outcsr = o
      pyc_incsr2 = i2
      pyc_incsr1 = i1
      RETURN
      END
c
c----------------------------------------------------------------------
c
      SUBROUTINE  py_lutload(nam)
c
      INCLUDE
     *            'devices.inc'
      CHARACTER*(*)
     *            nam
      INTEGER*4
     *            i
c
 9001 FORMAT (' Error Opening PYGEN.DAT')
 9002 FORMAT (' Error Reading ILUTs = ', i1)
 9003 FORMAT (' Error Reading OLUTs = ', i1)
 9004 FORMAT (' Loading PYGEN.DAT')
 9005 FORMAT (' Loading ', a)
 9006 FORMAT (' Error Opening ', a)
 9007 FORMAT (' Error Reading 8LUTs = ', i1)
c
c...Open (quitely) Requested Or Default LUT Data File
c
      IF ((LEN(nam).le.4).or.(LEN(nam).gt.64)) THEN
        OPEN (
     *        access='sequential',
     *        carriagecontrol='none',
     *        dispose='keep',
     *        err=100,
     *        form='unformatted',
     *        name='PYGEN.DAT',
     *        readonly,
     *        recl=128,
     *        recordtype='fixed',
     *        shared,
     *        status='old',
     *        unit=9
     *       )
      ELSE
        OPEN (
     *        access='sequential',
     *        carriagecontrol='none',
     *        dispose='keep',
     *        err=130,
     *        form='unformatted',
     *        name=nam,
     *        readonly,
     *        recl=128,
     *        recordtype='fixed',
     *        shared,
     *        status='old',
     *        unit=9
     *       )
      ENDIF
c
c...Load The Luts
c
      DO i=1,8
        READ (9,err=110,end=110) pyc_buf
        CALL py_iload(i-1)
      ENDDO
      DO i=1,8
        READ (9,err=120,end=120) pyc_buf
        CALL py_oload(i-1)
      ENDDO
      CLOSE (9)
      RETURN
c
  100 WRITE (*,9001)
      RETURN
  110 WRITE (*,9002) i
      CLOSE (9)
      RETURN
  120 WRITE (*,9003) i
      CLOSE (9)
      RETURN
  130 WRITE (*,9006) nam
      RETURN
  140 WRITE (*,9007) i
      CLOSE (9)
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      SUBROUTINE  py_display(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg, mask2
      INTEGER*2
     *            i, j, mask1
      DATA
     *            mask1/'0177577'o/,
     *            mask2/'0000200'o/
c
      i = pyc_outcsr
      i = IAND(i, mask1)
      j = IAND(ISHFT(arg,7), mask2)
      pyc_outcsr = IOR(i,j)
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  py_0clear
c
      INCLUDE
     *            'devices.inc'
c
      CALL py_ilsel(0)
      CALL py_olsel(0)
      CALL py_mode(0)
      CALL py_alu(1,0,3)
      CALL py_bufsel(0,0)
      CALL py_oldgo()
      CALL py_oldwait()
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  py_1clear
c
      INCLUDE
     *            'devices.inc'
c
      CALL py_oldwait()
      CALL py_ilsel(0)
      CALL py_olsel(0)
      CALL py_mode(0)
      CALL py_alu(1,0,3)
      CALL py_bufsel(1,1)
      CALL py_oldgo()
      CALL py_oldwait()
      CALL py_bufsel(0,0)
      CALL py_oldgo()
      CALL py_oldwait()
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  py_grab
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            ierr
c
  100 CALL py_pregrab(ierr)
      IF (ierr.ne.0) THEN
        RETURN
      ENDIF
      CALL py_go()
      CALL py_wait()
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  py_oldgrab
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            ierr
c
  100 CALL py_pregrab(ierr)
      IF (ierr.ne.0) THEN
        RETURN
      ENDIF
      CALL py_oldgo()
      CALL py_oldwait()
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      SUBROUTINE  py_setinv(arg)
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            arg
c
  100 IF (arg.ne.0) THEN
        pyc_invert = 1
      ELSE
        pyc_invert = 0
      ENDIF
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  py_realtime
c
c...Enable Continuous Video
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            ierr
      CHARACTER*1
     *            c
c
 9001 FORMAT (' Hit <RETURN> To Exit REALTIME Mode')
 9002 FORMAT (a)
c
  100 CALL py_pregrab(ierr)
      IF (ierr.ne.0) THEN
        RETURN
      ENDIF
      CALL py_pass(1)
c
c...Wait For Any Key To Exit
c
      WRITE (*,9001)
      READ  (*,9002,err=110,end=110) c
  110 CALL py_pass(0)
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      SUBROUTINE  py_pregrab(ierr)
c
c...Set Up Frame Grabbing Environment
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            ierr
c
 9001 FORMAT (' Cannot REALTIME Without External Sync')
c
  100 IF (pyc_sync.eq.0) THEN
        WRITE (*,9001)
        ierr = 1
        RETURN
      ENDIF
      CALL py_wait()
c      IF (pyc_invert.eq.0) THEN
c        CALL py_ilsel(0)
c      ELSE
c        CALL py_ilsel(1)
c      ENDIF
c      CALL py_olsel(0)
      CALL py_bufsel(0,0)
      CALL py_mode(0)
      CALL py_alu(0,0,0)
      ierr = 0
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      SUBROUTINE  py_unwindow
c
c...Restores OLUT To Strict Linear
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            i
c
  100 DO i=1,256
        pyc_buf(i) = i-1
      ENDDO
      CALL py_oload(0)
      RETURN
      END
