c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_sttopen
c
c...Open STT Channel For Timed I/O, Etc.
c
      INCLUDE
     *           'devices.inc'
      INCLUDE
     *           '($SSDEF)'
      INCLUDE
     *           '($IODEF)'
      CHARACTER*8
     *           sttname
      INTEGER*4
     *           ret, SYS$TRNLOG, SYS$ASSIGN, SYS$SETEF, SYS$QIOW,
     *           nsttname, i
c
  100 ret=SYS$TRNLOG(
     1               'STT$DEV',
     2               nsttname,
     3               sttname,
     4              ,
     5              ,
     6
     *              )
      ret=SYS$ASSIGN(
     1               sttname(1:nsttname),
     2               stt_chan,
     3              ,
     4
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_sttopen = 1
        RETURN
      ENDIF
c
c...EFN Initialization
c
      stt_efn = 39
      ret = SYS$SETEF(%VAL(stt_efn))
      stt_iosb(1) = SS$_NORMAL
c
c...Flush The TypeAhead Buffer
c
      ret = SYS$QIOW(
     1              %VAL(stt_efn),
     2              %VAL(stt_chan),
     3              %VAL(IO$_TTYREADALL+IO$M_TIMED+IO$M_PURGE),
     4              stt_iosb,
     5             ,
     6             ,
     7              i,
     8              %VAL(0),
     9              %VAL(1),
     A             ,
     B             ,
     C
     *             )
      IF ((ret.ne.SS$_NORMAL).or.(stt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_sttopen = -2
        RETURN
      ENDIF
      dev_sttopen = 0
 9999 open (access='sequential',carriagecontrol='list',dispose='keep',
     * form='formatted',name='talk.sg0',status='unknown',unit=71)
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_sttclose
c
c...Return STT Channel
c
      INCLUDE
     *           'devices.inc'
      INTEGER*4
     *           ret, SYS$DASSGN
c
  100 ret = SYS$DASSGN(
     1                 %VAL(stt_chan)
     *                )
      stt_chan = 0
      stt_efn = 0
      dev_sttclose = 0
 9999 close (71)
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_sttread(buf, n)
c
c...Read String If There Is Anything
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      BYTE
     *              buf(*)
      INTEGER*4
     *              ret, SYS$QIOW, n, m
      INTEGER*2
     *              sttbuf(4)
c
c...Sense The Number Of Characters Waiting
c
  100 ret = SYS$QIOW(
     1              %VAL(stt_efn),
     2              %VAL(stt_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              stt_iosb,
     5             ,
     6             ,
     7              sttbuf,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_sttread = -1
        RETURN
      ENDIF
      IF (sttbuf(1).le.0) THEN
        dev_sttread = 0
        RETURN
      ENDIF
c
c...Read The Message
c
      m = MIN(sttbuf(1),n)
      ret = SYS$QIOW(
     1              %VAL(stt_efn),
     2              %VAL(stt_chan),
     3              %VAL(IO$_TTYREADALL+IO$M_TIMED),
     4              stt_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9              %VAL(3),
     A             ,
     B             ,
     C
     *             )
      IF ((ret.ne.SS$_NORMAL).or.(stt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_sttread = -2
        RETURN
      ENDIF
      buf(stt_iosb(2)+1) = 10
      dev_sttread = stt_iosb(2) + 1
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_sttwrite(buf, n)
c
c...Write String
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      INTEGER*4
     *              ret, SYS$QIOW, n
      BYTE
     *              buf(*)
c
  100 ret = SYS$QIOW(
     1              %VAL(stt_efn),
     2              %VAL(stt_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              stt_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_sttwrite = -1
        RETURN
      ENDIF
      dev_sttwrite = n
      RETURN
      END
c
c------------------------------------------------------------------------------
c
      INTEGER FUNCTION  stt_dump(yy,mm,dd,buf,line)
c
c...FORTRAN I/O To Spectrograph Archive File
c
      IMPLICIT
     *              NONE
      INTEGER
     *              yy, mm, dd
      BYTE
     *              buf(64,16), line(*), ff
      CHARACTER*24
     *              fn
      INTEGER
     *              ix, iy, i, n
      DATA
     *              ff/12/
c
 9001 FORMAT ('[-.SPECLOG]Y', i2.2, 'M', i2.2, 'D', i2.2, '.viu')
 9002 FORMAT (' STT_DUMP Error ', 3i6)
 9003 FORMAT (' STT_DUMP Cannot Open ', a)
 9004 FORMAT (64a1)
c
  100 WRITE (fn,9001,err=200) yy,mm,dd
      OPEN (
     *      access='append',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=210,
     *      form='formatted',
     *      name=fn,
     *      status='unknown',
     *      unit = 1
     *     )
      DO i=1,63
        IF (line(i+1).lt.32) THEN
          n = i
          GO TO 110
        ENDIF
      ENDDO
      n = 64
  110 WRITE (1,9004,err=220) (line(i),i=1,n)
      DO iy=1,16
        WRITE (1,9004,err=220) (buf(ix,iy),ix=1,64)
      ENDDO
      WRITE (1,9004) ff
      CLOSE (1)
      stt_dump = 0
      RETURN
c
c...Error Exits
c
  200 WRITE (*,9002) yy,mm,dd
      stt_dump = -1
      RETURN
  210 WRITE (*,9003) fn
      stt_dump = -2
      RETURN
  220 WRITE (*,9004)
      stt_dump = -3
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_sttrw(nout,out,nin,in,mode)
c
c...Read With Prompt And Terminatior Modification
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW, rtmask(4), rtdesc(2)
      INTEGER
     *            nout, nin, mode
      BYTE
     *            out(*), in(*)
c
c...Read Terminator Descriptor Block
c
  100 rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      IF (mode.eq.0) THEN
        rtmask(1)='00000000'x
        rtmask(2)='84000000'x
        rtmask(3)='00000000'x
        rtmask(4)='00000000'x
      ELSEIF (mode.gt.0) THEN
        rtmask(1)='00000000'x
        rtmask(2)='80000000'x
        rtmask(3)='00000000'x
        rtmask(4)='00000000'x
      ELSE
        rtmask(1)='00000000'x
        rtmask(2)='04000000'x
        rtmask(3)='00000000'x
        rtmask(4)='00000000'x
      ENDIF
c
c...Here to Issue the QIO request
c
      nout = nout+1
      out(nout) = 10
      ret=SYS$QIOW(
     1             %VAL(stt_efn),
     2             %VAL(stt_chan),
     3             %VAL(IO$_TTYREADPALL
     x              .or.IO$M_NOECHO
     x              .or.IO$M_PURGE
     x              .or.IO$M_TIMED
     x              .or.IO$M_TRMNOECHO),
     4             stt_iosb,
     5             ,
     6             ,
     7             in,
     8             %VAL(nin),
     9             %VAL(4),
     A             rtdesc,
     B             out,
     C             %VAL(nout)
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(stt_iosb(1).ne.SS$_NORMAL)) THEN
        nin = 0
        dev_sttrw = -1
      ELSE
        nin = stt_iosb(2)
        dev_sttrw = 0
      ENDIF
      nout = 0
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_sttsg(nout,out,nin,in,mode,timeout)
c
c...Read With Prompt And Terminatior Modification
c
c	Silicon Graphics Wants <CR>
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW, rtmask(4), rtdesc(2)
      INTEGER
     *            nout, nin, mode, timeout, i, j
      BYTE
     *            out(*), in(*)
c
c...Read Terminator Descriptor Block -- Colon Is Delimiter
c
  100 rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00000000'x
      rtmask(2)='04000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
c
c...Here to Issue the QIO request
c
      nout = nout+1
      out(nout) = 13
      write (71,9991) nout,(out(i),i=1,nout-1)
 9991 format ('SGXMT   N=', i3, ' >>', 120a1)
      ret=SYS$QIOW(
     1             %VAL(stt_efn),
     2             %VAL(stt_chan),
     3             %VAL(IO$_TTYREADPALL
     x              .or.IO$M_NOECHO
     x              .or.IO$M_PURGE
     x              .or.IO$M_TIMED
     x              .or.IO$M_TRMNOECHO),
     4             stt_iosb,
     5             ,
     6             ,
     7             in,
     8             %VAL(nin),
     9             %VAL(timeout),
     A             rtdesc,
     B             out,
     C             %VAL(nout)
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(stt_iosb(1).ne.SS$_NORMAL)) THEN
        nin = 0
        in(nin+1) = 0
        dev_sttsg = -1
      ELSE
c
c...Strip All Control And Non-Printing Characters, And Terminate For C
c
        nin = 0
        DO i=1,stt_iosb(2)
          IF ((in(i).gt.32).and.(in(i).lt.127)) THEN
            nin = nin+1
            in(nin) = in(i)
          ENDIF
        ENDDO
        in(nin+1) = 0
        dev_sttsg = 0
      write (71,9992) nin,(in(i),i=1,nin)
 9992 format ('SGRCV   N=', i3, ' >>', 120a1)
      ENDIF
      nout = 0
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_sttsgread(nin,in)
c
c...Read If Anything Is Present
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW
      INTEGER*2
     *            sttbuf(4)
      INTEGER
     *            nin, rtdesc(2), rtmask(4), nmax, i, n
      BYTE
     *            in(*), buf(132)
c
c...Sense The Number Of Characters Waiting
c
  100 nmax = nin
      nin = 0
      in(nin+1) = 0
      ret = SYS$QIOW(
     1              %VAL(stt_efn),
     2              %VAL(stt_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              stt_iosb,
     5             ,
     6             ,
     7              sttbuf,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_sttsgread = -1
        RETURN
      ENDIF
      n = sttbuf(1)
      IF (n.le.0) THEN
        dev_sttsgread = 0
        RETURN
      ENDIF
c
c...Read Whatever Was There
c
      rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00000000'x
      rtmask(2)='00000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
      ret=SYS$QIOW(
     1             %VAL(stt_efn),
     2             %VAL(stt_chan),
     3             %VAL(IO$_TTYREADALL
     x              .or.IO$M_NOECHO
     x              .or.IO$M_TRMNOECHO),
     4             stt_iosb,
     5             ,
     6             ,
     7             in,
     8             %VAL(n),
     9             %VAL(3),
     A             rtdesc,
     B            ,
     C
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(stt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_sttsgread = -2
        RETURN
      ENDIF
c
c...Copy And Strip Useless Junk
c
      DO i=1,stt_iosb(2)
        IF ((in(i).gt.32).and.(in(i).lt.127)) THEN
          nin = nin+1
          in(nin) = in(i)
        ENDIF
      ENDDO
      in(nin+1) = 0
      write (71,9991) nin,(in(i),i=1,nin)
 9991 format ('SGREAD  N=', i3, ' >>', 120a1)
c
c...Return If Nothing Of Any Interest Or A Colon Was Found
c
      IF (nin.le.0) THEN
        dev_sttsgread = 0
        RETURN
      ENDIF
      DO i=1,nin
        IF (in(i).eq.':') THEN
          dev_sttsgread = 0
          RETURN
        ENDIF
      ENDDO
c
c...Read The Rest Of An Iteresting Message
c
      rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00000000'x
      rtmask(2)='04000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
      ret=SYS$QIOW(
     1             %VAL(stt_efn),
     2             %VAL(stt_chan),
     3             %VAL(IO$_TTYREADALL
     x              .or.IO$M_NOECHO
     x              .or.IO$M_TRMNOECHO),
     4             stt_iosb,
     5             ,
     6             ,
     7             buf,
     8             %VAL(132),
     9             %VAL(3),
     A             rtdesc,
     B            ,
     C
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(stt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_sttsgread = -2
        RETURN
      ENDIF
c
c...Copy And Strip Useless Junk
c
      DO i=1,stt_iosb(2)
        IF ((buf(i).gt.32).and.(buf(i).lt.127)) THEN
          nin = nin+1
          in(nin) = buf(i)
        ENDIF
      ENDDO
      in(nin+1) = 0
      write (71,9992) nin,(in(i),i=1,nin)
 9992 format ('SGRMORE N=', i3, ' >>', 120a1)
      dev_sttsgread = 0
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_sttsgwrite(nout,out)
c
c...Write But Do Not Wait For Reply
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW
      INTEGER
     *            nout, i
      BYTE
     *            out(*)
c
c...Silicon Graphics Wants A <CR>
c
  100 nout = nout+1
      out(nout) = 13
      write (71,9991) nout,(out(i),i=1,nout-1)
 9991 format ('SGWRITE N=', i3, ' >>', 120a1)
      ret = SYS$QIOW(
     1              %VAL(stt_efn),
     2              %VAL(stt_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              stt_iosb,
     5             ,
     6             ,
     7              out,
     8              %VAL(nout),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_sttsgwrite = -1
        RETURN
      ENDIF
      dev_sttsgwrite = 0
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_sttmeter(t1,t2,t3,d1,d2,d3,p1,p2,p3)
c
c...Get The Meter String
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            ret, SYS$QIOW, rtdesc(2), rtmask(4)
      CHARACTER*(*)
     *            t1, t2, t3, d1, d2, d3, p1, p2, p3
      BYTE
     *            buf(3), get(70)
c
c...Mark All Values As Failure
c
  100 p1(1:1) = '*'
      p2(1:1) = '*'
      p3(1:1) = '*'
      d1(1:1) = '*'
      d2(1:1) = '*'
      d3(1:1) = '*'
      p1(1:1) = '*'
      p2(1:1) = '*'
      p3(1:1) = '*'
c
c...Purge The TypeAhead Buffer
c
      ret = SYS$QIOW(
     1               %VAL(stt_efn),
     2               %VAL(stt_chan),
     3               %VAL(IO$_READVBLK+IO$M_PURGE+IO$M_TIMED),
     4               stt_iosb,
     5              ,
     6              ,
     7               get,
     8               %VAL(0),
     9               %VAL(1),
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(stt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_sttmeter = -1
        RETURN
      ENDIF
c
c...Prompt First Meter In String
c
      buf(1) = '#'
      buf(2) = '0'
      buf(3) = '0'
      ret = SYS$QIOW(
     1               %VAL(stt_efn),
     2               %VAL(stt_chan),
     3               %VAL(IO$_WRITEVBLK+IO$M_TIMED),
     4               stt_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(3),
     9               %VAL(3),
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(stt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_sttmeter = -2
        RETURN
      ENDIF
c
c...Read Known Number Of Digits With No Terminator
c
      rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00000000'x
      rtmask(2)='00000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
      ret = SYS$QIOW(
     1               %VAL(stt_efn),
     2               %VAL(stt_chan),
     3               %VAL(IO$_READVBLK+IO$M_NOECHO+IO$M_TIMED),
     4               stt_iosb,
     5              ,
     6              ,
     7               get,
     8               %VAL(69),
     9               %VAL(3),
     A               rtdesc,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(stt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_sttmeter = -3
        RETURN
      ENDIF
c
c...Crack The Pressures
c
      p1(1:1) = '5'
      p1(2:2) = CHAR(ZEXT(get( 8)))
      p1(3:3) = CHAR(ZEXT(get( 9)))
      p1(4:4) = '.'
      p1(5:5) = CHAR(ZEXT(get(10)))
      p2(1:1) = '5'
      p2(2:2) = CHAR(ZEXT(get(11)))
      p2(3:3) = CHAR(ZEXT(get(12)))
      p2(4:4) = '.'
      p2(5:5) = CHAR(ZEXT(get(13)))
      p3(1:1) = '5'
      p3(2:2) = CHAR(ZEXT(get(19)))
      p3(3:3) = CHAR(ZEXT(get(20)))
      p3(4:4) = '.'
      p3(5:5) = CHAR(ZEXT(get(21)))
c
c...Crack The Dew Points
c
      IF (IAND(ZEXT(get(30)),8).eq.0) THEN
        d1(1:1) = '-'
      ELSE
        d1(1:1) = '+'
      ENDIF
      d1(2:2) = CHAR(ZEXT(get(22)))
      d1(3:3) = CHAR(ZEXT(get(23)))
      d1(4:4) = '.'
      d1(5:5) = CHAR(ZEXT(get(24)))
      IF (IAND(ZEXT(get(30)),4).eq.0) THEN
        d2(1:1) = '-'
      ELSE
        d2(1:1) = '+'
      ENDIF
      d2(2:2) = CHAR(ZEXT(get(31)))
      d2(3:3) = CHAR(ZEXT(get(32)))
      d2(4:4) = '.'
      d2(5:5) = CHAR(ZEXT(get(33)))
c
c...Crack The Temperatures
c
      IF (IAND(ZEXT(get(30)),2).eq.0) THEN
        t1(1:1) = '-'
      ELSE
        t1(1:1) = '+'
      ENDIF
      t1(2:2) = CHAR(ZEXT(get(34)))
      t1(3:3) = CHAR(ZEXT(get(35)))
      t1(4:4) = '.'
      t1(5:5) = CHAR(ZEXT(get(41)))
      t1(6:6) = CHAR(ZEXT(get(42)))
      IF (IAND(ZEXT(get(30)),1).eq.0) THEN
        t2(1:1) = '-'
      ELSE
        t2(1:1) = '+'
      ENDIF
      t2(2:2) = CHAR(ZEXT(get(43)))
      t2(3:3) = CHAR(ZEXT(get(44)))
      t2(4:4) = '.'
      t2(5:5) = CHAR(ZEXT(get(45)))
      t2(6:6) = CHAR(ZEXT(get(46)))
      IF (IAND(ZEXT(get(52)),8).eq.0) THEN
        t3(1:1) = '-'
      ELSE
        t3(1:1) = '+'
      ENDIF
      t3(2:2) = CHAR(ZEXT(get(53)))
      t3(3:3) = CHAR(ZEXT(get(54)))
      t3(4:4) = '.'
      t3(5:5) = CHAR(ZEXT(get(55)))
      t3(6:6) = CHAR(ZEXT(get(56)))
      dev_sttmeter = 0
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_sttlisten(nin,in)
c
c...Read If Anything Is Present
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW
      INTEGER*2
     *            sttbuf(4)
      INTEGER
     *            nin, rtdesc(2), rtmask(4), nmax, i, n
      BYTE
     *            in(*), buf(132)
c
c...Sense The Number Of Characters Waiting
c
  100 nmax = nin
      nin = 0
      in(nin+1) = 0
      ret = SYS$QIOW(
     1              %VAL(stt_efn),
     2              %VAL(stt_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              stt_iosb,
     5             ,
     6             ,
     7              sttbuf,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_sttlisten = -1
        RETURN
      ENDIF
      n = sttbuf(1)
      IF (n.le.0) THEN
        dev_sttlisten = 0
        RETURN
      ENDIF
c
c...Read One Character
c
      n = 1
      rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00000000'x
      rtmask(2)='00000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
      ret=SYS$QIOW(
     1             %VAL(stt_efn),
     2             %VAL(stt_chan),
     3             %VAL(IO$_TTYREADALL
     x              .or.IO$M_NOECHO
     x              .or.IO$M_TRMNOECHO),
     4             stt_iosb,
     5             ,
     6             ,
     7             in,
     8             %VAL(n),
     9             %VAL(3),
     A             rtdesc,
     B            ,
     C
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(stt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_sttlisten = -2
        RETURN
      ENDIF
c
c...Copy And Strip Useless Junk
c
      DO i=1,stt_iosb(2)
        IF ((in(i).gt.32).and.(in(i).lt.127)) THEN
          nin = nin+1
          in(nin) = in(i)
        ENDIF
      ENDDO
      write (71,9991) nin,(in(i),i=1,nin)
 9991 format ('LISTEN  N=', i3, ' >>', 120a1)
      in(nin+1) = 0
      dev_sttlisten = 0
      RETURN
      END
