c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ttopen
c
c...Open TT Channel For Timed I/O, Etc.
c
      INCLUDE
     *           'devices.inc'
      INCLUDE
     *           '($SSDEF)'
      CHARACTER*8
     *           ttname
      INTEGER*4
     *           ret, SYS$TRNLOG, SYS$ASSIGN, SYS$SETEF,
     *           nttname
c
  100 ret=SYS$TRNLOG(
     1               'TT',
     2               nttname,
     3               ttname,
     4              ,
     5              ,
     6
     *              )
      ret=SYS$ASSIGN(
     1               ttname(1:nttname),
     2               tt_chan,
     3              ,
     4
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_ttopen = 1
        RETURN
      ENDIF
      tt_efn = 36
      ret = SYS$SETEF(%VAL(tt_efn))
      tt_iosb(1) = SS$_NORMAL
      dev_ttopen = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ttclose
c
c...Return TT Channel
c
      INCLUDE
     *           'devices.inc'
      INTEGER*4
     *           ret, SYS$DASSGN
c
  100 ret = SYS$DASSGN(
     1                 %VAL(tt_chan)
     *                )
      tt_chan = 0
      tt_efn = 0
      dev_ttclose = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_qter
c
c...FORTRAN Version of Forth's QTER.
c
c	RETURN:
c		<0:		Failure In System Calling
c		0:		No Character
c		1-255:		Character Touched
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      INTEGER*4
     *              ret, SYS$QIOW, ttchar
c
c...Sense The Number Of Characters Waiting
c
  100 ret = SYS$QIOW(
     1              %VAL(tt_efn),
     2              %VAL(tt_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              tt_iosb,
     5             ,
     6             ,
     7              tt_buf,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_qter = -1
        RETURN
      ENDIF
      IF (tt_buf(1).le.0) THEN
        dev_qter = 0
        RETURN
      ENDIF
c
c...Read The Typed Character
c
      ttchar=0
      ret = SYS$QIOW(
     1              %VAL(tt_efn),
     2              %VAL(tt_chan),
     3              %VAL(IO$_TTYREADALL+IO$M_NOECHO),
     4              tt_iosb,
     5             ,
     6             ,
     7              ttchar,
     8              %VAL(1),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF ((ret.ne.SS$_NORMAL).or.(ttchar.eq.0)) THEN
        dev_qter = -2
        RETURN
      ENDIF
      dev_qter = ttchar
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_tttread(buf, n)
c
c...Timed read -- Return Is Actual Number read
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      INTEGER*4
     *              ret, SYS$QIOW, n
      BYTE
     *              buf(*)
c
  100 ret = SYS$QIOW(
     1              %VAL(tt_efn),
     2              %VAL(tt_chan),
     3              %VAL(IO$_READVBLK+IO$M_TIMED+IO$M_PURGE),
     4              tt_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9              %VAL(3),
     A             ,
     B             ,
     C
     *             )
      IF ((ret.ne.SS$_NORMAL).or.(tt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_tttread = -1
        RETURN
      ENDIF
      dev_tttread = tt_iosb(2)
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_tttwrite(buf, n)
c
c...Output To TT
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      INTEGER*4
     *              ret, SYS$QIOW, n
      BYTE
     *              buf(*)
c
  100 ret = SYS$QIOW(
     1              %VAL(tt_efn),
     2              %VAL(tt_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              tt_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF ((ret.ne.SS$_NORMAL).or.(tt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_tttwrite = -1
        RETURN
      ENDIF
      dev_tttwrite = tt_iosb(2)
      RETURN
      END
