c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_vsopen
c
c...Open The Video Switch Terminal Line -- VMS Sets It To 600 Baud, Etc.
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INTEGER
     *            ret, SYS$ASSIGN, SYS$SETEF, DEV_SLEEP
c
  100 ret = SYS$ASSIGN(
     1                 'VS$DEV',
     2                 vs_chan,
     3                ,
     4
     *                )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_vsopen = 1
        RETURN
      ENDIF
      vs_efn = 30
      ret = SYS$SETEF(%VAL(vs_efn))
      vs_iosb(1) = SS$_NORMAL
c
c...Preset To 1,1
c
      CALL vs_select2(7)
      CALL vs_select2(11)
      ret = DEV_SLEEP(0.5)
      CALL vs_select2(7)
      dev_vsopen = 0
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_vsclose
c
c...Give Back Video Switch Terminal Line
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            ret, SYS$DASSGN
c
  100 ret = SYS$DASSGN(
     1                 %VAL(vs_chan)
     *                )
      vs_chan = 0
      vs_efn = 0
      dev_vsclose = 0
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  vs_select1(n)
c
c...Sequencer For Video Output 1
c
      INCLUDE
     *            'devices.inc'
      INTEGER
     *            n, err, DEV_SLEEP
c
c...Sequencer
c
  100 CALL vs_xmit(128+n)
      CALL vs_1ms
      CALL vs_xmit(128+n)
      CALL vs_1ms
      CALL vs_xmit(128+n)
      CALL vs_1ms
      CALL vs_xmit(0)
      err = DEV_SLEEP(0.8)
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  vs_select2(n)
c
c...Sequencer For Video Output 2
c
      INCLUDE
     *            'devices.inc'
      INTEGER
     *            n, err, DEV_SLEEP
c
c...Sequencer
c
  100 CALL vs_xmit(128+n)
      CALL vs_1ms
      CALL vs_xmit(128+n)
      CALL vs_1ms
      CALL vs_xmit(128+n)
      CALL vs_1ms
      CALL vs_xmit(0)
      err = DEV_SLEEP(0.05)
c
      CALL vs_xmit(128+11)
      CALL vs_1ms
      CALL vs_xmit(128+11)
      CALL vs_1ms
      CALL vs_xmit(128+11)
      CALL vs_1ms
      CALL vs_xmit(0)
      err = DEV_SLEEP(0.05)
c
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      SUBROUTINE  vs_xmit(n)
c
c...Transmit A Single Byte Of Value N
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            ret, SYS$QIO, SYS$WAITFR, n
c
 9001 FORMAT (' Video Switch QIO Failed ', 3z10)
c
  100 ret = SYS$QIO(
     1              %VAL(vs_efn),
     2              %VAL(vs_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              vs_iosb,
     5             ,
     6             ,
     7              n,
     8              %VAL(1),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        WRITE (*,9001) ret,vs_iosb(1),vs_iosb(2)
        RETURN
      ENDIF
      ret = SYS$WAITFR(
     1                 %VAL(vs_efn)
     *                )
      IF (vs_iosb(1).ne.SS$_NORMAL) THEN
        WRITE (*,9001) vs_iosb(1),vs_iosb(2)
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      SUBROUTINE  vs_1ms
c
c...Wait 1 Millisecond
c
      INCLUDE
     *            'devices.inc'
      PARAMETER
     *            n = 12
      INTEGER
     *            i
      REAL
     *            x
c
  100 DO i=1,n
        x = REAL(i-1)/REAL(n)
        vs_dummy = SIN(x)
      ENDDO
      RETURN
      END
