      SUBROUTINE  zetaproc
c
c...Try Different Values For ZETACUR To Get Best "Focus"
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            mq = 9,
     *            zfrst = -0.100,
     *            zstep =  0.050
      REAL
     *            z, zsave, zq(MQ), nq(MQ), num, den, nmin
      INTEGER
     *            i, n, q, imin
      CHARACTER*28
     *            lb
c
 9001 FORMAT ('H=',i1, ' P=',i1, '  Z=',f6.3, '  N=',i7)
 9002 FORMAT ('ZETAPROC Sets ZETACUR=', f6.3)
c
c...Save X,Y,M And ZETACUR
c
  100 IF ((nstar.le.0).or.(nframe.le.0)) RETURN
      DO i=1,nstar
        partmp(i,1) = ixst(i)
        partmp(i,2) = iyst(i)
        partmp(i,3) = imst(i)
      ENDDO
      zsave = zetacur
c
c...Brute Force Search
c
      DO q=1,MQ
        z = ZFRST + (q-1)*ZSTEP
        CALL zetaeval(z,n)
        zq(q) = z
        nq(q) = n
        WRITE (lb,9001) holder,barpos,z,n
        CALL x_fortwrite(lb)
      ENDDO
c
c...Return Things As If Nothing Has Happened
c
      DO i=1,nstar
        ixst(i) = partmp(i,1)
        iyst(i) = partmp(i,2)
        imst(i) = partmp(i,3)
      ENDDO
      zetacur = zsave
c
c...Best Value For Zeta Is Minimum Number Of Detections
c
      imin = 1
      nmin = nq(imin)
      DO i=2,MQ
        IF (nq(i).lt.nmin) THEN
          imin = i
          nmin = nq(i)
        ENDIF
      ENDDO
      IF (imin.le.1) THEN
        zetacur = zq(1)
      ELSEIF (imin.ge.MQ) THEN
        zetacur = zq(MQ)
      ELSE
        num = nq(imin+1)-nq(imin)
        den = nq(imin+1)+nq(imin-1) - 2.0*nq(imin)
        IF (den.eq.0.0) THEN
          zetacur = zq(imin)
        ELSE
          zetacur = zq(imin+1) - ZSTEP*(num/den + 0.5)
        ENDIF
      ENDIF
      WRITE (lb,9002) zetacur
      CALL x_fortwrite(lb)
      RETURN
      END
