      SUBROUTINE  dotshist_1
c
c...Process (TINY-SKY) Histogram
c
c	NOTE:  Histogram Biased Around 128.  Look For Peak Near There To
c	       Avoid Confusion By Saturation, Torn Emulsion, etc.
c
      INCLUDE
     *            '../all1.inc'
      PARAMETER
     *            crazy = (9*mcols*mrows)/10
      INTEGER
     *            i, j, i0
      REAL
     *            z1, z2, z3, a, b, c, imax, zmax, test, fract
c
c...Test For Sanity
c
  100 j = wholehist(127)+wholehist(128)+wholehist(129)
      IF ((j.gt.CRAZY).and.(nomsky.ge.200.0)) THEN
        wholewp = 128
        wholeww = -1
        GO TO 120
      ENDIF
c
c...Is 128 The Maximum?
c
      i = 0
      IF   ((wholehist(128).ge.wholehist(127))
     * .and.(wholehist(128).ge.wholehist(129))) GO TO 110
c
c...Search For The Maximum
c
      DO j=1,126
        IF   ((wholehist(128+j).ge.wholehist(128+j-1))
     *   .and.(wholehist(128+j).ge.wholehist(128+j+1))) THEN
          i = j
          GO TO 110
        ENDIF
        IF   ((wholehist(128-j).ge.wholehist(128-j-1))
     *   .and.(wholehist(128-j).ge.wholehist(128-j+1))) THEN
          i = -j
          GO TO 110
        ENDIF
      ENDDO
      i = 0
  110 CONTINUE
c
c...Use Parabolic Interpolation To Improve Estimator
c
      z1 = wholehist(128+i-1)
      z2 = wholehist(128+i  )
      z3 = wholehist(128+i+1)
      imax = 128 + i
      zmax = z2
      c = 0.5*(z1+z3 - 2.0*z2)
      IF (c.ne.0.0) THEN
        b = (z3-z2) - c*(2.0*imax + 1.0)
        a = z2 - b*imax - c*imax*imax
        imax = imax + 0.5 - (z3-z2)/(2.0*c)
        zmax = a + b*imax + c*imax*imax
      ENDIF
c
c...Is The Peak Too Close To The Edge???
c
      IF (imax.le.1.0) THEN
        wholewp = imax
        wholeww = 0.5*imax
        GO TO 120
      ENDIF
c
c...Is This A Very Narrow Spike?
c
      test = 0.5*zmax
      i0 = imax
      IF (wholehist(i0).le.test) THEN
        wholewp = imax
        wholeww = 0.5
        GO TO 120
      ENDIF
c
c...Search On Down Side For Half Power Point
c
      DO i=i0,1,-1
        IF (wholehist(i-1).le.test) THEN
          b = test           - wholehist(i)
          c = wholehist(i-1) - wholehist(i)
          IF (c.eq.0.0) THEN
            fract = i - 0.5
          ELSE
            fract = i - b/c
          ENDIF
          wholewp = imax
          wholeww = imax - fract
          GO TO 120
        ENDIF
      ENDDO
c
c...No Half Power Point Found.  Guess.
c
      wholewp = imax
      wholeww = 0.7*imax
c
c...Common Exit To Update Frame Values
c
  120 frprewp(nframe) = wholewp
      frpreww(nframe) = wholeww
      RETURN
      END
