      SUBROUTINE  fitsbinit
c
c...Initialize The FITS Header For The BIAS Frame
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            nbiasline = 36*NBIASHD
      INTEGER
     *            i, j, k, l
c
c              0        1         2         3
c              12345678901234567890123456789012
c
 9000 FORMAT (q, a)
 9001 FORMAT ('SIMPLE  =                    T', 50x)
 9002 FORMAT ('BITPIX  =                  -32', 50x)
 9003 FORMAT ('NAXIS   =                    2', 50x)
 9004 FORMAT ('NAXIS1  =                 ',i4,  50x)
 9005 FORMAT ('NAXIS2  =                 ',i4,  50x)
 9006 FORMAT ('BZERO   =                  0.0', 50x)
 9007 FORMAT ('BSCALE  =                  1.0', 50x)
 9008 FORMAT ('COMMENT =                 ',i4,  50x)
 9009 FORMAT ('END', 77x)
 9010 FORMAT ('OBJECT  =                 BIAS', 50x)
c
c...Clear Pixels Beyond Image In Last FITS Block
c
  100 DO i=1,NBIASDM
        biasdum(i) = 0
      ENDDO
c
c...Initialize A Full-Length FITS Header
c
      DO i=1,NBIASLINE-1
        WRITE (biaschead(i),9008) i
      ENDDO
      WRITE (biaschead(NBIASLINE),9009)
c
c...Initialize The FITS Header
c
      WRITE (biaschead( 1),9001)
      WRITE (biaschead( 2),9002)
      WRITE (biaschead( 3),9003)
      WRITE (biaschead( 4),9004) NCOLS
      WRITE (biaschead( 5),9005) NROWS
      WRITE (biaschead( 6),9006)
      WRITE (biaschead( 7),9007)
      WRITE (biaschead( 8),9010)
c
c...Copy Into FITS Block
c
      l = 1
      k = 0
      DO i=1,36*NBIASHD
        DO j=1,80
          k = k+1
          IF (k.gt.2880) THEN
            l = l+1
            k = k-2880
          ENDIF
          biashdr(k,l) = ICHAR(biaschead(i)(j:j))
        ENDDO
      ENDDO
      RETURN
      END
