#include	<errno.h>
#include	<signal.h>
#include	<sys/wait.h>
#include	<sys/types.h>
#include	<sys/mtio.h>
#define	MTDEV	"/dev/8mmnr"
#define	ERRORFILE	"errs.8mm"
void	fitscatch();
static int	fitsfd = 0;
static int	fitsnask = 0;
static int	fitsnget = 0;
static int	fitsnreq = 0;
static int	fitschild = 0;
/*
 ***************************************************************************
 *
 *	Open 8mm Tape.  Return FD As A Flag.
 */
c_fitsopen_()
{
	if (fitsfd < 3) {
		if ((fitsfd = open(MTDEV,2)) >= 3)
			fitsblock_();
			unlink(ERRORFILE);
			fitsnreq = 0;
	}
	return(fitsfd);
}
/*
 ***************************************************************************
 *
 *	Open 8mm Tape For ReadOnly.  Return FD As A Flag.
 */
c_fitsopenr_()
{
	if (fitsfd < 3) {
		if ((fitsfd = open(MTDEV,0)) >= 3)
			fitsblock_();
	}
	return(fitsfd);
}
/*
 ***************************************************************************
 *
 *	Close The 8mm Tape.  Note That This Automatically Writes EOF
 */
c_fitsclose_()
{
	int stat;

	if (fitsfd >= 3) {
		if (fitschild > 0)
			waitpid(fitschild, &stat, NULL);
		close(fitsfd);
	}
	fitsnask = fitsnget = fitschild = fitsfd = 0;
}
/*
 ****************************************************************************
 *
 *	Write The File
 */
c_fitswrite_(buf,nbuf,id)
char buf[],id[];
int *nbuf;
{
	int i, fd;
	char lb[64];

	if (fitsfd < 3)
		return(-2);
	fitsnreq++;
	signal(SIGCLD, fitscatch);
	fitsnask = (*nbuf);
	fitsnget = 0;
	if ((fitschild=fork()) != 0) {
/*
 *   Parent Returns With ERROR Status
 */
		if (fitschild < 0)
			return(-1);
		else
			return(0);
/*
 *   Child Lives Long Enough To Do I/O
 */
	} else {
		for (i=0; i<5; i++) {
			fitsnget = write(fitsfd, buf, fitsnask);
			if (fitsnget == fitsnask)
				exit(0);
			if ((fd=open(ERRORFILE,2)) < 3)
				fd = creat(ERRORFILE, 0644);
			else
				lseek(fd, 0, 2);
			if (fd >= 3) {
				sprintf(lb, "F=%d X=%d R=%d E=%d ID=%s\n",
					fitsnreq,fitsnask,fitsnget,errno,id);
				write(fd, lb, strlen(lb));
				close(fd);
			}
			sleep(1);
		}
		exit(0);
	}
}
/*
 ***************************************************************************
 *
 *	Write The File NOW!
 *
 *	WARNING.  This is used to dump the entire star list, which is
 *		216*(84*2880) long.  Since 216 is a multiple of 12,
 *		which is the size of an image, this logic makes a tape
 *		that is consistent with FITS packing of (12*84)*2880.
 *		Full last block stuff is not included since this is
 *		not a general purpose routine.
 */
c_fitswnow_(buf,nbuf)
char buf[];
int *nbuf;
{
	int i, n, chunk;
	char lb[64];

	if (fitsfd < 3)
		return(-2);
	fitsnask = (*nbuf);
	chunk = 12*(84*2880);
	n = ((fitsnask-1)/chunk)+1;
	for (i=0; i<n; i++) {
		fitsnget = write(fitsfd, &buf[i*chunk], chunk);
		sprintf(lb, "WNOW I=%d X=%d R=%d E=%d", i,chunk,fitsnget,errno);
		x_write1_(lb);
		if (fitsnget != chunk)
			return(-1);
	}
	return(0);
}
/*
 *************************************************************************
 *
 *	Read A File
 */
c_fitsread_(buf,nbuf)
char buf[];
int *nbuf;
{
	int i;

	if ((i=read(fitsfd, buf, *nbuf)) < 0)
		return(-errno);
	else {
		if (i == (*nbuf))
			return(0);
		else
			return(-999);
	}
}
/*
 ****************************************************************************
 *
 *	Get And Examine Tape Status Bits
 */
c_fitsstat_(buf)
int buf[];
{
	int i;
	struct mtget stat;
	struct mtblkinfo block;
	struct mt_capablity bits;

	if ((i=ioctl(fitsfd, MTIOCGET, &stat)) < 0)
		return(-1);
	buf[0] = stat.mt_dposn;
	buf[1] = stat.mt_dsreg;
	buf[2] = stat.mt_erreg;
	buf[3] = stat.mt_resid;
	buf[4] = stat.mt_type;
	if ((i=ioctl(fitsfd, MTCAPABILITY, &bits)) < 0)
		return(-2);
	buf[5] = bits.mtcapablity;
	buf[6] = bits.mtsubtype;
	return(0);
}
/*
 ***************************************************************************
 *
 *	Change Tape Blocking Factor To MAXIMUM
 *
 *	WARNING!  For a single WRITE request of the size of the entire
 *		  FITS image to work (i.e., not return errno=-22), the
 *		  blocksize here must exactly divide the request size.
 *
 *		  See explanation in FITS.INC for further details.
 *		  Largest possible size is (480*512) = 245760 sets
 *		  maximum of 85 FITS blocks.
 */
fitsblock_()
{
	int i;
	struct mtop op;

	op.mt_op = MTSCSI_SETFIXED;
	op.mt_count = (84*2880);
	if ((i=ioctl(fitsfd, MTSPECOP, &op)) < 0)
		printf("IOCTL-SPEC %d %d\n", i,errno);
}
/*
 *****************************************************************************
 *
 *	Catch The Death Of Child Interrupt
 */
void fitscatch()
{
	int err, stat;

	if (fitsnask == fitsnget)
		err = 0;
	else
		err = errno;
	fitssignal_(&err);
	fitsnask = fitsnget = fitschild = 0;
	signal(SIGCLD, SIG_IGN);
}
/*
 *****************************************************************************
 *
 *	Minimal Tape Operations
 */
c_fitsop_(mode)
int *mode;
{
	struct mtop op;
	int i;
	char lb[64];

	if (fitsfd < 3)
		return(-2);
	switch (*mode) {
/*
 *   ==1 Means Back Skip One File Mark
 */
	case 1:
		op.mt_op = MTBSF;
		op.mt_count = 1;
		if ((i=ioctl(fitsfd, MTIOCTOP, &op)) < 0)
			return(-errno);
		break;
/*
 *   ==2 Means Rewind
 */
	case 2:
		op.mt_op = MTREW;
		op.mt_count = 1;
		if ((i=ioctl(fitsfd, MTIOCTOP, &op)) < 0)
			return(-errno);
		break;
/*
 *   ==3 Means Write A File Mark
 */
	case 3:
		op.mt_op = MTWEOF;
		op.mt_count = 1;
		if ((i=ioctl(fitsfd, MTIOCTOP, &op)) < 0)
			return(-errno);
		break;
/*
 *   ==4 Means Go Offline And Unload
 */
	case 4:
		op.mt_op = MTOFFL;
		op.mt_count = 1;
		if ((i=ioctl(fitsfd, MTIOCTOP, &op)) < 0)
			return(-errno);
		op.mt_op = MTUNLOAD;
		op.mt_count = 1;
		if ((i=ioctl(fitsfd, MTIOCTOP, &op)) < 0)
			return(-errno);
		break;
/*
 *   Unknown
 */
	default:
		return(-4);
	}
	return(0);
}
