      SUBROUTINE  fitsundisk(id)
c
c...Recover Current Image To Disk
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            nhead = (NGRABHD*36)
      BYTE
     *            head(2880*NGRABHD)
      INTEGER
     *            nnam, nfn, c, r, id, i, n
      CHARACTER*64
     *            nam, fn
      CHARACTER*8
     *            key
      CHARACTER*20
     *            arg
      DOUBLE PRECISION
     *            z
      EQUIVALENCE
     *            (grabhdr(1,1),head(1))
c
 9001 FORMAT (a, i1)
 9002 FORMAT (a, i2)
 9003 FORMAT (a, i3)
 9004 FORMAT (f20.0)
 9005 FORMAT (i20)
 9006 FORMAT (i2)
c
c...Ignore Silly Call And Generate Appropraite FITS Header (Fool Tape Logic)
c
  100 IF (id.le.0) RETURN
      IF (id.le.9) THEN
        WRITE (fn,9001) dprefix(1:ndprefix),id
        nfn = ndprefix+1
      ELSEIF (id.le.99) THEN
        WRITE (fn,9002) dprefix(1:ndprefix),id
        nfn = ndprefix+2
      ELSE
        WRITE (fn,9003) dprefix(1:ndprefix),id
        nfn = ndprefix+3
      ENDIF
      CALL dataname(fn(1:nfn),nnam,nam)
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=nam(1:nnam),
     *      recordtype='fixed',
     *      recl=(NGRABBT/4),
     *      status='old',
     *      unit=1
     *     )
      CALL x_fortwrite('Reading '//nam(1:nnam))
      READ (1,rec=1) grabbuf
      CLOSE (1)
c
c...Return Image To DATA
c
      DO r=1,NROWS
        DO c=1,NCOLS
          data(c,r) = ZEXT(raw1(c,r))
        ENDDO
      ENDDO
c
c...Decode Header (Enough To Apply Scale)
c
      DO n=1,NHEAD
        DO i=1,8
          key(i:i) = CHAR(ZEXT(head((n-1)*80+i)))
        ENDDO
        DO i=1,20
          arg(i:i) = CHAR(ZEXT(head((n-1)*80+i+10)))
        ENDDO
        IF (key.eq.'PMMX    ') THEN
          READ (arg,9004,err=210) frx0(id)
        ELSEIF (key.eq.'PMMY    ') THEN
          READ (arg,9004,err=210) fry0(id)
        ELSEIF (key.eq.'PMMZ    ') THEN
          READ (arg,9004,err=210) frz0(id)
        ELSEIF (key.eq.'PMMA    ') THEN
          READ (arg,9004,err=210) fra0(id)
        ELSEIF (key.eq.'PMMLASER') THEN
          READ (arg,9004,err=210) frl0(id)
        ELSEIF (key.eq.'PMMTEMP ') THEN
          READ (arg,9004,err=210) frc0(id)
        ELSEIF (key.eq.'PMMNDENS') THEN
          READ (arg,9004,err=210) frd0(id)
        ELSEIF (key.eq.'PMMTIME ') THEN
          READ (arg,9004,err=210) frt0(id)
        ELSEIF (key.eq.'PMMEXPOS') THEN
          READ (arg,9005,err=210) frexp(id)
        ELSEIF (key.eq.'PMMDZX21') THEN
          READ (arg,9004,err=210) dzxcoef(2,1)
        ELSEIF (key.eq.'PMMDZY21') THEN
          READ (arg,9004,err=210) dzycoef(2,1)
        ELSEIF (key.eq.'PMMDZX22') THEN
          READ (arg,9004,err=210) dzxcoef(2,2)
        ELSEIF (key.eq.'PMMDZY23') THEN
          READ (arg,9004,err=210) dzycoef(2,3)
        ELSEIF (key.eq.'PMMMAGOF') THEN
          READ (arg,9004,err=210) magoffset
        ELSEIF (key.eq.'PMMMAGSL') THEN
          READ (arg,9004,err=210) magslope
        ELSEIF (key.eq.'PMMEFLAG') THEN
          READ (arg,9004,err=210) frflag(id)
        ELSEIF (key.eq.'PMMZCUR ') THEN
          READ (arg,9004,err=210) zetacur
        ELSEIF (key.eq.'PMMLLCX ') THEN
          READ (arg,9004,err=210) llcx
        ELSEIF (key.eq.'PMMLLCY ') THEN
          READ (arg,9004,err=210) llcy
        ELSEIF (key(1:6).eq.'PMMXCO') THEN
          READ (key(7:8),9006,err=210) i
          READ (arg,9004,err=210) xcoef(i)
        ELSEIF (key(1:6).eq.'PMMYCO') THEN
          READ (key(7:8),9006,err=210) i
          READ (arg,9004,err=210) ycoef(i)
        ENDIF
      ENDDO
      RETURN
c
  200 CALL x_fortwrite('Cannot Open '//nam(1:nnam))
      RETURN
  210 CALL x_fortwrite('Cannot Parse'//key)
      RETURN
      END
