      SUBROUTINE  datadump(c)
c
c...Dump Current Data Image to Disk File
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            nfits = 10,
     *            scale = 10.0,
     *            zero = 0.0
      CHARACTER*(*)
     *            c
      CHARACTER*80
     *            lb(NFITS)
      CHARACTER*10
     *            ob
      BYTE
     *            bb(2880)
      INTEGER
     *            i, nnam, j, nbb, ob1, ob2
      CHARACTER*64
     *            nam
      INTEGER*2
     *            sp(NCOLS,NROWS)
      EQUIVALENCE
     *            (sp(1,1),raw(1,1))
c
 9001 FORMAT ('SIMPLE  = ', 19x,  'T', ' /', 48x)
 9002 FORMAT ('BITPIX  = ', 18x, '16', ' /', 48x)
 9003 FORMAT ('NAXIS   = ', 19x,  '2', ' /', 48x)
 9004 FORMAT ('NAXIS1  = ', i20,       ' /', 48x)
 9005 FORMAT ('NAXIS2  = ', i20,       ' /', 48x)
 9006 FORMAT ('BZERO   = ', f20.3,     ' /', 48x)
 9007 FORMAT ('BSCALE  = ', f20.3,     ' /', 48x)
 9008 FORMAT ('OBJECT  = ', 10x, a,    ' /', 48x)
 9009 FORMAT ('INSTRUME= ', 10x, a,    ' /', 48x)
 9010 FORMAT ('END', 77x)
 9020 FORMAT ('''', a, '''')
 9021 FORMAT ('''PMM''')
c
c...The Sequencer Can Call This Routine With An Illegal Frame Number.
c	Just Ignore Such Calls
c
  100 IF (nframe.le.0) RETURN
      CALL dataname(c,nnam,nam)
      IF (nnam.le.3) RETURN
      j = nnam-3
      DO i=j,2,-1
        IF (nam(i-1:i-1).eq.'/') GO TO 110
      ENDDO
      i = 1
  110 WRITE (ob,9020) nam(i:j)
c
c...Construct A Simple FITS Header
c
      WRITE (lb( 1),9001)
      WRITE (lb( 2),9002)
      WRITE (lb( 3),9003)
      WRITE (lb( 4),9004) NCOLS
      WRITE (lb( 5),9005) NROWS
      WRITE (lb( 6),9006) ZERO
      WRITE (lb( 7),9007) SCALE
      WRITE (lb( 8),9008) ob
      WRITE (ob,9009)
      WRITE (lb( 9),9009) ob
      WRITE (lb(10),9010)
      nbb = 0
      DO j=1,NFITS
        DO i=1,80
          nbb = nbb+1
          bb(nbb) = ICHAR(lb(j)(i:i))
        ENDDO
      ENDDO
      DO i=nbb+1,2880
        bb(i) = 0
      ENDDO
c
c...Make An I*2 Image
c
      DO j=1,NROWS
        DO i=1,NCOLS
          sp(i,j) = MAX(-32768,MIN(32767,data(i,j)*SCALE))
        ENDDO
      ENDDO
c
c...Write File
c
      CALL dataname(c,nnam,nam)
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=nam(1:nnam),
     *      recordtype='fixed',
     *      recl=((NCOLS*NROWS)/2+720),
     *      status='unknown',
     *      unit=1
     *     )
      CALL x_fortwrite('Writing '//nam(1:nnam))
      WRITE (1,rec=1) bb,sp
      CLOSE (1)
      RETURN
c
  200 CALL x_fortwrite('Cannot Open '//nam(1:nnam))
      RETURN
      END
